/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/storage/v1/storage.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.bigquery.storage.v1;

/**
 *
 *
 * <pre>
 * Response from calling `ReadRows` may include row data, progress and
 * throttling information.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.storage.v1.ReadRowsResponse}
 */
public final class ReadRowsResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1.ReadRowsResponse)
    ReadRowsResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ReadRowsResponse.newBuilder() to construct.
  private ReadRowsResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReadRowsResponse() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReadRowsResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.storage.v1.StorageProto
        .internal_static_google_cloud_bigquery_storage_v1_ReadRowsResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.storage.v1.StorageProto
        .internal_static_google_cloud_bigquery_storage_v1_ReadRowsResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.storage.v1.ReadRowsResponse.class,
            com.google.cloud.bigquery.storage.v1.ReadRowsResponse.Builder.class);
  }

  private int bitField0_;
  private int rowsCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object rows_;

  public enum RowsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    AVRO_ROWS(3),
    ARROW_RECORD_BATCH(4),
    ROWS_NOT_SET(0);
    private final int value;

    private RowsCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RowsCase valueOf(int value) {
      return forNumber(value);
    }

    public static RowsCase forNumber(int value) {
      switch (value) {
        case 3:
          return AVRO_ROWS;
        case 4:
          return ARROW_RECORD_BATCH;
        case 0:
          return ROWS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public RowsCase getRowsCase() {
    return RowsCase.forNumber(rowsCase_);
  }

  private int schemaCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object schema_;

  public enum SchemaCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    AVRO_SCHEMA(7),
    ARROW_SCHEMA(8),
    SCHEMA_NOT_SET(0);
    private final int value;

    private SchemaCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SchemaCase valueOf(int value) {
      return forNumber(value);
    }

    public static SchemaCase forNumber(int value) {
      switch (value) {
        case 7:
          return AVRO_SCHEMA;
        case 8:
          return ARROW_SCHEMA;
        case 0:
          return SCHEMA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SchemaCase getSchemaCase() {
    return SchemaCase.forNumber(schemaCase_);
  }

  public static final int AVRO_ROWS_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Serialized row data in AVRO format.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1.AvroRows avro_rows = 3;</code>
   *
   * @return Whether the avroRows field is set.
   */
  @java.lang.Override
  public boolean hasAvroRows() {
    return rowsCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Serialized row data in AVRO format.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1.AvroRows avro_rows = 3;</code>
   *
   * @return The avroRows.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.AvroRows getAvroRows() {
    if (rowsCase_ == 3) {
      return (com.google.cloud.bigquery.storage.v1.AvroRows) rows_;
    }
    return com.google.cloud.bigquery.storage.v1.AvroRows.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Serialized row data in AVRO format.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1.AvroRows avro_rows = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.AvroRowsOrBuilder getAvroRowsOrBuilder() {
    if (rowsCase_ == 3) {
      return (com.google.cloud.bigquery.storage.v1.AvroRows) rows_;
    }
    return com.google.cloud.bigquery.storage.v1.AvroRows.getDefaultInstance();
  }

  public static final int ARROW_RECORD_BATCH_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Serialized row data in Arrow RecordBatch format.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1.ArrowRecordBatch arrow_record_batch = 4;</code>
   *
   * @return Whether the arrowRecordBatch field is set.
   */
  @java.lang.Override
  public boolean hasArrowRecordBatch() {
    return rowsCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Serialized row data in Arrow RecordBatch format.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1.ArrowRecordBatch arrow_record_batch = 4;</code>
   *
   * @return The arrowRecordBatch.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.ArrowRecordBatch getArrowRecordBatch() {
    if (rowsCase_ == 4) {
      return (com.google.cloud.bigquery.storage.v1.ArrowRecordBatch) rows_;
    }
    return com.google.cloud.bigquery.storage.v1.ArrowRecordBatch.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Serialized row data in Arrow RecordBatch format.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1.ArrowRecordBatch arrow_record_batch = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.ArrowRecordBatchOrBuilder
      getArrowRecordBatchOrBuilder() {
    if (rowsCase_ == 4) {
      return (com.google.cloud.bigquery.storage.v1.ArrowRecordBatch) rows_;
    }
    return com.google.cloud.bigquery.storage.v1.ArrowRecordBatch.getDefaultInstance();
  }

  public static final int ROW_COUNT_FIELD_NUMBER = 6;
  private long rowCount_ = 0L;
  /**
   *
   *
   * <pre>
   * Number of serialized rows in the rows block.
   * </pre>
   *
   * <code>int64 row_count = 6;</code>
   *
   * @return The rowCount.
   */
  @java.lang.Override
  public long getRowCount() {
    return rowCount_;
  }

  public static final int STATS_FIELD_NUMBER = 2;
  private com.google.cloud.bigquery.storage.v1.StreamStats stats_;
  /**
   *
   *
   * <pre>
   * Statistics for the stream.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1.StreamStats stats = 2;</code>
   *
   * @return Whether the stats field is set.
   */
  @java.lang.Override
  public boolean hasStats() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Statistics for the stream.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1.StreamStats stats = 2;</code>
   *
   * @return The stats.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.StreamStats getStats() {
    return stats_ == null
        ? com.google.cloud.bigquery.storage.v1.StreamStats.getDefaultInstance()
        : stats_;
  }
  /**
   *
   *
   * <pre>
   * Statistics for the stream.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1.StreamStats stats = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.StreamStatsOrBuilder getStatsOrBuilder() {
    return stats_ == null
        ? com.google.cloud.bigquery.storage.v1.StreamStats.getDefaultInstance()
        : stats_;
  }

  public static final int THROTTLE_STATE_FIELD_NUMBER = 5;
  private com.google.cloud.bigquery.storage.v1.ThrottleState throttleState_;
  /**
   *
   *
   * <pre>
   * Throttling state. If unset, the latest response still describes
   * the current throttling status.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1.ThrottleState throttle_state = 5;</code>
   *
   * @return Whether the throttleState field is set.
   */
  @java.lang.Override
  public boolean hasThrottleState() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Throttling state. If unset, the latest response still describes
   * the current throttling status.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1.ThrottleState throttle_state = 5;</code>
   *
   * @return The throttleState.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.ThrottleState getThrottleState() {
    return throttleState_ == null
        ? com.google.cloud.bigquery.storage.v1.ThrottleState.getDefaultInstance()
        : throttleState_;
  }
  /**
   *
   *
   * <pre>
   * Throttling state. If unset, the latest response still describes
   * the current throttling status.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1.ThrottleState throttle_state = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.ThrottleStateOrBuilder getThrottleStateOrBuilder() {
    return throttleState_ == null
        ? com.google.cloud.bigquery.storage.v1.ThrottleState.getDefaultInstance()
        : throttleState_;
  }

  public static final int AVRO_SCHEMA_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Output only. Avro schema.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the avroSchema field is set.
   */
  @java.lang.Override
  public boolean hasAvroSchema() {
    return schemaCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Output only. Avro schema.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The avroSchema.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.AvroSchema getAvroSchema() {
    if (schemaCase_ == 7) {
      return (com.google.cloud.bigquery.storage.v1.AvroSchema) schema_;
    }
    return com.google.cloud.bigquery.storage.v1.AvroSchema.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Avro schema.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.AvroSchemaOrBuilder getAvroSchemaOrBuilder() {
    if (schemaCase_ == 7) {
      return (com.google.cloud.bigquery.storage.v1.AvroSchema) schema_;
    }
    return com.google.cloud.bigquery.storage.v1.AvroSchema.getDefaultInstance();
  }

  public static final int ARROW_SCHEMA_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * Output only. Arrow schema.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the arrowSchema field is set.
   */
  @java.lang.Override
  public boolean hasArrowSchema() {
    return schemaCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * Output only. Arrow schema.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The arrowSchema.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.ArrowSchema getArrowSchema() {
    if (schemaCase_ == 8) {
      return (com.google.cloud.bigquery.storage.v1.ArrowSchema) schema_;
    }
    return com.google.cloud.bigquery.storage.v1.ArrowSchema.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Arrow schema.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.ArrowSchemaOrBuilder getArrowSchemaOrBuilder() {
    if (schemaCase_ == 8) {
      return (com.google.cloud.bigquery.storage.v1.ArrowSchema) schema_;
    }
    return com.google.cloud.bigquery.storage.v1.ArrowSchema.getDefaultInstance();
  }

  public static final int UNCOMPRESSED_BYTE_SIZE_FIELD_NUMBER = 9;
  private long uncompressedByteSize_ = 0L;
  /**
   *
   *
   * <pre>
   * Optional. If the row data in this ReadRowsResponse is compressed, then
   * uncompressed byte size is the original size of the uncompressed row data.
   * If it is set to a value greater than 0, then decompress into a buffer of
   * size uncompressed_byte_size using the compression codec that was requested
   * during session creation time and which is specified in
   * TableReadOptions.response_compression_codec in ReadSession.
   * This value is not set if no response_compression_codec was not requested
   * and it is -1 if the requested compression would not have reduced the size
   * of this ReadRowsResponse's row data. This attempts to match Apache Arrow's
   * behavior described here https://github.com/apache/arrow/issues/15102 where
   * the uncompressed length may be set to -1 to indicate that the data that
   * follows is not compressed, which can be useful for cases where compression
   * does not yield appreciable savings. When uncompressed_byte_size is not
   * greater than 0, the client should skip decompression.
   * </pre>
   *
   * <code>optional int64 uncompressed_byte_size = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the uncompressedByteSize field is set.
   */
  @java.lang.Override
  public boolean hasUncompressedByteSize() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. If the row data in this ReadRowsResponse is compressed, then
   * uncompressed byte size is the original size of the uncompressed row data.
   * If it is set to a value greater than 0, then decompress into a buffer of
   * size uncompressed_byte_size using the compression codec that was requested
   * during session creation time and which is specified in
   * TableReadOptions.response_compression_codec in ReadSession.
   * This value is not set if no response_compression_codec was not requested
   * and it is -1 if the requested compression would not have reduced the size
   * of this ReadRowsResponse's row data. This attempts to match Apache Arrow's
   * behavior described here https://github.com/apache/arrow/issues/15102 where
   * the uncompressed length may be set to -1 to indicate that the data that
   * follows is not compressed, which can be useful for cases where compression
   * does not yield appreciable savings. When uncompressed_byte_size is not
   * greater than 0, the client should skip decompression.
   * </pre>
   *
   * <code>optional int64 uncompressed_byte_size = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The uncompressedByteSize.
   */
  @java.lang.Override
  public long getUncompressedByteSize() {
    return uncompressedByteSize_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getStats());
    }
    if (rowsCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.bigquery.storage.v1.AvroRows) rows_);
    }
    if (rowsCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.bigquery.storage.v1.ArrowRecordBatch) rows_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getThrottleState());
    }
    if (rowCount_ != 0L) {
      output.writeInt64(6, rowCount_);
    }
    if (schemaCase_ == 7) {
      output.writeMessage(7, (com.google.cloud.bigquery.storage.v1.AvroSchema) schema_);
    }
    if (schemaCase_ == 8) {
      output.writeMessage(8, (com.google.cloud.bigquery.storage.v1.ArrowSchema) schema_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeInt64(9, uncompressedByteSize_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getStats());
    }
    if (rowsCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.bigquery.storage.v1.AvroRows) rows_);
    }
    if (rowsCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.bigquery.storage.v1.ArrowRecordBatch) rows_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getThrottleState());
    }
    if (rowCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(6, rowCount_);
    }
    if (schemaCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.bigquery.storage.v1.AvroSchema) schema_);
    }
    if (schemaCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.cloud.bigquery.storage.v1.ArrowSchema) schema_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(9, uncompressedByteSize_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.storage.v1.ReadRowsResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.storage.v1.ReadRowsResponse other =
        (com.google.cloud.bigquery.storage.v1.ReadRowsResponse) obj;

    if (getRowCount() != other.getRowCount()) return false;
    if (hasStats() != other.hasStats()) return false;
    if (hasStats()) {
      if (!getStats().equals(other.getStats())) return false;
    }
    if (hasThrottleState() != other.hasThrottleState()) return false;
    if (hasThrottleState()) {
      if (!getThrottleState().equals(other.getThrottleState())) return false;
    }
    if (hasUncompressedByteSize() != other.hasUncompressedByteSize()) return false;
    if (hasUncompressedByteSize()) {
      if (getUncompressedByteSize() != other.getUncompressedByteSize()) return false;
    }
    if (!getRowsCase().equals(other.getRowsCase())) return false;
    switch (rowsCase_) {
      case 3:
        if (!getAvroRows().equals(other.getAvroRows())) return false;
        break;
      case 4:
        if (!getArrowRecordBatch().equals(other.getArrowRecordBatch())) return false;
        break;
      case 0:
      default:
    }
    if (!getSchemaCase().equals(other.getSchemaCase())) return false;
    switch (schemaCase_) {
      case 7:
        if (!getAvroSchema().equals(other.getAvroSchema())) return false;
        break;
      case 8:
        if (!getArrowSchema().equals(other.getArrowSchema())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ROW_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getRowCount());
    if (hasStats()) {
      hash = (37 * hash) + STATS_FIELD_NUMBER;
      hash = (53 * hash) + getStats().hashCode();
    }
    if (hasThrottleState()) {
      hash = (37 * hash) + THROTTLE_STATE_FIELD_NUMBER;
      hash = (53 * hash) + getThrottleState().hashCode();
    }
    if (hasUncompressedByteSize()) {
      hash = (37 * hash) + UNCOMPRESSED_BYTE_SIZE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getUncompressedByteSize());
    }
    switch (rowsCase_) {
      case 3:
        hash = (37 * hash) + AVRO_ROWS_FIELD_NUMBER;
        hash = (53 * hash) + getAvroRows().hashCode();
        break;
      case 4:
        hash = (37 * hash) + ARROW_RECORD_BATCH_FIELD_NUMBER;
        hash = (53 * hash) + getArrowRecordBatch().hashCode();
        break;
      case 0:
      default:
    }
    switch (schemaCase_) {
      case 7:
        hash = (37 * hash) + AVRO_SCHEMA_FIELD_NUMBER;
        hash = (53 * hash) + getAvroSchema().hashCode();
        break;
      case 8:
        hash = (37 * hash) + ARROW_SCHEMA_FIELD_NUMBER;
        hash = (53 * hash) + getArrowSchema().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.storage.v1.ReadRowsResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1.ReadRowsResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1.ReadRowsResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1.ReadRowsResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1.ReadRowsResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1.ReadRowsResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1.ReadRowsResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1.ReadRowsResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1.ReadRowsResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1.ReadRowsResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1.ReadRowsResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1.ReadRowsResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.storage.v1.ReadRowsResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response from calling `ReadRows` may include row data, progress and
   * throttling information.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1.ReadRowsResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1.ReadRowsResponse)
      com.google.cloud.bigquery.storage.v1.ReadRowsResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1.StorageProto
          .internal_static_google_cloud_bigquery_storage_v1_ReadRowsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1.StorageProto
          .internal_static_google_cloud_bigquery_storage_v1_ReadRowsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1.ReadRowsResponse.class,
              com.google.cloud.bigquery.storage.v1.ReadRowsResponse.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.storage.v1.ReadRowsResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getStatsFieldBuilder();
        getThrottleStateFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (avroRowsBuilder_ != null) {
        avroRowsBuilder_.clear();
      }
      if (arrowRecordBatchBuilder_ != null) {
        arrowRecordBatchBuilder_.clear();
      }
      rowCount_ = 0L;
      stats_ = null;
      if (statsBuilder_ != null) {
        statsBuilder_.dispose();
        statsBuilder_ = null;
      }
      throttleState_ = null;
      if (throttleStateBuilder_ != null) {
        throttleStateBuilder_.dispose();
        throttleStateBuilder_ = null;
      }
      if (avroSchemaBuilder_ != null) {
        avroSchemaBuilder_.clear();
      }
      if (arrowSchemaBuilder_ != null) {
        arrowSchemaBuilder_.clear();
      }
      uncompressedByteSize_ = 0L;
      rowsCase_ = 0;
      rows_ = null;
      schemaCase_ = 0;
      schema_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.storage.v1.StorageProto
          .internal_static_google_cloud_bigquery_storage_v1_ReadRowsResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.ReadRowsResponse getDefaultInstanceForType() {
      return com.google.cloud.bigquery.storage.v1.ReadRowsResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.ReadRowsResponse build() {
      com.google.cloud.bigquery.storage.v1.ReadRowsResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.ReadRowsResponse buildPartial() {
      com.google.cloud.bigquery.storage.v1.ReadRowsResponse result =
          new com.google.cloud.bigquery.storage.v1.ReadRowsResponse(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.bigquery.storage.v1.ReadRowsResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.rowCount_ = rowCount_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.stats_ = statsBuilder_ == null ? stats_ : statsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.throttleState_ =
            throttleStateBuilder_ == null ? throttleState_ : throttleStateBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.uncompressedByteSize_ = uncompressedByteSize_;
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.bigquery.storage.v1.ReadRowsResponse result) {
      result.rowsCase_ = rowsCase_;
      result.rows_ = this.rows_;
      if (rowsCase_ == 3 && avroRowsBuilder_ != null) {
        result.rows_ = avroRowsBuilder_.build();
      }
      if (rowsCase_ == 4 && arrowRecordBatchBuilder_ != null) {
        result.rows_ = arrowRecordBatchBuilder_.build();
      }
      result.schemaCase_ = schemaCase_;
      result.schema_ = this.schema_;
      if (schemaCase_ == 7 && avroSchemaBuilder_ != null) {
        result.schema_ = avroSchemaBuilder_.build();
      }
      if (schemaCase_ == 8 && arrowSchemaBuilder_ != null) {
        result.schema_ = arrowSchemaBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.storage.v1.ReadRowsResponse) {
        return mergeFrom((com.google.cloud.bigquery.storage.v1.ReadRowsResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.storage.v1.ReadRowsResponse other) {
      if (other == com.google.cloud.bigquery.storage.v1.ReadRowsResponse.getDefaultInstance())
        return this;
      if (other.getRowCount() != 0L) {
        setRowCount(other.getRowCount());
      }
      if (other.hasStats()) {
        mergeStats(other.getStats());
      }
      if (other.hasThrottleState()) {
        mergeThrottleState(other.getThrottleState());
      }
      if (other.hasUncompressedByteSize()) {
        setUncompressedByteSize(other.getUncompressedByteSize());
      }
      switch (other.getRowsCase()) {
        case AVRO_ROWS:
          {
            mergeAvroRows(other.getAvroRows());
            break;
          }
        case ARROW_RECORD_BATCH:
          {
            mergeArrowRecordBatch(other.getArrowRecordBatch());
            break;
          }
        case ROWS_NOT_SET:
          {
            break;
          }
      }
      switch (other.getSchemaCase()) {
        case AVRO_SCHEMA:
          {
            mergeAvroSchema(other.getAvroSchema());
            break;
          }
        case ARROW_SCHEMA:
          {
            mergeArrowSchema(other.getArrowSchema());
            break;
          }
        case SCHEMA_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                input.readMessage(getStatsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getAvroRowsFieldBuilder().getBuilder(), extensionRegistry);
                rowsCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getArrowRecordBatchFieldBuilder().getBuilder(), extensionRegistry);
                rowsCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getThrottleStateFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                rowCount_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 48
            case 58:
              {
                input.readMessage(getAvroSchemaFieldBuilder().getBuilder(), extensionRegistry);
                schemaCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getArrowSchemaFieldBuilder().getBuilder(), extensionRegistry);
                schemaCase_ = 8;
                break;
              } // case 66
            case 72:
              {
                uncompressedByteSize_ = input.readInt64();
                bitField0_ |= 0x00000080;
                break;
              } // case 72
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int rowsCase_ = 0;
    private java.lang.Object rows_;

    public RowsCase getRowsCase() {
      return RowsCase.forNumber(rowsCase_);
    }

    public Builder clearRows() {
      rowsCase_ = 0;
      rows_ = null;
      onChanged();
      return this;
    }

    private int schemaCase_ = 0;
    private java.lang.Object schema_;

    public SchemaCase getSchemaCase() {
      return SchemaCase.forNumber(schemaCase_);
    }

    public Builder clearSchema() {
      schemaCase_ = 0;
      schema_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.AvroRows,
            com.google.cloud.bigquery.storage.v1.AvroRows.Builder,
            com.google.cloud.bigquery.storage.v1.AvroRowsOrBuilder>
        avroRowsBuilder_;
    /**
     *
     *
     * <pre>
     * Serialized row data in AVRO format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.AvroRows avro_rows = 3;</code>
     *
     * @return Whether the avroRows field is set.
     */
    @java.lang.Override
    public boolean hasAvroRows() {
      return rowsCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Serialized row data in AVRO format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.AvroRows avro_rows = 3;</code>
     *
     * @return The avroRows.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.AvroRows getAvroRows() {
      if (avroRowsBuilder_ == null) {
        if (rowsCase_ == 3) {
          return (com.google.cloud.bigquery.storage.v1.AvroRows) rows_;
        }
        return com.google.cloud.bigquery.storage.v1.AvroRows.getDefaultInstance();
      } else {
        if (rowsCase_ == 3) {
          return avroRowsBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.storage.v1.AvroRows.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Serialized row data in AVRO format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.AvroRows avro_rows = 3;</code>
     */
    public Builder setAvroRows(com.google.cloud.bigquery.storage.v1.AvroRows value) {
      if (avroRowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rows_ = value;
        onChanged();
      } else {
        avroRowsBuilder_.setMessage(value);
      }
      rowsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Serialized row data in AVRO format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.AvroRows avro_rows = 3;</code>
     */
    public Builder setAvroRows(
        com.google.cloud.bigquery.storage.v1.AvroRows.Builder builderForValue) {
      if (avroRowsBuilder_ == null) {
        rows_ = builderForValue.build();
        onChanged();
      } else {
        avroRowsBuilder_.setMessage(builderForValue.build());
      }
      rowsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Serialized row data in AVRO format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.AvroRows avro_rows = 3;</code>
     */
    public Builder mergeAvroRows(com.google.cloud.bigquery.storage.v1.AvroRows value) {
      if (avroRowsBuilder_ == null) {
        if (rowsCase_ == 3
            && rows_ != com.google.cloud.bigquery.storage.v1.AvroRows.getDefaultInstance()) {
          rows_ =
              com.google.cloud.bigquery.storage.v1.AvroRows.newBuilder(
                      (com.google.cloud.bigquery.storage.v1.AvroRows) rows_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          rows_ = value;
        }
        onChanged();
      } else {
        if (rowsCase_ == 3) {
          avroRowsBuilder_.mergeFrom(value);
        } else {
          avroRowsBuilder_.setMessage(value);
        }
      }
      rowsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Serialized row data in AVRO format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.AvroRows avro_rows = 3;</code>
     */
    public Builder clearAvroRows() {
      if (avroRowsBuilder_ == null) {
        if (rowsCase_ == 3) {
          rowsCase_ = 0;
          rows_ = null;
          onChanged();
        }
      } else {
        if (rowsCase_ == 3) {
          rowsCase_ = 0;
          rows_ = null;
        }
        avroRowsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Serialized row data in AVRO format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.AvroRows avro_rows = 3;</code>
     */
    public com.google.cloud.bigquery.storage.v1.AvroRows.Builder getAvroRowsBuilder() {
      return getAvroRowsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Serialized row data in AVRO format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.AvroRows avro_rows = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.AvroRowsOrBuilder getAvroRowsOrBuilder() {
      if ((rowsCase_ == 3) && (avroRowsBuilder_ != null)) {
        return avroRowsBuilder_.getMessageOrBuilder();
      } else {
        if (rowsCase_ == 3) {
          return (com.google.cloud.bigquery.storage.v1.AvroRows) rows_;
        }
        return com.google.cloud.bigquery.storage.v1.AvroRows.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Serialized row data in AVRO format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.AvroRows avro_rows = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.AvroRows,
            com.google.cloud.bigquery.storage.v1.AvroRows.Builder,
            com.google.cloud.bigquery.storage.v1.AvroRowsOrBuilder>
        getAvroRowsFieldBuilder() {
      if (avroRowsBuilder_ == null) {
        if (!(rowsCase_ == 3)) {
          rows_ = com.google.cloud.bigquery.storage.v1.AvroRows.getDefaultInstance();
        }
        avroRowsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1.AvroRows,
                com.google.cloud.bigquery.storage.v1.AvroRows.Builder,
                com.google.cloud.bigquery.storage.v1.AvroRowsOrBuilder>(
                (com.google.cloud.bigquery.storage.v1.AvroRows) rows_,
                getParentForChildren(),
                isClean());
        rows_ = null;
      }
      rowsCase_ = 3;
      onChanged();
      return avroRowsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.ArrowRecordBatch,
            com.google.cloud.bigquery.storage.v1.ArrowRecordBatch.Builder,
            com.google.cloud.bigquery.storage.v1.ArrowRecordBatchOrBuilder>
        arrowRecordBatchBuilder_;
    /**
     *
     *
     * <pre>
     * Serialized row data in Arrow RecordBatch format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ArrowRecordBatch arrow_record_batch = 4;</code>
     *
     * @return Whether the arrowRecordBatch field is set.
     */
    @java.lang.Override
    public boolean hasArrowRecordBatch() {
      return rowsCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Serialized row data in Arrow RecordBatch format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ArrowRecordBatch arrow_record_batch = 4;</code>
     *
     * @return The arrowRecordBatch.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.ArrowRecordBatch getArrowRecordBatch() {
      if (arrowRecordBatchBuilder_ == null) {
        if (rowsCase_ == 4) {
          return (com.google.cloud.bigquery.storage.v1.ArrowRecordBatch) rows_;
        }
        return com.google.cloud.bigquery.storage.v1.ArrowRecordBatch.getDefaultInstance();
      } else {
        if (rowsCase_ == 4) {
          return arrowRecordBatchBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.storage.v1.ArrowRecordBatch.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Serialized row data in Arrow RecordBatch format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ArrowRecordBatch arrow_record_batch = 4;</code>
     */
    public Builder setArrowRecordBatch(
        com.google.cloud.bigquery.storage.v1.ArrowRecordBatch value) {
      if (arrowRecordBatchBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rows_ = value;
        onChanged();
      } else {
        arrowRecordBatchBuilder_.setMessage(value);
      }
      rowsCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Serialized row data in Arrow RecordBatch format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ArrowRecordBatch arrow_record_batch = 4;</code>
     */
    public Builder setArrowRecordBatch(
        com.google.cloud.bigquery.storage.v1.ArrowRecordBatch.Builder builderForValue) {
      if (arrowRecordBatchBuilder_ == null) {
        rows_ = builderForValue.build();
        onChanged();
      } else {
        arrowRecordBatchBuilder_.setMessage(builderForValue.build());
      }
      rowsCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Serialized row data in Arrow RecordBatch format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ArrowRecordBatch arrow_record_batch = 4;</code>
     */
    public Builder mergeArrowRecordBatch(
        com.google.cloud.bigquery.storage.v1.ArrowRecordBatch value) {
      if (arrowRecordBatchBuilder_ == null) {
        if (rowsCase_ == 4
            && rows_
                != com.google.cloud.bigquery.storage.v1.ArrowRecordBatch.getDefaultInstance()) {
          rows_ =
              com.google.cloud.bigquery.storage.v1.ArrowRecordBatch.newBuilder(
                      (com.google.cloud.bigquery.storage.v1.ArrowRecordBatch) rows_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          rows_ = value;
        }
        onChanged();
      } else {
        if (rowsCase_ == 4) {
          arrowRecordBatchBuilder_.mergeFrom(value);
        } else {
          arrowRecordBatchBuilder_.setMessage(value);
        }
      }
      rowsCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Serialized row data in Arrow RecordBatch format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ArrowRecordBatch arrow_record_batch = 4;</code>
     */
    public Builder clearArrowRecordBatch() {
      if (arrowRecordBatchBuilder_ == null) {
        if (rowsCase_ == 4) {
          rowsCase_ = 0;
          rows_ = null;
          onChanged();
        }
      } else {
        if (rowsCase_ == 4) {
          rowsCase_ = 0;
          rows_ = null;
        }
        arrowRecordBatchBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Serialized row data in Arrow RecordBatch format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ArrowRecordBatch arrow_record_batch = 4;</code>
     */
    public com.google.cloud.bigquery.storage.v1.ArrowRecordBatch.Builder
        getArrowRecordBatchBuilder() {
      return getArrowRecordBatchFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Serialized row data in Arrow RecordBatch format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ArrowRecordBatch arrow_record_batch = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.ArrowRecordBatchOrBuilder
        getArrowRecordBatchOrBuilder() {
      if ((rowsCase_ == 4) && (arrowRecordBatchBuilder_ != null)) {
        return arrowRecordBatchBuilder_.getMessageOrBuilder();
      } else {
        if (rowsCase_ == 4) {
          return (com.google.cloud.bigquery.storage.v1.ArrowRecordBatch) rows_;
        }
        return com.google.cloud.bigquery.storage.v1.ArrowRecordBatch.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Serialized row data in Arrow RecordBatch format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ArrowRecordBatch arrow_record_batch = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.ArrowRecordBatch,
            com.google.cloud.bigquery.storage.v1.ArrowRecordBatch.Builder,
            com.google.cloud.bigquery.storage.v1.ArrowRecordBatchOrBuilder>
        getArrowRecordBatchFieldBuilder() {
      if (arrowRecordBatchBuilder_ == null) {
        if (!(rowsCase_ == 4)) {
          rows_ = com.google.cloud.bigquery.storage.v1.ArrowRecordBatch.getDefaultInstance();
        }
        arrowRecordBatchBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1.ArrowRecordBatch,
                com.google.cloud.bigquery.storage.v1.ArrowRecordBatch.Builder,
                com.google.cloud.bigquery.storage.v1.ArrowRecordBatchOrBuilder>(
                (com.google.cloud.bigquery.storage.v1.ArrowRecordBatch) rows_,
                getParentForChildren(),
                isClean());
        rows_ = null;
      }
      rowsCase_ = 4;
      onChanged();
      return arrowRecordBatchBuilder_;
    }

    private long rowCount_;
    /**
     *
     *
     * <pre>
     * Number of serialized rows in the rows block.
     * </pre>
     *
     * <code>int64 row_count = 6;</code>
     *
     * @return The rowCount.
     */
    @java.lang.Override
    public long getRowCount() {
      return rowCount_;
    }
    /**
     *
     *
     * <pre>
     * Number of serialized rows in the rows block.
     * </pre>
     *
     * <code>int64 row_count = 6;</code>
     *
     * @param value The rowCount to set.
     * @return This builder for chaining.
     */
    public Builder setRowCount(long value) {

      rowCount_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of serialized rows in the rows block.
     * </pre>
     *
     * <code>int64 row_count = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRowCount() {
      bitField0_ = (bitField0_ & ~0x00000004);
      rowCount_ = 0L;
      onChanged();
      return this;
    }

    private com.google.cloud.bigquery.storage.v1.StreamStats stats_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.StreamStats,
            com.google.cloud.bigquery.storage.v1.StreamStats.Builder,
            com.google.cloud.bigquery.storage.v1.StreamStatsOrBuilder>
        statsBuilder_;
    /**
     *
     *
     * <pre>
     * Statistics for the stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.StreamStats stats = 2;</code>
     *
     * @return Whether the stats field is set.
     */
    public boolean hasStats() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Statistics for the stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.StreamStats stats = 2;</code>
     *
     * @return The stats.
     */
    public com.google.cloud.bigquery.storage.v1.StreamStats getStats() {
      if (statsBuilder_ == null) {
        return stats_ == null
            ? com.google.cloud.bigquery.storage.v1.StreamStats.getDefaultInstance()
            : stats_;
      } else {
        return statsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Statistics for the stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.StreamStats stats = 2;</code>
     */
    public Builder setStats(com.google.cloud.bigquery.storage.v1.StreamStats value) {
      if (statsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stats_ = value;
      } else {
        statsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Statistics for the stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.StreamStats stats = 2;</code>
     */
    public Builder setStats(
        com.google.cloud.bigquery.storage.v1.StreamStats.Builder builderForValue) {
      if (statsBuilder_ == null) {
        stats_ = builderForValue.build();
      } else {
        statsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Statistics for the stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.StreamStats stats = 2;</code>
     */
    public Builder mergeStats(com.google.cloud.bigquery.storage.v1.StreamStats value) {
      if (statsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && stats_ != null
            && stats_ != com.google.cloud.bigquery.storage.v1.StreamStats.getDefaultInstance()) {
          getStatsBuilder().mergeFrom(value);
        } else {
          stats_ = value;
        }
      } else {
        statsBuilder_.mergeFrom(value);
      }
      if (stats_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Statistics for the stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.StreamStats stats = 2;</code>
     */
    public Builder clearStats() {
      bitField0_ = (bitField0_ & ~0x00000008);
      stats_ = null;
      if (statsBuilder_ != null) {
        statsBuilder_.dispose();
        statsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Statistics for the stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.StreamStats stats = 2;</code>
     */
    public com.google.cloud.bigquery.storage.v1.StreamStats.Builder getStatsBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getStatsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Statistics for the stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.StreamStats stats = 2;</code>
     */
    public com.google.cloud.bigquery.storage.v1.StreamStatsOrBuilder getStatsOrBuilder() {
      if (statsBuilder_ != null) {
        return statsBuilder_.getMessageOrBuilder();
      } else {
        return stats_ == null
            ? com.google.cloud.bigquery.storage.v1.StreamStats.getDefaultInstance()
            : stats_;
      }
    }
    /**
     *
     *
     * <pre>
     * Statistics for the stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.StreamStats stats = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.StreamStats,
            com.google.cloud.bigquery.storage.v1.StreamStats.Builder,
            com.google.cloud.bigquery.storage.v1.StreamStatsOrBuilder>
        getStatsFieldBuilder() {
      if (statsBuilder_ == null) {
        statsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1.StreamStats,
                com.google.cloud.bigquery.storage.v1.StreamStats.Builder,
                com.google.cloud.bigquery.storage.v1.StreamStatsOrBuilder>(
                getStats(), getParentForChildren(), isClean());
        stats_ = null;
      }
      return statsBuilder_;
    }

    private com.google.cloud.bigquery.storage.v1.ThrottleState throttleState_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.ThrottleState,
            com.google.cloud.bigquery.storage.v1.ThrottleState.Builder,
            com.google.cloud.bigquery.storage.v1.ThrottleStateOrBuilder>
        throttleStateBuilder_;
    /**
     *
     *
     * <pre>
     * Throttling state. If unset, the latest response still describes
     * the current throttling status.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ThrottleState throttle_state = 5;</code>
     *
     * @return Whether the throttleState field is set.
     */
    public boolean hasThrottleState() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Throttling state. If unset, the latest response still describes
     * the current throttling status.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ThrottleState throttle_state = 5;</code>
     *
     * @return The throttleState.
     */
    public com.google.cloud.bigquery.storage.v1.ThrottleState getThrottleState() {
      if (throttleStateBuilder_ == null) {
        return throttleState_ == null
            ? com.google.cloud.bigquery.storage.v1.ThrottleState.getDefaultInstance()
            : throttleState_;
      } else {
        return throttleStateBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Throttling state. If unset, the latest response still describes
     * the current throttling status.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ThrottleState throttle_state = 5;</code>
     */
    public Builder setThrottleState(com.google.cloud.bigquery.storage.v1.ThrottleState value) {
      if (throttleStateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        throttleState_ = value;
      } else {
        throttleStateBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Throttling state. If unset, the latest response still describes
     * the current throttling status.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ThrottleState throttle_state = 5;</code>
     */
    public Builder setThrottleState(
        com.google.cloud.bigquery.storage.v1.ThrottleState.Builder builderForValue) {
      if (throttleStateBuilder_ == null) {
        throttleState_ = builderForValue.build();
      } else {
        throttleStateBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Throttling state. If unset, the latest response still describes
     * the current throttling status.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ThrottleState throttle_state = 5;</code>
     */
    public Builder mergeThrottleState(com.google.cloud.bigquery.storage.v1.ThrottleState value) {
      if (throttleStateBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && throttleState_ != null
            && throttleState_
                != com.google.cloud.bigquery.storage.v1.ThrottleState.getDefaultInstance()) {
          getThrottleStateBuilder().mergeFrom(value);
        } else {
          throttleState_ = value;
        }
      } else {
        throttleStateBuilder_.mergeFrom(value);
      }
      if (throttleState_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Throttling state. If unset, the latest response still describes
     * the current throttling status.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ThrottleState throttle_state = 5;</code>
     */
    public Builder clearThrottleState() {
      bitField0_ = (bitField0_ & ~0x00000010);
      throttleState_ = null;
      if (throttleStateBuilder_ != null) {
        throttleStateBuilder_.dispose();
        throttleStateBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Throttling state. If unset, the latest response still describes
     * the current throttling status.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ThrottleState throttle_state = 5;</code>
     */
    public com.google.cloud.bigquery.storage.v1.ThrottleState.Builder getThrottleStateBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getThrottleStateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Throttling state. If unset, the latest response still describes
     * the current throttling status.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ThrottleState throttle_state = 5;</code>
     */
    public com.google.cloud.bigquery.storage.v1.ThrottleStateOrBuilder getThrottleStateOrBuilder() {
      if (throttleStateBuilder_ != null) {
        return throttleStateBuilder_.getMessageOrBuilder();
      } else {
        return throttleState_ == null
            ? com.google.cloud.bigquery.storage.v1.ThrottleState.getDefaultInstance()
            : throttleState_;
      }
    }
    /**
     *
     *
     * <pre>
     * Throttling state. If unset, the latest response still describes
     * the current throttling status.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ThrottleState throttle_state = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.ThrottleState,
            com.google.cloud.bigquery.storage.v1.ThrottleState.Builder,
            com.google.cloud.bigquery.storage.v1.ThrottleStateOrBuilder>
        getThrottleStateFieldBuilder() {
      if (throttleStateBuilder_ == null) {
        throttleStateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1.ThrottleState,
                com.google.cloud.bigquery.storage.v1.ThrottleState.Builder,
                com.google.cloud.bigquery.storage.v1.ThrottleStateOrBuilder>(
                getThrottleState(), getParentForChildren(), isClean());
        throttleState_ = null;
      }
      return throttleStateBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.AvroSchema,
            com.google.cloud.bigquery.storage.v1.AvroSchema.Builder,
            com.google.cloud.bigquery.storage.v1.AvroSchemaOrBuilder>
        avroSchemaBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Avro schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the avroSchema field is set.
     */
    @java.lang.Override
    public boolean hasAvroSchema() {
      return schemaCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Output only. Avro schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The avroSchema.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.AvroSchema getAvroSchema() {
      if (avroSchemaBuilder_ == null) {
        if (schemaCase_ == 7) {
          return (com.google.cloud.bigquery.storage.v1.AvroSchema) schema_;
        }
        return com.google.cloud.bigquery.storage.v1.AvroSchema.getDefaultInstance();
      } else {
        if (schemaCase_ == 7) {
          return avroSchemaBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.storage.v1.AvroSchema.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Avro schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAvroSchema(com.google.cloud.bigquery.storage.v1.AvroSchema value) {
      if (avroSchemaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        schema_ = value;
        onChanged();
      } else {
        avroSchemaBuilder_.setMessage(value);
      }
      schemaCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Avro schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAvroSchema(
        com.google.cloud.bigquery.storage.v1.AvroSchema.Builder builderForValue) {
      if (avroSchemaBuilder_ == null) {
        schema_ = builderForValue.build();
        onChanged();
      } else {
        avroSchemaBuilder_.setMessage(builderForValue.build());
      }
      schemaCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Avro schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeAvroSchema(com.google.cloud.bigquery.storage.v1.AvroSchema value) {
      if (avroSchemaBuilder_ == null) {
        if (schemaCase_ == 7
            && schema_ != com.google.cloud.bigquery.storage.v1.AvroSchema.getDefaultInstance()) {
          schema_ =
              com.google.cloud.bigquery.storage.v1.AvroSchema.newBuilder(
                      (com.google.cloud.bigquery.storage.v1.AvroSchema) schema_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          schema_ = value;
        }
        onChanged();
      } else {
        if (schemaCase_ == 7) {
          avroSchemaBuilder_.mergeFrom(value);
        } else {
          avroSchemaBuilder_.setMessage(value);
        }
      }
      schemaCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Avro schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearAvroSchema() {
      if (avroSchemaBuilder_ == null) {
        if (schemaCase_ == 7) {
          schemaCase_ = 0;
          schema_ = null;
          onChanged();
        }
      } else {
        if (schemaCase_ == 7) {
          schemaCase_ = 0;
          schema_ = null;
        }
        avroSchemaBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Avro schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.AvroSchema.Builder getAvroSchemaBuilder() {
      return getAvroSchemaFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Avro schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.AvroSchemaOrBuilder getAvroSchemaOrBuilder() {
      if ((schemaCase_ == 7) && (avroSchemaBuilder_ != null)) {
        return avroSchemaBuilder_.getMessageOrBuilder();
      } else {
        if (schemaCase_ == 7) {
          return (com.google.cloud.bigquery.storage.v1.AvroSchema) schema_;
        }
        return com.google.cloud.bigquery.storage.v1.AvroSchema.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Avro schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.AvroSchema,
            com.google.cloud.bigquery.storage.v1.AvroSchema.Builder,
            com.google.cloud.bigquery.storage.v1.AvroSchemaOrBuilder>
        getAvroSchemaFieldBuilder() {
      if (avroSchemaBuilder_ == null) {
        if (!(schemaCase_ == 7)) {
          schema_ = com.google.cloud.bigquery.storage.v1.AvroSchema.getDefaultInstance();
        }
        avroSchemaBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1.AvroSchema,
                com.google.cloud.bigquery.storage.v1.AvroSchema.Builder,
                com.google.cloud.bigquery.storage.v1.AvroSchemaOrBuilder>(
                (com.google.cloud.bigquery.storage.v1.AvroSchema) schema_,
                getParentForChildren(),
                isClean());
        schema_ = null;
      }
      schemaCase_ = 7;
      onChanged();
      return avroSchemaBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.ArrowSchema,
            com.google.cloud.bigquery.storage.v1.ArrowSchema.Builder,
            com.google.cloud.bigquery.storage.v1.ArrowSchemaOrBuilder>
        arrowSchemaBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Arrow schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the arrowSchema field is set.
     */
    @java.lang.Override
    public boolean hasArrowSchema() {
      return schemaCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Output only. Arrow schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The arrowSchema.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.ArrowSchema getArrowSchema() {
      if (arrowSchemaBuilder_ == null) {
        if (schemaCase_ == 8) {
          return (com.google.cloud.bigquery.storage.v1.ArrowSchema) schema_;
        }
        return com.google.cloud.bigquery.storage.v1.ArrowSchema.getDefaultInstance();
      } else {
        if (schemaCase_ == 8) {
          return arrowSchemaBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.storage.v1.ArrowSchema.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Arrow schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setArrowSchema(com.google.cloud.bigquery.storage.v1.ArrowSchema value) {
      if (arrowSchemaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        schema_ = value;
        onChanged();
      } else {
        arrowSchemaBuilder_.setMessage(value);
      }
      schemaCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Arrow schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setArrowSchema(
        com.google.cloud.bigquery.storage.v1.ArrowSchema.Builder builderForValue) {
      if (arrowSchemaBuilder_ == null) {
        schema_ = builderForValue.build();
        onChanged();
      } else {
        arrowSchemaBuilder_.setMessage(builderForValue.build());
      }
      schemaCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Arrow schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeArrowSchema(com.google.cloud.bigquery.storage.v1.ArrowSchema value) {
      if (arrowSchemaBuilder_ == null) {
        if (schemaCase_ == 8
            && schema_ != com.google.cloud.bigquery.storage.v1.ArrowSchema.getDefaultInstance()) {
          schema_ =
              com.google.cloud.bigquery.storage.v1.ArrowSchema.newBuilder(
                      (com.google.cloud.bigquery.storage.v1.ArrowSchema) schema_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          schema_ = value;
        }
        onChanged();
      } else {
        if (schemaCase_ == 8) {
          arrowSchemaBuilder_.mergeFrom(value);
        } else {
          arrowSchemaBuilder_.setMessage(value);
        }
      }
      schemaCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Arrow schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearArrowSchema() {
      if (arrowSchemaBuilder_ == null) {
        if (schemaCase_ == 8) {
          schemaCase_ = 0;
          schema_ = null;
          onChanged();
        }
      } else {
        if (schemaCase_ == 8) {
          schemaCase_ = 0;
          schema_ = null;
        }
        arrowSchemaBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Arrow schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.ArrowSchema.Builder getArrowSchemaBuilder() {
      return getArrowSchemaFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Arrow schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.ArrowSchemaOrBuilder getArrowSchemaOrBuilder() {
      if ((schemaCase_ == 8) && (arrowSchemaBuilder_ != null)) {
        return arrowSchemaBuilder_.getMessageOrBuilder();
      } else {
        if (schemaCase_ == 8) {
          return (com.google.cloud.bigquery.storage.v1.ArrowSchema) schema_;
        }
        return com.google.cloud.bigquery.storage.v1.ArrowSchema.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Arrow schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.ArrowSchema,
            com.google.cloud.bigquery.storage.v1.ArrowSchema.Builder,
            com.google.cloud.bigquery.storage.v1.ArrowSchemaOrBuilder>
        getArrowSchemaFieldBuilder() {
      if (arrowSchemaBuilder_ == null) {
        if (!(schemaCase_ == 8)) {
          schema_ = com.google.cloud.bigquery.storage.v1.ArrowSchema.getDefaultInstance();
        }
        arrowSchemaBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1.ArrowSchema,
                com.google.cloud.bigquery.storage.v1.ArrowSchema.Builder,
                com.google.cloud.bigquery.storage.v1.ArrowSchemaOrBuilder>(
                (com.google.cloud.bigquery.storage.v1.ArrowSchema) schema_,
                getParentForChildren(),
                isClean());
        schema_ = null;
      }
      schemaCase_ = 8;
      onChanged();
      return arrowSchemaBuilder_;
    }

    private long uncompressedByteSize_;
    /**
     *
     *
     * <pre>
     * Optional. If the row data in this ReadRowsResponse is compressed, then
     * uncompressed byte size is the original size of the uncompressed row data.
     * If it is set to a value greater than 0, then decompress into a buffer of
     * size uncompressed_byte_size using the compression codec that was requested
     * during session creation time and which is specified in
     * TableReadOptions.response_compression_codec in ReadSession.
     * This value is not set if no response_compression_codec was not requested
     * and it is -1 if the requested compression would not have reduced the size
     * of this ReadRowsResponse's row data. This attempts to match Apache Arrow's
     * behavior described here https://github.com/apache/arrow/issues/15102 where
     * the uncompressed length may be set to -1 to indicate that the data that
     * follows is not compressed, which can be useful for cases where compression
     * does not yield appreciable savings. When uncompressed_byte_size is not
     * greater than 0, the client should skip decompression.
     * </pre>
     *
     * <code>optional int64 uncompressed_byte_size = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the uncompressedByteSize field is set.
     */
    @java.lang.Override
    public boolean hasUncompressedByteSize() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. If the row data in this ReadRowsResponse is compressed, then
     * uncompressed byte size is the original size of the uncompressed row data.
     * If it is set to a value greater than 0, then decompress into a buffer of
     * size uncompressed_byte_size using the compression codec that was requested
     * during session creation time and which is specified in
     * TableReadOptions.response_compression_codec in ReadSession.
     * This value is not set if no response_compression_codec was not requested
     * and it is -1 if the requested compression would not have reduced the size
     * of this ReadRowsResponse's row data. This attempts to match Apache Arrow's
     * behavior described here https://github.com/apache/arrow/issues/15102 where
     * the uncompressed length may be set to -1 to indicate that the data that
     * follows is not compressed, which can be useful for cases where compression
     * does not yield appreciable savings. When uncompressed_byte_size is not
     * greater than 0, the client should skip decompression.
     * </pre>
     *
     * <code>optional int64 uncompressed_byte_size = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The uncompressedByteSize.
     */
    @java.lang.Override
    public long getUncompressedByteSize() {
      return uncompressedByteSize_;
    }
    /**
     *
     *
     * <pre>
     * Optional. If the row data in this ReadRowsResponse is compressed, then
     * uncompressed byte size is the original size of the uncompressed row data.
     * If it is set to a value greater than 0, then decompress into a buffer of
     * size uncompressed_byte_size using the compression codec that was requested
     * during session creation time and which is specified in
     * TableReadOptions.response_compression_codec in ReadSession.
     * This value is not set if no response_compression_codec was not requested
     * and it is -1 if the requested compression would not have reduced the size
     * of this ReadRowsResponse's row data. This attempts to match Apache Arrow's
     * behavior described here https://github.com/apache/arrow/issues/15102 where
     * the uncompressed length may be set to -1 to indicate that the data that
     * follows is not compressed, which can be useful for cases where compression
     * does not yield appreciable savings. When uncompressed_byte_size is not
     * greater than 0, the client should skip decompression.
     * </pre>
     *
     * <code>optional int64 uncompressed_byte_size = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The uncompressedByteSize to set.
     * @return This builder for chaining.
     */
    public Builder setUncompressedByteSize(long value) {

      uncompressedByteSize_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If the row data in this ReadRowsResponse is compressed, then
     * uncompressed byte size is the original size of the uncompressed row data.
     * If it is set to a value greater than 0, then decompress into a buffer of
     * size uncompressed_byte_size using the compression codec that was requested
     * during session creation time and which is specified in
     * TableReadOptions.response_compression_codec in ReadSession.
     * This value is not set if no response_compression_codec was not requested
     * and it is -1 if the requested compression would not have reduced the size
     * of this ReadRowsResponse's row data. This attempts to match Apache Arrow's
     * behavior described here https://github.com/apache/arrow/issues/15102 where
     * the uncompressed length may be set to -1 to indicate that the data that
     * follows is not compressed, which can be useful for cases where compression
     * does not yield appreciable savings. When uncompressed_byte_size is not
     * greater than 0, the client should skip decompression.
     * </pre>
     *
     * <code>optional int64 uncompressed_byte_size = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUncompressedByteSize() {
      bitField0_ = (bitField0_ & ~0x00000080);
      uncompressedByteSize_ = 0L;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1.ReadRowsResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1.ReadRowsResponse)
  private static final com.google.cloud.bigquery.storage.v1.ReadRowsResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.storage.v1.ReadRowsResponse();
  }

  public static com.google.cloud.bigquery.storage.v1.ReadRowsResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReadRowsResponse> PARSER =
      new com.google.protobuf.AbstractParser<ReadRowsResponse>() {
        @java.lang.Override
        public ReadRowsResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ReadRowsResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReadRowsResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.ReadRowsResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
