/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ExtensionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_EXTENSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/extensions/{extension}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String extension;

    @Deprecated
    protected ExtensionName() {
        this.project = null;
        this.location = null;
        this.extension = null;
    }

    private ExtensionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.extension = (String)Preconditions.checkNotNull((Object)builder.getExtension());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getExtension() {
        return this.extension;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ExtensionName of(String project, String location, String extension) {
        return ExtensionName.newBuilder().setProject(project).setLocation(location).setExtension(extension).build();
    }

    public static String format(String project, String location, String extension) {
        return ExtensionName.newBuilder().setProject(project).setLocation(location).setExtension(extension).build().toString();
    }

    public static ExtensionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_EXTENSION.validatedMatch(formattedString, "ExtensionName.parse: formattedString not in valid format");
        return ExtensionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("extension"));
    }

    public static List<ExtensionName> parseList(List<String> formattedStrings) {
        ArrayList<ExtensionName> list = new ArrayList<ExtensionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ExtensionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ExtensionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ExtensionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_EXTENSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ExtensionName extensionName = this;
            synchronized (extensionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.extension != null) {
                        fieldMapBuilder.put((Object)"extension", (Object)this.extension);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_EXTENSION.instantiate(new String[]{"project", this.project, "location", this.location, "extension", this.extension});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ExtensionName that = (ExtensionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.extension, that.extension);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.extension);
    }

    public static class Builder {
        private String project;
        private String location;
        private String extension;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getExtension() {
            return this.extension;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setExtension(String extension) {
            this.extension = extension;
            return this;
        }

        private Builder(ExtensionName extensionName) {
            this.project = extensionName.project;
            this.location = extensionName.location;
            this.extension = extensionName.extension;
        }

        public ExtensionName build() {
            return new ExtensionName(this);
        }
    }
}

