/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/model_evaluation.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * A collection of metrics calculated by comparing Model's predictions on all of
 * the test data against annotations from the test data.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelEvaluation}
 */
public final class ModelEvaluation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelEvaluation)
    ModelEvaluationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ModelEvaluation.newBuilder() to construct.
  private ModelEvaluation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ModelEvaluation() {
    name_ = "";
    displayName_ = "";
    metricsSchemaUri_ = "";
    sliceDimensions_ = com.google.protobuf.LazyStringArrayList.emptyList();
    explanationSpecs_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ModelEvaluation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ModelEvaluationProto
        .internal_static_google_cloud_aiplatform_v1beta1_ModelEvaluation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ModelEvaluationProto
        .internal_static_google_cloud_aiplatform_v1beta1_ModelEvaluation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.ModelEvaluation.class,
            com.google.cloud.aiplatform.v1beta1.ModelEvaluation.Builder.class);
  }

  public interface ModelEvaluationExplanationSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Explanation type.
     *
     * For AutoML Image Classification models, possible values are:
     *
     *   * `image-integrated-gradients`
     *   * `image-xrai`
     * </pre>
     *
     * <code>string explanation_type = 1;</code>
     *
     * @return The explanationType.
     */
    java.lang.String getExplanationType();
    /**
     *
     *
     * <pre>
     * Explanation type.
     *
     * For AutoML Image Classification models, possible values are:
     *
     *   * `image-integrated-gradients`
     *   * `image-xrai`
     * </pre>
     *
     * <code>string explanation_type = 1;</code>
     *
     * @return The bytes for explanationType.
     */
    com.google.protobuf.ByteString getExplanationTypeBytes();

    /**
     *
     *
     * <pre>
     * Explanation spec details.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 2;</code>
     *
     * @return Whether the explanationSpec field is set.
     */
    boolean hasExplanationSpec();
    /**
     *
     *
     * <pre>
     * Explanation spec details.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 2;</code>
     *
     * @return The explanationSpec.
     */
    com.google.cloud.aiplatform.v1beta1.ExplanationSpec getExplanationSpec();
    /**
     *
     *
     * <pre>
     * Explanation spec details.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 2;</code>
     */
    com.google.cloud.aiplatform.v1beta1.ExplanationSpecOrBuilder getExplanationSpecOrBuilder();
  }
  /**
   * Protobuf type {@code
   * google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec}
   */
  public static final class ModelEvaluationExplanationSpec
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec)
      ModelEvaluationExplanationSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ModelEvaluationExplanationSpec.newBuilder() to construct.
    private ModelEvaluationExplanationSpec(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ModelEvaluationExplanationSpec() {
      explanationType_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ModelEvaluationExplanationSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelEvaluationProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelEvaluation_ModelEvaluationExplanationSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelEvaluationProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelEvaluation_ModelEvaluationExplanationSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
                  .class,
              com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
                  .Builder.class);
    }

    private int bitField0_;
    public static final int EXPLANATION_TYPE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object explanationType_ = "";
    /**
     *
     *
     * <pre>
     * Explanation type.
     *
     * For AutoML Image Classification models, possible values are:
     *
     *   * `image-integrated-gradients`
     *   * `image-xrai`
     * </pre>
     *
     * <code>string explanation_type = 1;</code>
     *
     * @return The explanationType.
     */
    @java.lang.Override
    public java.lang.String getExplanationType() {
      java.lang.Object ref = explanationType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        explanationType_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Explanation type.
     *
     * For AutoML Image Classification models, possible values are:
     *
     *   * `image-integrated-gradients`
     *   * `image-xrai`
     * </pre>
     *
     * <code>string explanation_type = 1;</code>
     *
     * @return The bytes for explanationType.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getExplanationTypeBytes() {
      java.lang.Object ref = explanationType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        explanationType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int EXPLANATION_SPEC_FIELD_NUMBER = 2;
    private com.google.cloud.aiplatform.v1beta1.ExplanationSpec explanationSpec_;
    /**
     *
     *
     * <pre>
     * Explanation spec details.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 2;</code>
     *
     * @return Whether the explanationSpec field is set.
     */
    @java.lang.Override
    public boolean hasExplanationSpec() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Explanation spec details.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 2;</code>
     *
     * @return The explanationSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ExplanationSpec getExplanationSpec() {
      return explanationSpec_ == null
          ? com.google.cloud.aiplatform.v1beta1.ExplanationSpec.getDefaultInstance()
          : explanationSpec_;
    }
    /**
     *
     *
     * <pre>
     * Explanation spec details.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ExplanationSpecOrBuilder
        getExplanationSpecOrBuilder() {
      return explanationSpec_ == null
          ? com.google.cloud.aiplatform.v1beta1.ExplanationSpec.getDefaultInstance()
          : explanationSpec_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(explanationType_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, explanationType_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getExplanationSpec());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(explanationType_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, explanationType_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getExplanationSpec());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec other =
          (com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec) obj;

      if (!getExplanationType().equals(other.getExplanationType())) return false;
      if (hasExplanationSpec() != other.hasExplanationSpec()) return false;
      if (hasExplanationSpec()) {
        if (!getExplanationSpec().equals(other.getExplanationSpec())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + EXPLANATION_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getExplanationType().hashCode();
      if (hasExplanationSpec()) {
        hash = (37 * hash) + EXPLANATION_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getExplanationSpec().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec)
        com.google.cloud.aiplatform.v1beta1.ModelEvaluation
            .ModelEvaluationExplanationSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ModelEvaluationProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelEvaluation_ModelEvaluationExplanationSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ModelEvaluationProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelEvaluation_ModelEvaluationExplanationSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
                    .class,
                com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getExplanationSpecFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        explanationType_ = "";
        explanationSpec_ = null;
        if (explanationSpecBuilder_ != null) {
          explanationSpecBuilder_.dispose();
          explanationSpecBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelEvaluationProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelEvaluation_ModelEvaluationExplanationSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
          build() {
        com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec result =
            new com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.explanationType_ = explanationType_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.explanationSpec_ =
              explanationSpecBuilder_ == null ? explanationSpec_ : explanationSpecBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
              other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
                .getDefaultInstance()) return this;
        if (!other.getExplanationType().isEmpty()) {
          explanationType_ = other.explanationType_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasExplanationSpec()) {
          mergeExplanationSpec(other.getExplanationSpec());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  explanationType_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getExplanationSpecFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object explanationType_ = "";
      /**
       *
       *
       * <pre>
       * Explanation type.
       *
       * For AutoML Image Classification models, possible values are:
       *
       *   * `image-integrated-gradients`
       *   * `image-xrai`
       * </pre>
       *
       * <code>string explanation_type = 1;</code>
       *
       * @return The explanationType.
       */
      public java.lang.String getExplanationType() {
        java.lang.Object ref = explanationType_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          explanationType_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Explanation type.
       *
       * For AutoML Image Classification models, possible values are:
       *
       *   * `image-integrated-gradients`
       *   * `image-xrai`
       * </pre>
       *
       * <code>string explanation_type = 1;</code>
       *
       * @return The bytes for explanationType.
       */
      public com.google.protobuf.ByteString getExplanationTypeBytes() {
        java.lang.Object ref = explanationType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          explanationType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Explanation type.
       *
       * For AutoML Image Classification models, possible values are:
       *
       *   * `image-integrated-gradients`
       *   * `image-xrai`
       * </pre>
       *
       * <code>string explanation_type = 1;</code>
       *
       * @param value The explanationType to set.
       * @return This builder for chaining.
       */
      public Builder setExplanationType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        explanationType_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Explanation type.
       *
       * For AutoML Image Classification models, possible values are:
       *
       *   * `image-integrated-gradients`
       *   * `image-xrai`
       * </pre>
       *
       * <code>string explanation_type = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExplanationType() {
        explanationType_ = getDefaultInstance().getExplanationType();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Explanation type.
       *
       * For AutoML Image Classification models, possible values are:
       *
       *   * `image-integrated-gradients`
       *   * `image-xrai`
       * </pre>
       *
       * <code>string explanation_type = 1;</code>
       *
       * @param value The bytes for explanationType to set.
       * @return This builder for chaining.
       */
      public Builder setExplanationTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        explanationType_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.cloud.aiplatform.v1beta1.ExplanationSpec explanationSpec_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ExplanationSpec,
              com.google.cloud.aiplatform.v1beta1.ExplanationSpec.Builder,
              com.google.cloud.aiplatform.v1beta1.ExplanationSpecOrBuilder>
          explanationSpecBuilder_;
      /**
       *
       *
       * <pre>
       * Explanation spec details.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 2;</code>
       *
       * @return Whether the explanationSpec field is set.
       */
      public boolean hasExplanationSpec() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Explanation spec details.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 2;</code>
       *
       * @return The explanationSpec.
       */
      public com.google.cloud.aiplatform.v1beta1.ExplanationSpec getExplanationSpec() {
        if (explanationSpecBuilder_ == null) {
          return explanationSpec_ == null
              ? com.google.cloud.aiplatform.v1beta1.ExplanationSpec.getDefaultInstance()
              : explanationSpec_;
        } else {
          return explanationSpecBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Explanation spec details.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 2;</code>
       */
      public Builder setExplanationSpec(com.google.cloud.aiplatform.v1beta1.ExplanationSpec value) {
        if (explanationSpecBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          explanationSpec_ = value;
        } else {
          explanationSpecBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Explanation spec details.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 2;</code>
       */
      public Builder setExplanationSpec(
          com.google.cloud.aiplatform.v1beta1.ExplanationSpec.Builder builderForValue) {
        if (explanationSpecBuilder_ == null) {
          explanationSpec_ = builderForValue.build();
        } else {
          explanationSpecBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Explanation spec details.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 2;</code>
       */
      public Builder mergeExplanationSpec(
          com.google.cloud.aiplatform.v1beta1.ExplanationSpec value) {
        if (explanationSpecBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && explanationSpec_ != null
              && explanationSpec_
                  != com.google.cloud.aiplatform.v1beta1.ExplanationSpec.getDefaultInstance()) {
            getExplanationSpecBuilder().mergeFrom(value);
          } else {
            explanationSpec_ = value;
          }
        } else {
          explanationSpecBuilder_.mergeFrom(value);
        }
        if (explanationSpec_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Explanation spec details.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 2;</code>
       */
      public Builder clearExplanationSpec() {
        bitField0_ = (bitField0_ & ~0x00000002);
        explanationSpec_ = null;
        if (explanationSpecBuilder_ != null) {
          explanationSpecBuilder_.dispose();
          explanationSpecBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Explanation spec details.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 2;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.ExplanationSpec.Builder
          getExplanationSpecBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getExplanationSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Explanation spec details.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 2;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.ExplanationSpecOrBuilder
          getExplanationSpecOrBuilder() {
        if (explanationSpecBuilder_ != null) {
          return explanationSpecBuilder_.getMessageOrBuilder();
        } else {
          return explanationSpec_ == null
              ? com.google.cloud.aiplatform.v1beta1.ExplanationSpec.getDefaultInstance()
              : explanationSpec_;
        }
      }
      /**
       *
       *
       * <pre>
       * Explanation spec details.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ExplanationSpec,
              com.google.cloud.aiplatform.v1beta1.ExplanationSpec.Builder,
              com.google.cloud.aiplatform.v1beta1.ExplanationSpecOrBuilder>
          getExplanationSpecFieldBuilder() {
        if (explanationSpecBuilder_ == null) {
          explanationSpecBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.ExplanationSpec,
                  com.google.cloud.aiplatform.v1beta1.ExplanationSpec.Builder,
                  com.google.cloud.aiplatform.v1beta1.ExplanationSpecOrBuilder>(
                  getExplanationSpec(), getParentForChildren(), isClean());
          explanationSpec_ = null;
        }
        return explanationSpecBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec)
    private static final com.google.cloud.aiplatform.v1beta1.ModelEvaluation
            .ModelEvaluationExplanationSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec();
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ModelEvaluationExplanationSpec> PARSER =
        new com.google.protobuf.AbstractParser<ModelEvaluationExplanationSpec>() {
          @java.lang.Override
          public ModelEvaluationExplanationSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ModelEvaluationExplanationSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ModelEvaluationExplanationSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface BiasConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Specification for how the data should be sliced for bias. It contains a
     * list of slices, with limitation of two slices. The first slice of data
     * will be the slice_a. The second slice in the list (slice_b) will be
     * compared against the first slice. If only a single slice is provided,
     * then slice_a will be compared against "not slice_a".
     * Below are examples with feature "education" with value "low", "medium",
     * "high" in the dataset:
     *
     * Example 1:
     *
     *     bias_slices = [{'education': 'low'}]
     *
     * A single slice provided. In this case, slice_a is the collection of data
     * with 'education' equals 'low', and slice_b is the collection of data with
     * 'education' equals 'medium' or 'high'.
     *
     * Example 2:
     *
     *     bias_slices = [{'education': 'low'},
     *                    {'education': 'high'}]
     *
     * Two slices provided. In this case, slice_a is the collection of data
     * with 'education' equals 'low', and slice_b is the collection of data with
     * 'education' equals 'high'.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpec bias_slices = 1;
     * </code>
     *
     * @return Whether the biasSlices field is set.
     */
    boolean hasBiasSlices();
    /**
     *
     *
     * <pre>
     * Specification for how the data should be sliced for bias. It contains a
     * list of slices, with limitation of two slices. The first slice of data
     * will be the slice_a. The second slice in the list (slice_b) will be
     * compared against the first slice. If only a single slice is provided,
     * then slice_a will be compared against "not slice_a".
     * Below are examples with feature "education" with value "low", "medium",
     * "high" in the dataset:
     *
     * Example 1:
     *
     *     bias_slices = [{'education': 'low'}]
     *
     * A single slice provided. In this case, slice_a is the collection of data
     * with 'education' equals 'low', and slice_b is the collection of data with
     * 'education' equals 'medium' or 'high'.
     *
     * Example 2:
     *
     *     bias_slices = [{'education': 'low'},
     *                    {'education': 'high'}]
     *
     * Two slices provided. In this case, slice_a is the collection of data
     * with 'education' equals 'low', and slice_b is the collection of data with
     * 'education' equals 'high'.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpec bias_slices = 1;
     * </code>
     *
     * @return The biasSlices.
     */
    com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpec getBiasSlices();
    /**
     *
     *
     * <pre>
     * Specification for how the data should be sliced for bias. It contains a
     * list of slices, with limitation of two slices. The first slice of data
     * will be the slice_a. The second slice in the list (slice_b) will be
     * compared against the first slice. If only a single slice is provided,
     * then slice_a will be compared against "not slice_a".
     * Below are examples with feature "education" with value "low", "medium",
     * "high" in the dataset:
     *
     * Example 1:
     *
     *     bias_slices = [{'education': 'low'}]
     *
     * A single slice provided. In this case, slice_a is the collection of data
     * with 'education' equals 'low', and slice_b is the collection of data with
     * 'education' equals 'medium' or 'high'.
     *
     * Example 2:
     *
     *     bias_slices = [{'education': 'low'},
     *                    {'education': 'high'}]
     *
     * Two slices provided. In this case, slice_a is the collection of data
     * with 'education' equals 'low', and slice_b is the collection of data with
     * 'education' equals 'high'.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpec bias_slices = 1;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpecOrBuilder
        getBiasSlicesOrBuilder();

    /**
     *
     *
     * <pre>
     * Positive labels selection on the target field.
     * </pre>
     *
     * <code>repeated string labels = 2;</code>
     *
     * @return A list containing the labels.
     */
    java.util.List<java.lang.String> getLabelsList();
    /**
     *
     *
     * <pre>
     * Positive labels selection on the target field.
     * </pre>
     *
     * <code>repeated string labels = 2;</code>
     *
     * @return The count of labels.
     */
    int getLabelsCount();
    /**
     *
     *
     * <pre>
     * Positive labels selection on the target field.
     * </pre>
     *
     * <code>repeated string labels = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The labels at the given index.
     */
    java.lang.String getLabels(int index);
    /**
     *
     *
     * <pre>
     * Positive labels selection on the target field.
     * </pre>
     *
     * <code>repeated string labels = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the labels at the given index.
     */
    com.google.protobuf.ByteString getLabelsBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Configuration for bias detection.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig}
   */
  public static final class BiasConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig)
      BiasConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use BiasConfig.newBuilder() to construct.
    private BiasConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BiasConfig() {
      labels_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BiasConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelEvaluationProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelEvaluation_BiasConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelEvaluationProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelEvaluation_BiasConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig.class,
              com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig.Builder.class);
    }

    private int bitField0_;
    public static final int BIAS_SLICES_FIELD_NUMBER = 1;
    private com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpec biasSlices_;
    /**
     *
     *
     * <pre>
     * Specification for how the data should be sliced for bias. It contains a
     * list of slices, with limitation of two slices. The first slice of data
     * will be the slice_a. The second slice in the list (slice_b) will be
     * compared against the first slice. If only a single slice is provided,
     * then slice_a will be compared against "not slice_a".
     * Below are examples with feature "education" with value "low", "medium",
     * "high" in the dataset:
     *
     * Example 1:
     *
     *     bias_slices = [{'education': 'low'}]
     *
     * A single slice provided. In this case, slice_a is the collection of data
     * with 'education' equals 'low', and slice_b is the collection of data with
     * 'education' equals 'medium' or 'high'.
     *
     * Example 2:
     *
     *     bias_slices = [{'education': 'low'},
     *                    {'education': 'high'}]
     *
     * Two slices provided. In this case, slice_a is the collection of data
     * with 'education' equals 'low', and slice_b is the collection of data with
     * 'education' equals 'high'.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpec bias_slices = 1;
     * </code>
     *
     * @return Whether the biasSlices field is set.
     */
    @java.lang.Override
    public boolean hasBiasSlices() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specification for how the data should be sliced for bias. It contains a
     * list of slices, with limitation of two slices. The first slice of data
     * will be the slice_a. The second slice in the list (slice_b) will be
     * compared against the first slice. If only a single slice is provided,
     * then slice_a will be compared against "not slice_a".
     * Below are examples with feature "education" with value "low", "medium",
     * "high" in the dataset:
     *
     * Example 1:
     *
     *     bias_slices = [{'education': 'low'}]
     *
     * A single slice provided. In this case, slice_a is the collection of data
     * with 'education' equals 'low', and slice_b is the collection of data with
     * 'education' equals 'medium' or 'high'.
     *
     * Example 2:
     *
     *     bias_slices = [{'education': 'low'},
     *                    {'education': 'high'}]
     *
     * Two slices provided. In this case, slice_a is the collection of data
     * with 'education' equals 'low', and slice_b is the collection of data with
     * 'education' equals 'high'.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpec bias_slices = 1;
     * </code>
     *
     * @return The biasSlices.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpec
        getBiasSlices() {
      return biasSlices_ == null
          ? com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpec
              .getDefaultInstance()
          : biasSlices_;
    }
    /**
     *
     *
     * <pre>
     * Specification for how the data should be sliced for bias. It contains a
     * list of slices, with limitation of two slices. The first slice of data
     * will be the slice_a. The second slice in the list (slice_b) will be
     * compared against the first slice. If only a single slice is provided,
     * then slice_a will be compared against "not slice_a".
     * Below are examples with feature "education" with value "low", "medium",
     * "high" in the dataset:
     *
     * Example 1:
     *
     *     bias_slices = [{'education': 'low'}]
     *
     * A single slice provided. In this case, slice_a is the collection of data
     * with 'education' equals 'low', and slice_b is the collection of data with
     * 'education' equals 'medium' or 'high'.
     *
     * Example 2:
     *
     *     bias_slices = [{'education': 'low'},
     *                    {'education': 'high'}]
     *
     * Two slices provided. In this case, slice_a is the collection of data
     * with 'education' equals 'low', and slice_b is the collection of data with
     * 'education' equals 'high'.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpec bias_slices = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpecOrBuilder
        getBiasSlicesOrBuilder() {
      return biasSlices_ == null
          ? com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpec
              .getDefaultInstance()
          : biasSlices_;
    }

    public static final int LABELS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList labels_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Positive labels selection on the target field.
     * </pre>
     *
     * <code>repeated string labels = 2;</code>
     *
     * @return A list containing the labels.
     */
    public com.google.protobuf.ProtocolStringList getLabelsList() {
      return labels_;
    }
    /**
     *
     *
     * <pre>
     * Positive labels selection on the target field.
     * </pre>
     *
     * <code>repeated string labels = 2;</code>
     *
     * @return The count of labels.
     */
    public int getLabelsCount() {
      return labels_.size();
    }
    /**
     *
     *
     * <pre>
     * Positive labels selection on the target field.
     * </pre>
     *
     * <code>repeated string labels = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The labels at the given index.
     */
    public java.lang.String getLabels(int index) {
      return labels_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Positive labels selection on the target field.
     * </pre>
     *
     * <code>repeated string labels = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the labels at the given index.
     */
    public com.google.protobuf.ByteString getLabelsBytes(int index) {
      return labels_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getBiasSlices());
      }
      for (int i = 0; i < labels_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, labels_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getBiasSlices());
      }
      {
        int dataSize = 0;
        for (int i = 0; i < labels_.size(); i++) {
          dataSize += computeStringSizeNoTag(labels_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getLabelsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig other =
          (com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig) obj;

      if (hasBiasSlices() != other.hasBiasSlices()) return false;
      if (hasBiasSlices()) {
        if (!getBiasSlices().equals(other.getBiasSlices())) return false;
      }
      if (!getLabelsList().equals(other.getLabelsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasBiasSlices()) {
        hash = (37 * hash) + BIAS_SLICES_FIELD_NUMBER;
        hash = (53 * hash) + getBiasSlices().hashCode();
      }
      if (getLabelsCount() > 0) {
        hash = (37 * hash) + LABELS_FIELD_NUMBER;
        hash = (53 * hash) + getLabelsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration for bias detection.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig)
        com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ModelEvaluationProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelEvaluation_BiasConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ModelEvaluationProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelEvaluation_BiasConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig.class,
                com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getBiasSlicesFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        biasSlices_ = null;
        if (biasSlicesBuilder_ != null) {
          biasSlicesBuilder_.dispose();
          biasSlicesBuilder_ = null;
        }
        labels_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelEvaluationProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelEvaluation_BiasConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig build() {
        com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig buildPartial() {
        com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig result =
            new com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.biasSlices_ =
              biasSlicesBuilder_ == null ? biasSlices_ : biasSlicesBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          labels_.makeImmutable();
          result.labels_ = labels_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig) {
          return mergeFrom((com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig.getDefaultInstance())
          return this;
        if (other.hasBiasSlices()) {
          mergeBiasSlices(other.getBiasSlices());
        }
        if (!other.labels_.isEmpty()) {
          if (labels_.isEmpty()) {
            labels_ = other.labels_;
            bitField0_ |= 0x00000002;
          } else {
            ensureLabelsIsMutable();
            labels_.addAll(other.labels_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getBiasSlicesFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureLabelsIsMutable();
                  labels_.add(s);
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpec biasSlices_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpec,
              com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpec.Builder,
              com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpecOrBuilder>
          biasSlicesBuilder_;
      /**
       *
       *
       * <pre>
       * Specification for how the data should be sliced for bias. It contains a
       * list of slices, with limitation of two slices. The first slice of data
       * will be the slice_a. The second slice in the list (slice_b) will be
       * compared against the first slice. If only a single slice is provided,
       * then slice_a will be compared against "not slice_a".
       * Below are examples with feature "education" with value "low", "medium",
       * "high" in the dataset:
       *
       * Example 1:
       *
       *     bias_slices = [{'education': 'low'}]
       *
       * A single slice provided. In this case, slice_a is the collection of data
       * with 'education' equals 'low', and slice_b is the collection of data with
       * 'education' equals 'medium' or 'high'.
       *
       * Example 2:
       *
       *     bias_slices = [{'education': 'low'},
       *                    {'education': 'high'}]
       *
       * Two slices provided. In this case, slice_a is the collection of data
       * with 'education' equals 'low', and slice_b is the collection of data with
       * 'education' equals 'high'.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpec bias_slices = 1;
       * </code>
       *
       * @return Whether the biasSlices field is set.
       */
      public boolean hasBiasSlices() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Specification for how the data should be sliced for bias. It contains a
       * list of slices, with limitation of two slices. The first slice of data
       * will be the slice_a. The second slice in the list (slice_b) will be
       * compared against the first slice. If only a single slice is provided,
       * then slice_a will be compared against "not slice_a".
       * Below are examples with feature "education" with value "low", "medium",
       * "high" in the dataset:
       *
       * Example 1:
       *
       *     bias_slices = [{'education': 'low'}]
       *
       * A single slice provided. In this case, slice_a is the collection of data
       * with 'education' equals 'low', and slice_b is the collection of data with
       * 'education' equals 'medium' or 'high'.
       *
       * Example 2:
       *
       *     bias_slices = [{'education': 'low'},
       *                    {'education': 'high'}]
       *
       * Two slices provided. In this case, slice_a is the collection of data
       * with 'education' equals 'low', and slice_b is the collection of data with
       * 'education' equals 'high'.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpec bias_slices = 1;
       * </code>
       *
       * @return The biasSlices.
       */
      public com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpec
          getBiasSlices() {
        if (biasSlicesBuilder_ == null) {
          return biasSlices_ == null
              ? com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpec
                  .getDefaultInstance()
              : biasSlices_;
        } else {
          return biasSlicesBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Specification for how the data should be sliced for bias. It contains a
       * list of slices, with limitation of two slices. The first slice of data
       * will be the slice_a. The second slice in the list (slice_b) will be
       * compared against the first slice. If only a single slice is provided,
       * then slice_a will be compared against "not slice_a".
       * Below are examples with feature "education" with value "low", "medium",
       * "high" in the dataset:
       *
       * Example 1:
       *
       *     bias_slices = [{'education': 'low'}]
       *
       * A single slice provided. In this case, slice_a is the collection of data
       * with 'education' equals 'low', and slice_b is the collection of data with
       * 'education' equals 'medium' or 'high'.
       *
       * Example 2:
       *
       *     bias_slices = [{'education': 'low'},
       *                    {'education': 'high'}]
       *
       * Two slices provided. In this case, slice_a is the collection of data
       * with 'education' equals 'low', and slice_b is the collection of data with
       * 'education' equals 'high'.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpec bias_slices = 1;
       * </code>
       */
      public Builder setBiasSlices(
          com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpec value) {
        if (biasSlicesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          biasSlices_ = value;
        } else {
          biasSlicesBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specification for how the data should be sliced for bias. It contains a
       * list of slices, with limitation of two slices. The first slice of data
       * will be the slice_a. The second slice in the list (slice_b) will be
       * compared against the first slice. If only a single slice is provided,
       * then slice_a will be compared against "not slice_a".
       * Below are examples with feature "education" with value "low", "medium",
       * "high" in the dataset:
       *
       * Example 1:
       *
       *     bias_slices = [{'education': 'low'}]
       *
       * A single slice provided. In this case, slice_a is the collection of data
       * with 'education' equals 'low', and slice_b is the collection of data with
       * 'education' equals 'medium' or 'high'.
       *
       * Example 2:
       *
       *     bias_slices = [{'education': 'low'},
       *                    {'education': 'high'}]
       *
       * Two slices provided. In this case, slice_a is the collection of data
       * with 'education' equals 'low', and slice_b is the collection of data with
       * 'education' equals 'high'.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpec bias_slices = 1;
       * </code>
       */
      public Builder setBiasSlices(
          com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpec.Builder
              builderForValue) {
        if (biasSlicesBuilder_ == null) {
          biasSlices_ = builderForValue.build();
        } else {
          biasSlicesBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specification for how the data should be sliced for bias. It contains a
       * list of slices, with limitation of two slices. The first slice of data
       * will be the slice_a. The second slice in the list (slice_b) will be
       * compared against the first slice. If only a single slice is provided,
       * then slice_a will be compared against "not slice_a".
       * Below are examples with feature "education" with value "low", "medium",
       * "high" in the dataset:
       *
       * Example 1:
       *
       *     bias_slices = [{'education': 'low'}]
       *
       * A single slice provided. In this case, slice_a is the collection of data
       * with 'education' equals 'low', and slice_b is the collection of data with
       * 'education' equals 'medium' or 'high'.
       *
       * Example 2:
       *
       *     bias_slices = [{'education': 'low'},
       *                    {'education': 'high'}]
       *
       * Two slices provided. In this case, slice_a is the collection of data
       * with 'education' equals 'low', and slice_b is the collection of data with
       * 'education' equals 'high'.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpec bias_slices = 1;
       * </code>
       */
      public Builder mergeBiasSlices(
          com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpec value) {
        if (biasSlicesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && biasSlices_ != null
              && biasSlices_
                  != com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpec
                      .getDefaultInstance()) {
            getBiasSlicesBuilder().mergeFrom(value);
          } else {
            biasSlices_ = value;
          }
        } else {
          biasSlicesBuilder_.mergeFrom(value);
        }
        if (biasSlices_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specification for how the data should be sliced for bias. It contains a
       * list of slices, with limitation of two slices. The first slice of data
       * will be the slice_a. The second slice in the list (slice_b) will be
       * compared against the first slice. If only a single slice is provided,
       * then slice_a will be compared against "not slice_a".
       * Below are examples with feature "education" with value "low", "medium",
       * "high" in the dataset:
       *
       * Example 1:
       *
       *     bias_slices = [{'education': 'low'}]
       *
       * A single slice provided. In this case, slice_a is the collection of data
       * with 'education' equals 'low', and slice_b is the collection of data with
       * 'education' equals 'medium' or 'high'.
       *
       * Example 2:
       *
       *     bias_slices = [{'education': 'low'},
       *                    {'education': 'high'}]
       *
       * Two slices provided. In this case, slice_a is the collection of data
       * with 'education' equals 'low', and slice_b is the collection of data with
       * 'education' equals 'high'.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpec bias_slices = 1;
       * </code>
       */
      public Builder clearBiasSlices() {
        bitField0_ = (bitField0_ & ~0x00000001);
        biasSlices_ = null;
        if (biasSlicesBuilder_ != null) {
          biasSlicesBuilder_.dispose();
          biasSlicesBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specification for how the data should be sliced for bias. It contains a
       * list of slices, with limitation of two slices. The first slice of data
       * will be the slice_a. The second slice in the list (slice_b) will be
       * compared against the first slice. If only a single slice is provided,
       * then slice_a will be compared against "not slice_a".
       * Below are examples with feature "education" with value "low", "medium",
       * "high" in the dataset:
       *
       * Example 1:
       *
       *     bias_slices = [{'education': 'low'}]
       *
       * A single slice provided. In this case, slice_a is the collection of data
       * with 'education' equals 'low', and slice_b is the collection of data with
       * 'education' equals 'medium' or 'high'.
       *
       * Example 2:
       *
       *     bias_slices = [{'education': 'low'},
       *                    {'education': 'high'}]
       *
       * Two slices provided. In this case, slice_a is the collection of data
       * with 'education' equals 'low', and slice_b is the collection of data with
       * 'education' equals 'high'.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpec bias_slices = 1;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpec.Builder
          getBiasSlicesBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getBiasSlicesFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Specification for how the data should be sliced for bias. It contains a
       * list of slices, with limitation of two slices. The first slice of data
       * will be the slice_a. The second slice in the list (slice_b) will be
       * compared against the first slice. If only a single slice is provided,
       * then slice_a will be compared against "not slice_a".
       * Below are examples with feature "education" with value "low", "medium",
       * "high" in the dataset:
       *
       * Example 1:
       *
       *     bias_slices = [{'education': 'low'}]
       *
       * A single slice provided. In this case, slice_a is the collection of data
       * with 'education' equals 'low', and slice_b is the collection of data with
       * 'education' equals 'medium' or 'high'.
       *
       * Example 2:
       *
       *     bias_slices = [{'education': 'low'},
       *                    {'education': 'high'}]
       *
       * Two slices provided. In this case, slice_a is the collection of data
       * with 'education' equals 'low', and slice_b is the collection of data with
       * 'education' equals 'high'.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpec bias_slices = 1;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpecOrBuilder
          getBiasSlicesOrBuilder() {
        if (biasSlicesBuilder_ != null) {
          return biasSlicesBuilder_.getMessageOrBuilder();
        } else {
          return biasSlices_ == null
              ? com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpec
                  .getDefaultInstance()
              : biasSlices_;
        }
      }
      /**
       *
       *
       * <pre>
       * Specification for how the data should be sliced for bias. It contains a
       * list of slices, with limitation of two slices. The first slice of data
       * will be the slice_a. The second slice in the list (slice_b) will be
       * compared against the first slice. If only a single slice is provided,
       * then slice_a will be compared against "not slice_a".
       * Below are examples with feature "education" with value "low", "medium",
       * "high" in the dataset:
       *
       * Example 1:
       *
       *     bias_slices = [{'education': 'low'}]
       *
       * A single slice provided. In this case, slice_a is the collection of data
       * with 'education' equals 'low', and slice_b is the collection of data with
       * 'education' equals 'medium' or 'high'.
       *
       * Example 2:
       *
       *     bias_slices = [{'education': 'low'},
       *                    {'education': 'high'}]
       *
       * Two slices provided. In this case, slice_a is the collection of data
       * with 'education' equals 'low', and slice_b is the collection of data with
       * 'education' equals 'high'.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpec bias_slices = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpec,
              com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpec.Builder,
              com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpecOrBuilder>
          getBiasSlicesFieldBuilder() {
        if (biasSlicesBuilder_ == null) {
          biasSlicesBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpec,
                  com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.SliceSpec.Builder,
                  com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice
                      .SliceSpecOrBuilder>(getBiasSlices(), getParentForChildren(), isClean());
          biasSlices_ = null;
        }
        return biasSlicesBuilder_;
      }

      private com.google.protobuf.LazyStringArrayList labels_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureLabelsIsMutable() {
        if (!labels_.isModifiable()) {
          labels_ = new com.google.protobuf.LazyStringArrayList(labels_);
        }
        bitField0_ |= 0x00000002;
      }
      /**
       *
       *
       * <pre>
       * Positive labels selection on the target field.
       * </pre>
       *
       * <code>repeated string labels = 2;</code>
       *
       * @return A list containing the labels.
       */
      public com.google.protobuf.ProtocolStringList getLabelsList() {
        labels_.makeImmutable();
        return labels_;
      }
      /**
       *
       *
       * <pre>
       * Positive labels selection on the target field.
       * </pre>
       *
       * <code>repeated string labels = 2;</code>
       *
       * @return The count of labels.
       */
      public int getLabelsCount() {
        return labels_.size();
      }
      /**
       *
       *
       * <pre>
       * Positive labels selection on the target field.
       * </pre>
       *
       * <code>repeated string labels = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The labels at the given index.
       */
      public java.lang.String getLabels(int index) {
        return labels_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Positive labels selection on the target field.
       * </pre>
       *
       * <code>repeated string labels = 2;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the labels at the given index.
       */
      public com.google.protobuf.ByteString getLabelsBytes(int index) {
        return labels_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Positive labels selection on the target field.
       * </pre>
       *
       * <code>repeated string labels = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The labels to set.
       * @return This builder for chaining.
       */
      public Builder setLabels(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelsIsMutable();
        labels_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Positive labels selection on the target field.
       * </pre>
       *
       * <code>repeated string labels = 2;</code>
       *
       * @param value The labels to add.
       * @return This builder for chaining.
       */
      public Builder addLabels(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelsIsMutable();
        labels_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Positive labels selection on the target field.
       * </pre>
       *
       * <code>repeated string labels = 2;</code>
       *
       * @param values The labels to add.
       * @return This builder for chaining.
       */
      public Builder addAllLabels(java.lang.Iterable<java.lang.String> values) {
        ensureLabelsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, labels_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Positive labels selection on the target field.
       * </pre>
       *
       * <code>repeated string labels = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLabels() {
        labels_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Positive labels selection on the target field.
       * </pre>
       *
       * <code>repeated string labels = 2;</code>
       *
       * @param value The bytes of the labels to add.
       * @return This builder for chaining.
       */
      public Builder addLabelsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureLabelsIsMutable();
        labels_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig)
    private static final com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BiasConfig> PARSER =
        new com.google.protobuf.AbstractParser<BiasConfig>() {
          @java.lang.Override
          public BiasConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<BiasConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BiasConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the ModelEvaluation.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the ModelEvaluation.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * The display name of the ModelEvaluation.
   * </pre>
   *
   * <code>string display_name = 10;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The display name of the ModelEvaluation.
   * </pre>
   *
   * <code>string display_name = 10;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METRICS_SCHEMA_URI_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object metricsSchemaUri_ = "";
  /**
   *
   *
   * <pre>
   * Points to a YAML file stored on Google Cloud Storage describing the
   * [metrics][google.cloud.aiplatform.v1beta1.ModelEvaluation.metrics] of this
   * ModelEvaluation. The schema is defined as an OpenAPI 3.0.2 [Schema
   * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
   * </pre>
   *
   * <code>string metrics_schema_uri = 2;</code>
   *
   * @return The metricsSchemaUri.
   */
  @java.lang.Override
  public java.lang.String getMetricsSchemaUri() {
    java.lang.Object ref = metricsSchemaUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      metricsSchemaUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Points to a YAML file stored on Google Cloud Storage describing the
   * [metrics][google.cloud.aiplatform.v1beta1.ModelEvaluation.metrics] of this
   * ModelEvaluation. The schema is defined as an OpenAPI 3.0.2 [Schema
   * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
   * </pre>
   *
   * <code>string metrics_schema_uri = 2;</code>
   *
   * @return The bytes for metricsSchemaUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMetricsSchemaUriBytes() {
    java.lang.Object ref = metricsSchemaUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      metricsSchemaUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METRICS_FIELD_NUMBER = 3;
  private com.google.protobuf.Value metrics_;
  /**
   *
   *
   * <pre>
   * Evaluation metrics of the Model. The schema of the metrics is stored in
   * [metrics_schema_uri][google.cloud.aiplatform.v1beta1.ModelEvaluation.metrics_schema_uri]
   * </pre>
   *
   * <code>.google.protobuf.Value metrics = 3;</code>
   *
   * @return Whether the metrics field is set.
   */
  @java.lang.Override
  public boolean hasMetrics() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Evaluation metrics of the Model. The schema of the metrics is stored in
   * [metrics_schema_uri][google.cloud.aiplatform.v1beta1.ModelEvaluation.metrics_schema_uri]
   * </pre>
   *
   * <code>.google.protobuf.Value metrics = 3;</code>
   *
   * @return The metrics.
   */
  @java.lang.Override
  public com.google.protobuf.Value getMetrics() {
    return metrics_ == null ? com.google.protobuf.Value.getDefaultInstance() : metrics_;
  }
  /**
   *
   *
   * <pre>
   * Evaluation metrics of the Model. The schema of the metrics is stored in
   * [metrics_schema_uri][google.cloud.aiplatform.v1beta1.ModelEvaluation.metrics_schema_uri]
   * </pre>
   *
   * <code>.google.protobuf.Value metrics = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.ValueOrBuilder getMetricsOrBuilder() {
    return metrics_ == null ? com.google.protobuf.Value.getDefaultInstance() : metrics_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this ModelEvaluation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this ModelEvaluation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this ModelEvaluation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int SLICE_DIMENSIONS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList sliceDimensions_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * All possible
   * [dimensions][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.dimension]
   * of ModelEvaluationSlices. The dimensions can be used as the filter of the
   * [ModelService.ListModelEvaluationSlices][google.cloud.aiplatform.v1beta1.ModelService.ListModelEvaluationSlices]
   * request, in the form of `slice.dimension = &lt;dimension&gt;`.
   * </pre>
   *
   * <code>repeated string slice_dimensions = 5;</code>
   *
   * @return A list containing the sliceDimensions.
   */
  public com.google.protobuf.ProtocolStringList getSliceDimensionsList() {
    return sliceDimensions_;
  }
  /**
   *
   *
   * <pre>
   * All possible
   * [dimensions][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.dimension]
   * of ModelEvaluationSlices. The dimensions can be used as the filter of the
   * [ModelService.ListModelEvaluationSlices][google.cloud.aiplatform.v1beta1.ModelService.ListModelEvaluationSlices]
   * request, in the form of `slice.dimension = &lt;dimension&gt;`.
   * </pre>
   *
   * <code>repeated string slice_dimensions = 5;</code>
   *
   * @return The count of sliceDimensions.
   */
  public int getSliceDimensionsCount() {
    return sliceDimensions_.size();
  }
  /**
   *
   *
   * <pre>
   * All possible
   * [dimensions][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.dimension]
   * of ModelEvaluationSlices. The dimensions can be used as the filter of the
   * [ModelService.ListModelEvaluationSlices][google.cloud.aiplatform.v1beta1.ModelService.ListModelEvaluationSlices]
   * request, in the form of `slice.dimension = &lt;dimension&gt;`.
   * </pre>
   *
   * <code>repeated string slice_dimensions = 5;</code>
   *
   * @param index The index of the element to return.
   * @return The sliceDimensions at the given index.
   */
  public java.lang.String getSliceDimensions(int index) {
    return sliceDimensions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * All possible
   * [dimensions][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.dimension]
   * of ModelEvaluationSlices. The dimensions can be used as the filter of the
   * [ModelService.ListModelEvaluationSlices][google.cloud.aiplatform.v1beta1.ModelService.ListModelEvaluationSlices]
   * request, in the form of `slice.dimension = &lt;dimension&gt;`.
   * </pre>
   *
   * <code>repeated string slice_dimensions = 5;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the sliceDimensions at the given index.
   */
  public com.google.protobuf.ByteString getSliceDimensionsBytes(int index) {
    return sliceDimensions_.getByteString(index);
  }

  public static final int MODEL_EXPLANATION_FIELD_NUMBER = 8;
  private com.google.cloud.aiplatform.v1beta1.ModelExplanation modelExplanation_;
  /**
   *
   *
   * <pre>
   * Aggregated explanation metrics for the Model's prediction output over the
   * data this ModelEvaluation uses. This field is populated only if the Model
   * is evaluated with explanations, and only for AutoML tabular Models.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelExplanation model_explanation = 8;</code>
   *
   * @return Whether the modelExplanation field is set.
   */
  @java.lang.Override
  public boolean hasModelExplanation() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Aggregated explanation metrics for the Model's prediction output over the
   * data this ModelEvaluation uses. This field is populated only if the Model
   * is evaluated with explanations, and only for AutoML tabular Models.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelExplanation model_explanation = 8;</code>
   *
   * @return The modelExplanation.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelExplanation getModelExplanation() {
    return modelExplanation_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelExplanation.getDefaultInstance()
        : modelExplanation_;
  }
  /**
   *
   *
   * <pre>
   * Aggregated explanation metrics for the Model's prediction output over the
   * data this ModelEvaluation uses. This field is populated only if the Model
   * is evaluated with explanations, and only for AutoML tabular Models.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelExplanation model_explanation = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelExplanationOrBuilder
      getModelExplanationOrBuilder() {
    return modelExplanation_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelExplanation.getDefaultInstance()
        : modelExplanation_;
  }

  public static final int EXPLANATION_SPECS_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec>
      explanationSpecs_;
  /**
   *
   *
   * <pre>
   * Describes the values of
   * [ExplanationSpec][google.cloud.aiplatform.v1beta1.ExplanationSpec] that are
   * used for explaining the predicted values on the evaluated data.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec>
      getExplanationSpecsList() {
    return explanationSpecs_;
  }
  /**
   *
   *
   * <pre>
   * Describes the values of
   * [ExplanationSpec][google.cloud.aiplatform.v1beta1.ExplanationSpec] that are
   * used for explaining the predicted values on the evaluated data.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.aiplatform.v1beta1.ModelEvaluation
                  .ModelEvaluationExplanationSpecOrBuilder>
      getExplanationSpecsOrBuilderList() {
    return explanationSpecs_;
  }
  /**
   *
   *
   * <pre>
   * Describes the values of
   * [ExplanationSpec][google.cloud.aiplatform.v1beta1.ExplanationSpec] that are
   * used for explaining the predicted values on the evaluated data.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
   * </code>
   */
  @java.lang.Override
  public int getExplanationSpecsCount() {
    return explanationSpecs_.size();
  }
  /**
   *
   *
   * <pre>
   * Describes the values of
   * [ExplanationSpec][google.cloud.aiplatform.v1beta1.ExplanationSpec] that are
   * used for explaining the predicted values on the evaluated data.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
      getExplanationSpecs(int index) {
    return explanationSpecs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Describes the values of
   * [ExplanationSpec][google.cloud.aiplatform.v1beta1.ExplanationSpec] that are
   * used for explaining the predicted values on the evaluated data.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpecOrBuilder
      getExplanationSpecsOrBuilder(int index) {
    return explanationSpecs_.get(index);
  }

  public static final int METADATA_FIELD_NUMBER = 11;
  private com.google.protobuf.Value metadata_;
  /**
   *
   *
   * <pre>
   * The metadata of the ModelEvaluation.
   * For the ModelEvaluation uploaded from Managed Pipeline, metadata contains a
   * structured value with keys of "pipeline_job_id", "evaluation_dataset_type",
   * "evaluation_dataset_path", "row_based_metrics_path".
   * </pre>
   *
   * <code>.google.protobuf.Value metadata = 11;</code>
   *
   * @return Whether the metadata field is set.
   */
  @java.lang.Override
  public boolean hasMetadata() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The metadata of the ModelEvaluation.
   * For the ModelEvaluation uploaded from Managed Pipeline, metadata contains a
   * structured value with keys of "pipeline_job_id", "evaluation_dataset_type",
   * "evaluation_dataset_path", "row_based_metrics_path".
   * </pre>
   *
   * <code>.google.protobuf.Value metadata = 11;</code>
   *
   * @return The metadata.
   */
  @java.lang.Override
  public com.google.protobuf.Value getMetadata() {
    return metadata_ == null ? com.google.protobuf.Value.getDefaultInstance() : metadata_;
  }
  /**
   *
   *
   * <pre>
   * The metadata of the ModelEvaluation.
   * For the ModelEvaluation uploaded from Managed Pipeline, metadata contains a
   * structured value with keys of "pipeline_job_id", "evaluation_dataset_type",
   * "evaluation_dataset_path", "row_based_metrics_path".
   * </pre>
   *
   * <code>.google.protobuf.Value metadata = 11;</code>
   */
  @java.lang.Override
  public com.google.protobuf.ValueOrBuilder getMetadataOrBuilder() {
    return metadata_ == null ? com.google.protobuf.Value.getDefaultInstance() : metadata_;
  }

  public static final int BIAS_CONFIGS_FIELD_NUMBER = 12;
  private com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig biasConfigs_;
  /**
   *
   *
   * <pre>
   * Specify the configuration for bias detection.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig bias_configs = 12;</code>
   *
   * @return Whether the biasConfigs field is set.
   */
  @java.lang.Override
  public boolean hasBiasConfigs() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specify the configuration for bias detection.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig bias_configs = 12;</code>
   *
   * @return The biasConfigs.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig getBiasConfigs() {
    return biasConfigs_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig.getDefaultInstance()
        : biasConfigs_;
  }
  /**
   *
   *
   * <pre>
   * Specify the configuration for bias detection.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig bias_configs = 12;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfigOrBuilder
      getBiasConfigsOrBuilder() {
    return biasConfigs_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig.getDefaultInstance()
        : biasConfigs_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metricsSchemaUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, metricsSchemaUri_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getMetrics());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getCreateTime());
    }
    for (int i = 0; i < sliceDimensions_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, sliceDimensions_.getRaw(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(8, getModelExplanation());
    }
    for (int i = 0; i < explanationSpecs_.size(); i++) {
      output.writeMessage(9, explanationSpecs_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, displayName_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(11, getMetadata());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(12, getBiasConfigs());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metricsSchemaUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, metricsSchemaUri_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getMetrics());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCreateTime());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < sliceDimensions_.size(); i++) {
        dataSize += computeStringSizeNoTag(sliceDimensions_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getSliceDimensionsList().size();
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getModelExplanation());
    }
    for (int i = 0; i < explanationSpecs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, explanationSpecs_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, displayName_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getMetadata());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getBiasConfigs());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ModelEvaluation)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.ModelEvaluation other =
        (com.google.cloud.aiplatform.v1beta1.ModelEvaluation) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getMetricsSchemaUri().equals(other.getMetricsSchemaUri())) return false;
    if (hasMetrics() != other.hasMetrics()) return false;
    if (hasMetrics()) {
      if (!getMetrics().equals(other.getMetrics())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!getSliceDimensionsList().equals(other.getSliceDimensionsList())) return false;
    if (hasModelExplanation() != other.hasModelExplanation()) return false;
    if (hasModelExplanation()) {
      if (!getModelExplanation().equals(other.getModelExplanation())) return false;
    }
    if (!getExplanationSpecsList().equals(other.getExplanationSpecsList())) return false;
    if (hasMetadata() != other.hasMetadata()) return false;
    if (hasMetadata()) {
      if (!getMetadata().equals(other.getMetadata())) return false;
    }
    if (hasBiasConfigs() != other.hasBiasConfigs()) return false;
    if (hasBiasConfigs()) {
      if (!getBiasConfigs().equals(other.getBiasConfigs())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + METRICS_SCHEMA_URI_FIELD_NUMBER;
    hash = (53 * hash) + getMetricsSchemaUri().hashCode();
    if (hasMetrics()) {
      hash = (37 * hash) + METRICS_FIELD_NUMBER;
      hash = (53 * hash) + getMetrics().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (getSliceDimensionsCount() > 0) {
      hash = (37 * hash) + SLICE_DIMENSIONS_FIELD_NUMBER;
      hash = (53 * hash) + getSliceDimensionsList().hashCode();
    }
    if (hasModelExplanation()) {
      hash = (37 * hash) + MODEL_EXPLANATION_FIELD_NUMBER;
      hash = (53 * hash) + getModelExplanation().hashCode();
    }
    if (getExplanationSpecsCount() > 0) {
      hash = (37 * hash) + EXPLANATION_SPECS_FIELD_NUMBER;
      hash = (53 * hash) + getExplanationSpecsList().hashCode();
    }
    if (hasMetadata()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getMetadata().hashCode();
    }
    if (hasBiasConfigs()) {
      hash = (37 * hash) + BIAS_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + getBiasConfigs().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.ModelEvaluation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A collection of metrics calculated by comparing Model's predictions on all of
   * the test data against annotations from the test data.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelEvaluation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelEvaluation)
      com.google.cloud.aiplatform.v1beta1.ModelEvaluationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelEvaluationProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelEvaluation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelEvaluationProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelEvaluation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelEvaluation.class,
              com.google.cloud.aiplatform.v1beta1.ModelEvaluation.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.ModelEvaluation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getMetricsFieldBuilder();
        getCreateTimeFieldBuilder();
        getModelExplanationFieldBuilder();
        getExplanationSpecsFieldBuilder();
        getMetadataFieldBuilder();
        getBiasConfigsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      metricsSchemaUri_ = "";
      metrics_ = null;
      if (metricsBuilder_ != null) {
        metricsBuilder_.dispose();
        metricsBuilder_ = null;
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      sliceDimensions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      modelExplanation_ = null;
      if (modelExplanationBuilder_ != null) {
        modelExplanationBuilder_.dispose();
        modelExplanationBuilder_ = null;
      }
      if (explanationSpecsBuilder_ == null) {
        explanationSpecs_ = java.util.Collections.emptyList();
      } else {
        explanationSpecs_ = null;
        explanationSpecsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000080);
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      biasConfigs_ = null;
      if (biasConfigsBuilder_ != null) {
        biasConfigsBuilder_.dispose();
        biasConfigsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelEvaluationProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelEvaluation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelEvaluation getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelEvaluation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelEvaluation build() {
      com.google.cloud.aiplatform.v1beta1.ModelEvaluation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelEvaluation buildPartial() {
      com.google.cloud.aiplatform.v1beta1.ModelEvaluation result =
          new com.google.cloud.aiplatform.v1beta1.ModelEvaluation(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.ModelEvaluation result) {
      if (explanationSpecsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)) {
          explanationSpecs_ = java.util.Collections.unmodifiableList(explanationSpecs_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.explanationSpecs_ = explanationSpecs_;
      } else {
        result.explanationSpecs_ = explanationSpecsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.ModelEvaluation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.metricsSchemaUri_ = metricsSchemaUri_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.metrics_ = metricsBuilder_ == null ? metrics_ : metricsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        sliceDimensions_.makeImmutable();
        result.sliceDimensions_ = sliceDimensions_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.modelExplanation_ =
            modelExplanationBuilder_ == null ? modelExplanation_ : modelExplanationBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.metadata_ = metadataBuilder_ == null ? metadata_ : metadataBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.biasConfigs_ =
            biasConfigsBuilder_ == null ? biasConfigs_ : biasConfigsBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.ModelEvaluation) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.ModelEvaluation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.ModelEvaluation other) {
      if (other == com.google.cloud.aiplatform.v1beta1.ModelEvaluation.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getMetricsSchemaUri().isEmpty()) {
        metricsSchemaUri_ = other.metricsSchemaUri_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasMetrics()) {
        mergeMetrics(other.getMetrics());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (!other.sliceDimensions_.isEmpty()) {
        if (sliceDimensions_.isEmpty()) {
          sliceDimensions_ = other.sliceDimensions_;
          bitField0_ |= 0x00000020;
        } else {
          ensureSliceDimensionsIsMutable();
          sliceDimensions_.addAll(other.sliceDimensions_);
        }
        onChanged();
      }
      if (other.hasModelExplanation()) {
        mergeModelExplanation(other.getModelExplanation());
      }
      if (explanationSpecsBuilder_ == null) {
        if (!other.explanationSpecs_.isEmpty()) {
          if (explanationSpecs_.isEmpty()) {
            explanationSpecs_ = other.explanationSpecs_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensureExplanationSpecsIsMutable();
            explanationSpecs_.addAll(other.explanationSpecs_);
          }
          onChanged();
        }
      } else {
        if (!other.explanationSpecs_.isEmpty()) {
          if (explanationSpecsBuilder_.isEmpty()) {
            explanationSpecsBuilder_.dispose();
            explanationSpecsBuilder_ = null;
            explanationSpecs_ = other.explanationSpecs_;
            bitField0_ = (bitField0_ & ~0x00000080);
            explanationSpecsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getExplanationSpecsFieldBuilder()
                    : null;
          } else {
            explanationSpecsBuilder_.addAllMessages(other.explanationSpecs_);
          }
        }
      }
      if (other.hasMetadata()) {
        mergeMetadata(other.getMetadata());
      }
      if (other.hasBiasConfigs()) {
        mergeBiasConfigs(other.getBiasConfigs());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                metricsSchemaUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getMetricsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSliceDimensionsIsMutable();
                sliceDimensions_.add(s);
                break;
              } // case 42
            case 66:
              {
                input.readMessage(
                    getModelExplanationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            case 74:
              {
                com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
                    m =
                        input.readMessage(
                            com.google.cloud.aiplatform.v1beta1.ModelEvaluation
                                .ModelEvaluationExplanationSpec.parser(),
                            extensionRegistry);
                if (explanationSpecsBuilder_ == null) {
                  ensureExplanationSpecsIsMutable();
                  explanationSpecs_.add(m);
                } else {
                  explanationSpecsBuilder_.addMessage(m);
                }
                break;
              } // case 74
            case 82:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getBiasConfigsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 98
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the ModelEvaluation.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the ModelEvaluation.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the ModelEvaluation.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the ModelEvaluation.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the ModelEvaluation.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The display name of the ModelEvaluation.
     * </pre>
     *
     * <code>string display_name = 10;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the ModelEvaluation.
     * </pre>
     *
     * <code>string display_name = 10;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the ModelEvaluation.
     * </pre>
     *
     * <code>string display_name = 10;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the ModelEvaluation.
     * </pre>
     *
     * <code>string display_name = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the ModelEvaluation.
     * </pre>
     *
     * <code>string display_name = 10;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object metricsSchemaUri_ = "";
    /**
     *
     *
     * <pre>
     * Points to a YAML file stored on Google Cloud Storage describing the
     * [metrics][google.cloud.aiplatform.v1beta1.ModelEvaluation.metrics] of this
     * ModelEvaluation. The schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * </pre>
     *
     * <code>string metrics_schema_uri = 2;</code>
     *
     * @return The metricsSchemaUri.
     */
    public java.lang.String getMetricsSchemaUri() {
      java.lang.Object ref = metricsSchemaUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        metricsSchemaUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Points to a YAML file stored on Google Cloud Storage describing the
     * [metrics][google.cloud.aiplatform.v1beta1.ModelEvaluation.metrics] of this
     * ModelEvaluation. The schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * </pre>
     *
     * <code>string metrics_schema_uri = 2;</code>
     *
     * @return The bytes for metricsSchemaUri.
     */
    public com.google.protobuf.ByteString getMetricsSchemaUriBytes() {
      java.lang.Object ref = metricsSchemaUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        metricsSchemaUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Points to a YAML file stored on Google Cloud Storage describing the
     * [metrics][google.cloud.aiplatform.v1beta1.ModelEvaluation.metrics] of this
     * ModelEvaluation. The schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * </pre>
     *
     * <code>string metrics_schema_uri = 2;</code>
     *
     * @param value The metricsSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setMetricsSchemaUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      metricsSchemaUri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Points to a YAML file stored on Google Cloud Storage describing the
     * [metrics][google.cloud.aiplatform.v1beta1.ModelEvaluation.metrics] of this
     * ModelEvaluation. The schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * </pre>
     *
     * <code>string metrics_schema_uri = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMetricsSchemaUri() {
      metricsSchemaUri_ = getDefaultInstance().getMetricsSchemaUri();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Points to a YAML file stored on Google Cloud Storage describing the
     * [metrics][google.cloud.aiplatform.v1beta1.ModelEvaluation.metrics] of this
     * ModelEvaluation. The schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * </pre>
     *
     * <code>string metrics_schema_uri = 2;</code>
     *
     * @param value The bytes for metricsSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setMetricsSchemaUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      metricsSchemaUri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Value metrics_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        metricsBuilder_;
    /**
     *
     *
     * <pre>
     * Evaluation metrics of the Model. The schema of the metrics is stored in
     * [metrics_schema_uri][google.cloud.aiplatform.v1beta1.ModelEvaluation.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 3;</code>
     *
     * @return Whether the metrics field is set.
     */
    public boolean hasMetrics() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Evaluation metrics of the Model. The schema of the metrics is stored in
     * [metrics_schema_uri][google.cloud.aiplatform.v1beta1.ModelEvaluation.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 3;</code>
     *
     * @return The metrics.
     */
    public com.google.protobuf.Value getMetrics() {
      if (metricsBuilder_ == null) {
        return metrics_ == null ? com.google.protobuf.Value.getDefaultInstance() : metrics_;
      } else {
        return metricsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Evaluation metrics of the Model. The schema of the metrics is stored in
     * [metrics_schema_uri][google.cloud.aiplatform.v1beta1.ModelEvaluation.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 3;</code>
     */
    public Builder setMetrics(com.google.protobuf.Value value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metrics_ = value;
      } else {
        metricsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Evaluation metrics of the Model. The schema of the metrics is stored in
     * [metrics_schema_uri][google.cloud.aiplatform.v1beta1.ModelEvaluation.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 3;</code>
     */
    public Builder setMetrics(com.google.protobuf.Value.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        metrics_ = builderForValue.build();
      } else {
        metricsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Evaluation metrics of the Model. The schema of the metrics is stored in
     * [metrics_schema_uri][google.cloud.aiplatform.v1beta1.ModelEvaluation.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 3;</code>
     */
    public Builder mergeMetrics(com.google.protobuf.Value value) {
      if (metricsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && metrics_ != null
            && metrics_ != com.google.protobuf.Value.getDefaultInstance()) {
          getMetricsBuilder().mergeFrom(value);
        } else {
          metrics_ = value;
        }
      } else {
        metricsBuilder_.mergeFrom(value);
      }
      if (metrics_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Evaluation metrics of the Model. The schema of the metrics is stored in
     * [metrics_schema_uri][google.cloud.aiplatform.v1beta1.ModelEvaluation.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 3;</code>
     */
    public Builder clearMetrics() {
      bitField0_ = (bitField0_ & ~0x00000008);
      metrics_ = null;
      if (metricsBuilder_ != null) {
        metricsBuilder_.dispose();
        metricsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Evaluation metrics of the Model. The schema of the metrics is stored in
     * [metrics_schema_uri][google.cloud.aiplatform.v1beta1.ModelEvaluation.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 3;</code>
     */
    public com.google.protobuf.Value.Builder getMetricsBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getMetricsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Evaluation metrics of the Model. The schema of the metrics is stored in
     * [metrics_schema_uri][google.cloud.aiplatform.v1beta1.ModelEvaluation.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 3;</code>
     */
    public com.google.protobuf.ValueOrBuilder getMetricsOrBuilder() {
      if (metricsBuilder_ != null) {
        return metricsBuilder_.getMessageOrBuilder();
      } else {
        return metrics_ == null ? com.google.protobuf.Value.getDefaultInstance() : metrics_;
      }
    }
    /**
     *
     *
     * <pre>
     * Evaluation metrics of the Model. The schema of the metrics is stored in
     * [metrics_schema_uri][google.cloud.aiplatform.v1beta1.ModelEvaluation.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getMetricsFieldBuilder() {
      if (metricsBuilder_ == null) {
        metricsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(
                getMetrics(), getParentForChildren(), isClean());
        metrics_ = null;
      }
      return metricsBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList sliceDimensions_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSliceDimensionsIsMutable() {
      if (!sliceDimensions_.isModifiable()) {
        sliceDimensions_ = new com.google.protobuf.LazyStringArrayList(sliceDimensions_);
      }
      bitField0_ |= 0x00000020;
    }
    /**
     *
     *
     * <pre>
     * All possible
     * [dimensions][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.dimension]
     * of ModelEvaluationSlices. The dimensions can be used as the filter of the
     * [ModelService.ListModelEvaluationSlices][google.cloud.aiplatform.v1beta1.ModelService.ListModelEvaluationSlices]
     * request, in the form of `slice.dimension = &lt;dimension&gt;`.
     * </pre>
     *
     * <code>repeated string slice_dimensions = 5;</code>
     *
     * @return A list containing the sliceDimensions.
     */
    public com.google.protobuf.ProtocolStringList getSliceDimensionsList() {
      sliceDimensions_.makeImmutable();
      return sliceDimensions_;
    }
    /**
     *
     *
     * <pre>
     * All possible
     * [dimensions][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.dimension]
     * of ModelEvaluationSlices. The dimensions can be used as the filter of the
     * [ModelService.ListModelEvaluationSlices][google.cloud.aiplatform.v1beta1.ModelService.ListModelEvaluationSlices]
     * request, in the form of `slice.dimension = &lt;dimension&gt;`.
     * </pre>
     *
     * <code>repeated string slice_dimensions = 5;</code>
     *
     * @return The count of sliceDimensions.
     */
    public int getSliceDimensionsCount() {
      return sliceDimensions_.size();
    }
    /**
     *
     *
     * <pre>
     * All possible
     * [dimensions][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.dimension]
     * of ModelEvaluationSlices. The dimensions can be used as the filter of the
     * [ModelService.ListModelEvaluationSlices][google.cloud.aiplatform.v1beta1.ModelService.ListModelEvaluationSlices]
     * request, in the form of `slice.dimension = &lt;dimension&gt;`.
     * </pre>
     *
     * <code>repeated string slice_dimensions = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The sliceDimensions at the given index.
     */
    public java.lang.String getSliceDimensions(int index) {
      return sliceDimensions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * All possible
     * [dimensions][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.dimension]
     * of ModelEvaluationSlices. The dimensions can be used as the filter of the
     * [ModelService.ListModelEvaluationSlices][google.cloud.aiplatform.v1beta1.ModelService.ListModelEvaluationSlices]
     * request, in the form of `slice.dimension = &lt;dimension&gt;`.
     * </pre>
     *
     * <code>repeated string slice_dimensions = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the sliceDimensions at the given index.
     */
    public com.google.protobuf.ByteString getSliceDimensionsBytes(int index) {
      return sliceDimensions_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * All possible
     * [dimensions][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.dimension]
     * of ModelEvaluationSlices. The dimensions can be used as the filter of the
     * [ModelService.ListModelEvaluationSlices][google.cloud.aiplatform.v1beta1.ModelService.ListModelEvaluationSlices]
     * request, in the form of `slice.dimension = &lt;dimension&gt;`.
     * </pre>
     *
     * <code>repeated string slice_dimensions = 5;</code>
     *
     * @param index The index to set the value at.
     * @param value The sliceDimensions to set.
     * @return This builder for chaining.
     */
    public Builder setSliceDimensions(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSliceDimensionsIsMutable();
      sliceDimensions_.set(index, value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * All possible
     * [dimensions][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.dimension]
     * of ModelEvaluationSlices. The dimensions can be used as the filter of the
     * [ModelService.ListModelEvaluationSlices][google.cloud.aiplatform.v1beta1.ModelService.ListModelEvaluationSlices]
     * request, in the form of `slice.dimension = &lt;dimension&gt;`.
     * </pre>
     *
     * <code>repeated string slice_dimensions = 5;</code>
     *
     * @param value The sliceDimensions to add.
     * @return This builder for chaining.
     */
    public Builder addSliceDimensions(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSliceDimensionsIsMutable();
      sliceDimensions_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * All possible
     * [dimensions][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.dimension]
     * of ModelEvaluationSlices. The dimensions can be used as the filter of the
     * [ModelService.ListModelEvaluationSlices][google.cloud.aiplatform.v1beta1.ModelService.ListModelEvaluationSlices]
     * request, in the form of `slice.dimension = &lt;dimension&gt;`.
     * </pre>
     *
     * <code>repeated string slice_dimensions = 5;</code>
     *
     * @param values The sliceDimensions to add.
     * @return This builder for chaining.
     */
    public Builder addAllSliceDimensions(java.lang.Iterable<java.lang.String> values) {
      ensureSliceDimensionsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sliceDimensions_);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * All possible
     * [dimensions][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.dimension]
     * of ModelEvaluationSlices. The dimensions can be used as the filter of the
     * [ModelService.ListModelEvaluationSlices][google.cloud.aiplatform.v1beta1.ModelService.ListModelEvaluationSlices]
     * request, in the form of `slice.dimension = &lt;dimension&gt;`.
     * </pre>
     *
     * <code>repeated string slice_dimensions = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSliceDimensions() {
      sliceDimensions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * All possible
     * [dimensions][google.cloud.aiplatform.v1beta1.ModelEvaluationSlice.Slice.dimension]
     * of ModelEvaluationSlices. The dimensions can be used as the filter of the
     * [ModelService.ListModelEvaluationSlices][google.cloud.aiplatform.v1beta1.ModelService.ListModelEvaluationSlices]
     * request, in the form of `slice.dimension = &lt;dimension&gt;`.
     * </pre>
     *
     * <code>repeated string slice_dimensions = 5;</code>
     *
     * @param value The bytes of the sliceDimensions to add.
     * @return This builder for chaining.
     */
    public Builder addSliceDimensionsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSliceDimensionsIsMutable();
      sliceDimensions_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.ModelExplanation modelExplanation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelExplanation,
            com.google.cloud.aiplatform.v1beta1.ModelExplanation.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelExplanationOrBuilder>
        modelExplanationBuilder_;
    /**
     *
     *
     * <pre>
     * Aggregated explanation metrics for the Model's prediction output over the
     * data this ModelEvaluation uses. This field is populated only if the Model
     * is evaluated with explanations, and only for AutoML tabular Models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelExplanation model_explanation = 8;</code>
     *
     * @return Whether the modelExplanation field is set.
     */
    public boolean hasModelExplanation() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Aggregated explanation metrics for the Model's prediction output over the
     * data this ModelEvaluation uses. This field is populated only if the Model
     * is evaluated with explanations, and only for AutoML tabular Models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelExplanation model_explanation = 8;</code>
     *
     * @return The modelExplanation.
     */
    public com.google.cloud.aiplatform.v1beta1.ModelExplanation getModelExplanation() {
      if (modelExplanationBuilder_ == null) {
        return modelExplanation_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelExplanation.getDefaultInstance()
            : modelExplanation_;
      } else {
        return modelExplanationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Aggregated explanation metrics for the Model's prediction output over the
     * data this ModelEvaluation uses. This field is populated only if the Model
     * is evaluated with explanations, and only for AutoML tabular Models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelExplanation model_explanation = 8;</code>
     */
    public Builder setModelExplanation(com.google.cloud.aiplatform.v1beta1.ModelExplanation value) {
      if (modelExplanationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelExplanation_ = value;
      } else {
        modelExplanationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Aggregated explanation metrics for the Model's prediction output over the
     * data this ModelEvaluation uses. This field is populated only if the Model
     * is evaluated with explanations, and only for AutoML tabular Models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelExplanation model_explanation = 8;</code>
     */
    public Builder setModelExplanation(
        com.google.cloud.aiplatform.v1beta1.ModelExplanation.Builder builderForValue) {
      if (modelExplanationBuilder_ == null) {
        modelExplanation_ = builderForValue.build();
      } else {
        modelExplanationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Aggregated explanation metrics for the Model's prediction output over the
     * data this ModelEvaluation uses. This field is populated only if the Model
     * is evaluated with explanations, and only for AutoML tabular Models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelExplanation model_explanation = 8;</code>
     */
    public Builder mergeModelExplanation(
        com.google.cloud.aiplatform.v1beta1.ModelExplanation value) {
      if (modelExplanationBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && modelExplanation_ != null
            && modelExplanation_
                != com.google.cloud.aiplatform.v1beta1.ModelExplanation.getDefaultInstance()) {
          getModelExplanationBuilder().mergeFrom(value);
        } else {
          modelExplanation_ = value;
        }
      } else {
        modelExplanationBuilder_.mergeFrom(value);
      }
      if (modelExplanation_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Aggregated explanation metrics for the Model's prediction output over the
     * data this ModelEvaluation uses. This field is populated only if the Model
     * is evaluated with explanations, and only for AutoML tabular Models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelExplanation model_explanation = 8;</code>
     */
    public Builder clearModelExplanation() {
      bitField0_ = (bitField0_ & ~0x00000040);
      modelExplanation_ = null;
      if (modelExplanationBuilder_ != null) {
        modelExplanationBuilder_.dispose();
        modelExplanationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Aggregated explanation metrics for the Model's prediction output over the
     * data this ModelEvaluation uses. This field is populated only if the Model
     * is evaluated with explanations, and only for AutoML tabular Models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelExplanation model_explanation = 8;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelExplanation.Builder
        getModelExplanationBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getModelExplanationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Aggregated explanation metrics for the Model's prediction output over the
     * data this ModelEvaluation uses. This field is populated only if the Model
     * is evaluated with explanations, and only for AutoML tabular Models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelExplanation model_explanation = 8;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelExplanationOrBuilder
        getModelExplanationOrBuilder() {
      if (modelExplanationBuilder_ != null) {
        return modelExplanationBuilder_.getMessageOrBuilder();
      } else {
        return modelExplanation_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelExplanation.getDefaultInstance()
            : modelExplanation_;
      }
    }
    /**
     *
     *
     * <pre>
     * Aggregated explanation metrics for the Model's prediction output over the
     * data this ModelEvaluation uses. This field is populated only if the Model
     * is evaluated with explanations, and only for AutoML tabular Models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelExplanation model_explanation = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelExplanation,
            com.google.cloud.aiplatform.v1beta1.ModelExplanation.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelExplanationOrBuilder>
        getModelExplanationFieldBuilder() {
      if (modelExplanationBuilder_ == null) {
        modelExplanationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelExplanation,
                com.google.cloud.aiplatform.v1beta1.ModelExplanation.Builder,
                com.google.cloud.aiplatform.v1beta1.ModelExplanationOrBuilder>(
                getModelExplanation(), getParentForChildren(), isClean());
        modelExplanation_ = null;
      }
      return modelExplanationBuilder_;
    }

    private java.util.List<
            com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec>
        explanationSpecs_ = java.util.Collections.emptyList();

    private void ensureExplanationSpecsIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        explanationSpecs_ =
            new java.util.ArrayList<
                com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec>(
                explanationSpecs_);
        bitField0_ |= 0x00000080;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec,
            com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
                .Builder,
            com.google.cloud.aiplatform.v1beta1.ModelEvaluation
                .ModelEvaluationExplanationSpecOrBuilder>
        explanationSpecsBuilder_;

    /**
     *
     *
     * <pre>
     * Describes the values of
     * [ExplanationSpec][google.cloud.aiplatform.v1beta1.ExplanationSpec] that are
     * used for explaining the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec>
        getExplanationSpecsList() {
      if (explanationSpecsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(explanationSpecs_);
      } else {
        return explanationSpecsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the values of
     * [ExplanationSpec][google.cloud.aiplatform.v1beta1.ExplanationSpec] that are
     * used for explaining the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public int getExplanationSpecsCount() {
      if (explanationSpecsBuilder_ == null) {
        return explanationSpecs_.size();
      } else {
        return explanationSpecsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the values of
     * [ExplanationSpec][google.cloud.aiplatform.v1beta1.ExplanationSpec] that are
     * used for explaining the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
        getExplanationSpecs(int index) {
      if (explanationSpecsBuilder_ == null) {
        return explanationSpecs_.get(index);
      } else {
        return explanationSpecsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the values of
     * [ExplanationSpec][google.cloud.aiplatform.v1beta1.ExplanationSpec] that are
     * used for explaining the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public Builder setExplanationSpecs(
        int index,
        com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec value) {
      if (explanationSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExplanationSpecsIsMutable();
        explanationSpecs_.set(index, value);
        onChanged();
      } else {
        explanationSpecsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the values of
     * [ExplanationSpec][google.cloud.aiplatform.v1beta1.ExplanationSpec] that are
     * used for explaining the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public Builder setExplanationSpecs(
        int index,
        com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec.Builder
            builderForValue) {
      if (explanationSpecsBuilder_ == null) {
        ensureExplanationSpecsIsMutable();
        explanationSpecs_.set(index, builderForValue.build());
        onChanged();
      } else {
        explanationSpecsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the values of
     * [ExplanationSpec][google.cloud.aiplatform.v1beta1.ExplanationSpec] that are
     * used for explaining the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public Builder addExplanationSpecs(
        com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec value) {
      if (explanationSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExplanationSpecsIsMutable();
        explanationSpecs_.add(value);
        onChanged();
      } else {
        explanationSpecsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the values of
     * [ExplanationSpec][google.cloud.aiplatform.v1beta1.ExplanationSpec] that are
     * used for explaining the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public Builder addExplanationSpecs(
        int index,
        com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec value) {
      if (explanationSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExplanationSpecsIsMutable();
        explanationSpecs_.add(index, value);
        onChanged();
      } else {
        explanationSpecsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the values of
     * [ExplanationSpec][google.cloud.aiplatform.v1beta1.ExplanationSpec] that are
     * used for explaining the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public Builder addExplanationSpecs(
        com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec.Builder
            builderForValue) {
      if (explanationSpecsBuilder_ == null) {
        ensureExplanationSpecsIsMutable();
        explanationSpecs_.add(builderForValue.build());
        onChanged();
      } else {
        explanationSpecsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the values of
     * [ExplanationSpec][google.cloud.aiplatform.v1beta1.ExplanationSpec] that are
     * used for explaining the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public Builder addExplanationSpecs(
        int index,
        com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec.Builder
            builderForValue) {
      if (explanationSpecsBuilder_ == null) {
        ensureExplanationSpecsIsMutable();
        explanationSpecs_.add(index, builderForValue.build());
        onChanged();
      } else {
        explanationSpecsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the values of
     * [ExplanationSpec][google.cloud.aiplatform.v1beta1.ExplanationSpec] that are
     * used for explaining the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public Builder addAllExplanationSpecs(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.aiplatform.v1beta1.ModelEvaluation
                        .ModelEvaluationExplanationSpec>
            values) {
      if (explanationSpecsBuilder_ == null) {
        ensureExplanationSpecsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, explanationSpecs_);
        onChanged();
      } else {
        explanationSpecsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the values of
     * [ExplanationSpec][google.cloud.aiplatform.v1beta1.ExplanationSpec] that are
     * used for explaining the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public Builder clearExplanationSpecs() {
      if (explanationSpecsBuilder_ == null) {
        explanationSpecs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        explanationSpecsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the values of
     * [ExplanationSpec][google.cloud.aiplatform.v1beta1.ExplanationSpec] that are
     * used for explaining the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public Builder removeExplanationSpecs(int index) {
      if (explanationSpecsBuilder_ == null) {
        ensureExplanationSpecsIsMutable();
        explanationSpecs_.remove(index);
        onChanged();
      } else {
        explanationSpecsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the values of
     * [ExplanationSpec][google.cloud.aiplatform.v1beta1.ExplanationSpec] that are
     * used for explaining the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
            .Builder
        getExplanationSpecsBuilder(int index) {
      return getExplanationSpecsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Describes the values of
     * [ExplanationSpec][google.cloud.aiplatform.v1beta1.ExplanationSpec] that are
     * used for explaining the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelEvaluation
            .ModelEvaluationExplanationSpecOrBuilder
        getExplanationSpecsOrBuilder(int index) {
      if (explanationSpecsBuilder_ == null) {
        return explanationSpecs_.get(index);
      } else {
        return explanationSpecsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the values of
     * [ExplanationSpec][google.cloud.aiplatform.v1beta1.ExplanationSpec] that are
     * used for explaining the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1beta1.ModelEvaluation
                    .ModelEvaluationExplanationSpecOrBuilder>
        getExplanationSpecsOrBuilderList() {
      if (explanationSpecsBuilder_ != null) {
        return explanationSpecsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(explanationSpecs_);
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the values of
     * [ExplanationSpec][google.cloud.aiplatform.v1beta1.ExplanationSpec] that are
     * used for explaining the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
            .Builder
        addExplanationSpecsBuilder() {
      return getExplanationSpecsFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Describes the values of
     * [ExplanationSpec][google.cloud.aiplatform.v1beta1.ExplanationSpec] that are
     * used for explaining the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
            .Builder
        addExplanationSpecsBuilder(int index) {
      return getExplanationSpecsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Describes the values of
     * [ExplanationSpec][google.cloud.aiplatform.v1beta1.ExplanationSpec] that are
     * used for explaining the predicted values on the evaluated data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec explanation_specs = 9;
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
                .Builder>
        getExplanationSpecsBuilderList() {
      return getExplanationSpecsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec,
            com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
                .Builder,
            com.google.cloud.aiplatform.v1beta1.ModelEvaluation
                .ModelEvaluationExplanationSpecOrBuilder>
        getExplanationSpecsFieldBuilder() {
      if (explanationSpecsBuilder_ == null) {
        explanationSpecsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec,
                com.google.cloud.aiplatform.v1beta1.ModelEvaluation.ModelEvaluationExplanationSpec
                    .Builder,
                com.google.cloud.aiplatform.v1beta1.ModelEvaluation
                    .ModelEvaluationExplanationSpecOrBuilder>(
                explanationSpecs_,
                ((bitField0_ & 0x00000080) != 0),
                getParentForChildren(),
                isClean());
        explanationSpecs_ = null;
      }
      return explanationSpecsBuilder_;
    }

    private com.google.protobuf.Value metadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        metadataBuilder_;
    /**
     *
     *
     * <pre>
     * The metadata of the ModelEvaluation.
     * For the ModelEvaluation uploaded from Managed Pipeline, metadata contains a
     * structured value with keys of "pipeline_job_id", "evaluation_dataset_type",
     * "evaluation_dataset_path", "row_based_metrics_path".
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 11;</code>
     *
     * @return Whether the metadata field is set.
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * The metadata of the ModelEvaluation.
     * For the ModelEvaluation uploaded from Managed Pipeline, metadata contains a
     * structured value with keys of "pipeline_job_id", "evaluation_dataset_type",
     * "evaluation_dataset_path", "row_based_metrics_path".
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 11;</code>
     *
     * @return The metadata.
     */
    public com.google.protobuf.Value getMetadata() {
      if (metadataBuilder_ == null) {
        return metadata_ == null ? com.google.protobuf.Value.getDefaultInstance() : metadata_;
      } else {
        return metadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The metadata of the ModelEvaluation.
     * For the ModelEvaluation uploaded from Managed Pipeline, metadata contains a
     * structured value with keys of "pipeline_job_id", "evaluation_dataset_type",
     * "evaluation_dataset_path", "row_based_metrics_path".
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 11;</code>
     */
    public Builder setMetadata(com.google.protobuf.Value value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
      } else {
        metadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metadata of the ModelEvaluation.
     * For the ModelEvaluation uploaded from Managed Pipeline, metadata contains a
     * structured value with keys of "pipeline_job_id", "evaluation_dataset_type",
     * "evaluation_dataset_path", "row_based_metrics_path".
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 11;</code>
     */
    public Builder setMetadata(com.google.protobuf.Value.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        metadata_ = builderForValue.build();
      } else {
        metadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metadata of the ModelEvaluation.
     * For the ModelEvaluation uploaded from Managed Pipeline, metadata contains a
     * structured value with keys of "pipeline_job_id", "evaluation_dataset_type",
     * "evaluation_dataset_path", "row_based_metrics_path".
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 11;</code>
     */
    public Builder mergeMetadata(com.google.protobuf.Value value) {
      if (metadataBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && metadata_ != null
            && metadata_ != com.google.protobuf.Value.getDefaultInstance()) {
          getMetadataBuilder().mergeFrom(value);
        } else {
          metadata_ = value;
        }
      } else {
        metadataBuilder_.mergeFrom(value);
      }
      if (metadata_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metadata of the ModelEvaluation.
     * For the ModelEvaluation uploaded from Managed Pipeline, metadata contains a
     * structured value with keys of "pipeline_job_id", "evaluation_dataset_type",
     * "evaluation_dataset_path", "row_based_metrics_path".
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 11;</code>
     */
    public Builder clearMetadata() {
      bitField0_ = (bitField0_ & ~0x00000100);
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metadata of the ModelEvaluation.
     * For the ModelEvaluation uploaded from Managed Pipeline, metadata contains a
     * structured value with keys of "pipeline_job_id", "evaluation_dataset_type",
     * "evaluation_dataset_path", "row_based_metrics_path".
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 11;</code>
     */
    public com.google.protobuf.Value.Builder getMetadataBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The metadata of the ModelEvaluation.
     * For the ModelEvaluation uploaded from Managed Pipeline, metadata contains a
     * structured value with keys of "pipeline_job_id", "evaluation_dataset_type",
     * "evaluation_dataset_path", "row_based_metrics_path".
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 11;</code>
     */
    public com.google.protobuf.ValueOrBuilder getMetadataOrBuilder() {
      if (metadataBuilder_ != null) {
        return metadataBuilder_.getMessageOrBuilder();
      } else {
        return metadata_ == null ? com.google.protobuf.Value.getDefaultInstance() : metadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * The metadata of the ModelEvaluation.
     * For the ModelEvaluation uploaded from Managed Pipeline, metadata contains a
     * structured value with keys of "pipeline_job_id", "evaluation_dataset_type",
     * "evaluation_dataset_path", "row_based_metrics_path".
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getMetadataFieldBuilder() {
      if (metadataBuilder_ == null) {
        metadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(
                getMetadata(), getParentForChildren(), isClean());
        metadata_ = null;
      }
      return metadataBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig biasConfigs_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig,
            com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfigOrBuilder>
        biasConfigsBuilder_;
    /**
     *
     *
     * <pre>
     * Specify the configuration for bias detection.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig bias_configs = 12;</code>
     *
     * @return Whether the biasConfigs field is set.
     */
    public boolean hasBiasConfigs() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specify the configuration for bias detection.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig bias_configs = 12;</code>
     *
     * @return The biasConfigs.
     */
    public com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig getBiasConfigs() {
      if (biasConfigsBuilder_ == null) {
        return biasConfigs_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig.getDefaultInstance()
            : biasConfigs_;
      } else {
        return biasConfigsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specify the configuration for bias detection.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig bias_configs = 12;</code>
     */
    public Builder setBiasConfigs(
        com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig value) {
      if (biasConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        biasConfigs_ = value;
      } else {
        biasConfigsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specify the configuration for bias detection.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig bias_configs = 12;</code>
     */
    public Builder setBiasConfigs(
        com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig.Builder builderForValue) {
      if (biasConfigsBuilder_ == null) {
        biasConfigs_ = builderForValue.build();
      } else {
        biasConfigsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specify the configuration for bias detection.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig bias_configs = 12;</code>
     */
    public Builder mergeBiasConfigs(
        com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig value) {
      if (biasConfigsBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && biasConfigs_ != null
            && biasConfigs_
                != com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig
                    .getDefaultInstance()) {
          getBiasConfigsBuilder().mergeFrom(value);
        } else {
          biasConfigs_ = value;
        }
      } else {
        biasConfigsBuilder_.mergeFrom(value);
      }
      if (biasConfigs_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specify the configuration for bias detection.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig bias_configs = 12;</code>
     */
    public Builder clearBiasConfigs() {
      bitField0_ = (bitField0_ & ~0x00000200);
      biasConfigs_ = null;
      if (biasConfigsBuilder_ != null) {
        biasConfigsBuilder_.dispose();
        biasConfigsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specify the configuration for bias detection.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig bias_configs = 12;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig.Builder
        getBiasConfigsBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getBiasConfigsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specify the configuration for bias detection.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig bias_configs = 12;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfigOrBuilder
        getBiasConfigsOrBuilder() {
      if (biasConfigsBuilder_ != null) {
        return biasConfigsBuilder_.getMessageOrBuilder();
      } else {
        return biasConfigs_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig.getDefaultInstance()
            : biasConfigs_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specify the configuration for bias detection.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig bias_configs = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig,
            com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfigOrBuilder>
        getBiasConfigsFieldBuilder() {
      if (biasConfigsBuilder_ == null) {
        biasConfigsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig,
                com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.ModelEvaluation.BiasConfigOrBuilder>(
                getBiasConfigs(), getParentForChildren(), isClean());
        biasConfigs_ = null;
      }
      return biasConfigsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelEvaluation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelEvaluation)
  private static final com.google.cloud.aiplatform.v1beta1.ModelEvaluation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ModelEvaluation();
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelEvaluation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ModelEvaluation> PARSER =
      new com.google.protobuf.AbstractParser<ModelEvaluation>() {
        @java.lang.Override
        public ModelEvaluation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ModelEvaluation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ModelEvaluation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelEvaluation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
