/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/index.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * A representation of a collection of database items organized in a way that
 * allows for approximate nearest neighbor (a.k.a ANN) algorithms search.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.Index}
 */
public final class Index extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.Index)
    IndexOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Index.newBuilder() to construct.
  private Index(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Index() {
    name_ = "";
    displayName_ = "";
    description_ = "";
    metadataSchemaUri_ = "";
    deployedIndexes_ = java.util.Collections.emptyList();
    etag_ = "";
    indexUpdateMethod_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Index();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.IndexProto
        .internal_static_google_cloud_aiplatform_v1_Index_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 9:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.IndexProto
        .internal_static_google_cloud_aiplatform_v1_Index_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.Index.class,
            com.google.cloud.aiplatform.v1.Index.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The update method of an Index.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1.Index.IndexUpdateMethod}
   */
  public enum IndexUpdateMethod implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Should not be used.
     * </pre>
     *
     * <code>INDEX_UPDATE_METHOD_UNSPECIFIED = 0;</code>
     */
    INDEX_UPDATE_METHOD_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * BatchUpdate: user can call UpdateIndex with files on Cloud Storage of
     * Datapoints to update.
     * </pre>
     *
     * <code>BATCH_UPDATE = 1;</code>
     */
    BATCH_UPDATE(1),
    /**
     *
     *
     * <pre>
     * StreamUpdate: user can call UpsertDatapoints/DeleteDatapoints to update
     * the Index and the updates will be applied in corresponding
     * DeployedIndexes in nearly real-time.
     * </pre>
     *
     * <code>STREAM_UPDATE = 2;</code>
     */
    STREAM_UPDATE(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Should not be used.
     * </pre>
     *
     * <code>INDEX_UPDATE_METHOD_UNSPECIFIED = 0;</code>
     */
    public static final int INDEX_UPDATE_METHOD_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * BatchUpdate: user can call UpdateIndex with files on Cloud Storage of
     * Datapoints to update.
     * </pre>
     *
     * <code>BATCH_UPDATE = 1;</code>
     */
    public static final int BATCH_UPDATE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * StreamUpdate: user can call UpsertDatapoints/DeleteDatapoints to update
     * the Index and the updates will be applied in corresponding
     * DeployedIndexes in nearly real-time.
     * </pre>
     *
     * <code>STREAM_UPDATE = 2;</code>
     */
    public static final int STREAM_UPDATE_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static IndexUpdateMethod valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static IndexUpdateMethod forNumber(int value) {
      switch (value) {
        case 0:
          return INDEX_UPDATE_METHOD_UNSPECIFIED;
        case 1:
          return BATCH_UPDATE;
        case 2:
          return STREAM_UPDATE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<IndexUpdateMethod>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<IndexUpdateMethod>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<IndexUpdateMethod>() {
              public IndexUpdateMethod findValueByNumber(int number) {
                return IndexUpdateMethod.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.Index.getDescriptor().getEnumTypes().get(0);
    }

    private static final IndexUpdateMethod[] VALUES = values();

    public static IndexUpdateMethod valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private IndexUpdateMethod(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1.Index.IndexUpdateMethod)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the Index.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the Index.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The display name of the Index.
   * The name can be up to 128 characters long and can consist of any UTF-8
   * characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The display name of the Index.
   * The name can be up to 128 characters long and can consist of any UTF-8
   * characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * The description of the Index.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The description of the Index.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METADATA_SCHEMA_URI_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object metadataSchemaUri_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. Points to a YAML file stored on Google Cloud Storage describing
   * additional information about the Index, that is specific to it. Unset if
   * the Index does not have any additional information. The schema is defined
   * as an OpenAPI 3.0.2 [Schema
   * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
   * Note: The URI given on output will be immutable and probably different,
   * including the URI scheme, than the one given on input. The output URI will
   * point to a location where the user only has a read access.
   * </pre>
   *
   * <code>string metadata_schema_uri = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The metadataSchemaUri.
   */
  @java.lang.Override
  public java.lang.String getMetadataSchemaUri() {
    java.lang.Object ref = metadataSchemaUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      metadataSchemaUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. Points to a YAML file stored on Google Cloud Storage describing
   * additional information about the Index, that is specific to it. Unset if
   * the Index does not have any additional information. The schema is defined
   * as an OpenAPI 3.0.2 [Schema
   * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
   * Note: The URI given on output will be immutable and probably different,
   * including the URI scheme, than the one given on input. The output URI will
   * point to a location where the user only has a read access.
   * </pre>
   *
   * <code>string metadata_schema_uri = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for metadataSchemaUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMetadataSchemaUriBytes() {
    java.lang.Object ref = metadataSchemaUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      metadataSchemaUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METADATA_FIELD_NUMBER = 6;
  private com.google.protobuf.Value metadata_;
  /**
   *
   *
   * <pre>
   * An additional information about the Index; the schema of the metadata can
   * be found in
   * [metadata_schema][google.cloud.aiplatform.v1.Index.metadata_schema_uri].
   * </pre>
   *
   * <code>.google.protobuf.Value metadata = 6;</code>
   *
   * @return Whether the metadata field is set.
   */
  @java.lang.Override
  public boolean hasMetadata() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * An additional information about the Index; the schema of the metadata can
   * be found in
   * [metadata_schema][google.cloud.aiplatform.v1.Index.metadata_schema_uri].
   * </pre>
   *
   * <code>.google.protobuf.Value metadata = 6;</code>
   *
   * @return The metadata.
   */
  @java.lang.Override
  public com.google.protobuf.Value getMetadata() {
    return metadata_ == null ? com.google.protobuf.Value.getDefaultInstance() : metadata_;
  }
  /**
   *
   *
   * <pre>
   * An additional information about the Index; the schema of the metadata can
   * be found in
   * [metadata_schema][google.cloud.aiplatform.v1.Index.metadata_schema_uri].
   * </pre>
   *
   * <code>.google.protobuf.Value metadata = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.ValueOrBuilder getMetadataOrBuilder() {
    return metadata_ == null ? com.google.protobuf.Value.getDefaultInstance() : metadata_;
  }

  public static final int DEPLOYED_INDEXES_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1.DeployedIndexRef> deployedIndexes_;
  /**
   *
   *
   * <pre>
   * Output only. The pointers to DeployedIndexes created from this Index.
   * An Index can be only deleted if all its DeployedIndexes had been undeployed
   * first.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.DeployedIndexRef deployed_indexes = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.DeployedIndexRef> getDeployedIndexesList() {
    return deployedIndexes_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The pointers to DeployedIndexes created from this Index.
   * An Index can be only deleted if all its DeployedIndexes had been undeployed
   * first.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.DeployedIndexRef deployed_indexes = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1.DeployedIndexRefOrBuilder>
      getDeployedIndexesOrBuilderList() {
    return deployedIndexes_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The pointers to DeployedIndexes created from this Index.
   * An Index can be only deleted if all its DeployedIndexes had been undeployed
   * first.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.DeployedIndexRef deployed_indexes = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getDeployedIndexesCount() {
    return deployedIndexes_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The pointers to DeployedIndexes created from this Index.
   * An Index can be only deleted if all its DeployedIndexes had been undeployed
   * first.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.DeployedIndexRef deployed_indexes = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DeployedIndexRef getDeployedIndexes(int index) {
    return deployedIndexes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The pointers to DeployedIndexes created from this Index.
   * An Index can be only deleted if all its DeployedIndexes had been undeployed
   * first.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.DeployedIndexRef deployed_indexes = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DeployedIndexRefOrBuilder getDeployedIndexesOrBuilder(
      int index) {
    return deployedIndexes_.get(index);
  }

  public static final int ETAG_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * Used to perform consistent read-modify-write updates. If not set, a blind
   * "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 8;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Used to perform consistent read-modify-write updates. If not set, a blind
   * "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 8;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 9;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.aiplatform.v1.IndexProto
                .internal_static_google_cloud_aiplatform_v1_Index_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your Indexes.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your Indexes.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your Indexes.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your Indexes.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Index was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Index was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Index was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 11;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Index was most recently updated.
   * This also includes any update to the contents of the Index.
   * Note that Operations working on this Index may have their
   * [Operations.metadata.generic_metadata.update_time]
   * [google.cloud.aiplatform.v1.GenericOperationMetadata.update_time] a little
   * after the value of this timestamp, yet that does not mean their results are
   * not already reflected in the Index. Result of any successfully completed
   * Operation on the Index is reflected in it.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Index was most recently updated.
   * This also includes any update to the contents of the Index.
   * Note that Operations working on this Index may have their
   * [Operations.metadata.generic_metadata.update_time]
   * [google.cloud.aiplatform.v1.GenericOperationMetadata.update_time] a little
   * after the value of this timestamp, yet that does not mean their results are
   * not already reflected in the Index. Result of any successfully completed
   * Operation on the Index is reflected in it.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Index was most recently updated.
   * This also includes any update to the contents of the Index.
   * Note that Operations working on this Index may have their
   * [Operations.metadata.generic_metadata.update_time]
   * [google.cloud.aiplatform.v1.GenericOperationMetadata.update_time] a little
   * after the value of this timestamp, yet that does not mean their results are
   * not already reflected in the Index. Result of any successfully completed
   * Operation on the Index is reflected in it.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int INDEX_STATS_FIELD_NUMBER = 14;
  private com.google.cloud.aiplatform.v1.IndexStats indexStats_;
  /**
   *
   *
   * <pre>
   * Output only. Stats of the index resource.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.IndexStats index_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the indexStats field is set.
   */
  @java.lang.Override
  public boolean hasIndexStats() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Stats of the index resource.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.IndexStats index_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The indexStats.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.IndexStats getIndexStats() {
    return indexStats_ == null
        ? com.google.cloud.aiplatform.v1.IndexStats.getDefaultInstance()
        : indexStats_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Stats of the index resource.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.IndexStats index_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.IndexStatsOrBuilder getIndexStatsOrBuilder() {
    return indexStats_ == null
        ? com.google.cloud.aiplatform.v1.IndexStats.getDefaultInstance()
        : indexStats_;
  }

  public static final int INDEX_UPDATE_METHOD_FIELD_NUMBER = 16;
  private int indexUpdateMethod_ = 0;
  /**
   *
   *
   * <pre>
   * Immutable. The update method to use with this Index. If not set,
   * BATCH_UPDATE will be used by default.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Index.IndexUpdateMethod index_update_method = 16 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The enum numeric value on the wire for indexUpdateMethod.
   */
  @java.lang.Override
  public int getIndexUpdateMethodValue() {
    return indexUpdateMethod_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. The update method to use with this Index. If not set,
   * BATCH_UPDATE will be used by default.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Index.IndexUpdateMethod index_update_method = 16 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The indexUpdateMethod.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Index.IndexUpdateMethod getIndexUpdateMethod() {
    com.google.cloud.aiplatform.v1.Index.IndexUpdateMethod result =
        com.google.cloud.aiplatform.v1.Index.IndexUpdateMethod.forNumber(indexUpdateMethod_);
    return result == null
        ? com.google.cloud.aiplatform.v1.Index.IndexUpdateMethod.UNRECOGNIZED
        : result;
  }

  public static final int ENCRYPTION_SPEC_FIELD_NUMBER = 17;
  private com.google.cloud.aiplatform.v1.EncryptionSpec encryptionSpec_;
  /**
   *
   *
   * <pre>
   * Immutable. Customer-managed encryption key spec for an Index. If set, this
   * Index and all sub-resources of this Index will be secured by this key.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 17 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return Whether the encryptionSpec field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionSpec() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Immutable. Customer-managed encryption key spec for an Index. If set, this
   * Index and all sub-resources of this Index will be secured by this key.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 17 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The encryptionSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.EncryptionSpec getEncryptionSpec() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. Customer-managed encryption key spec for an Index. If set, this
   * Index and all sub-resources of this Index will be secured by this key.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 17 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder getEncryptionSpecOrBuilder() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metadataSchemaUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, metadataSchemaUri_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getMetadata());
    }
    for (int i = 0; i < deployedIndexes_.size(); i++) {
      output.writeMessage(7, deployedIndexes_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, etag_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 9);
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(10, getCreateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(11, getUpdateTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(14, getIndexStats());
    }
    if (indexUpdateMethod_
        != com.google.cloud.aiplatform.v1.Index.IndexUpdateMethod.INDEX_UPDATE_METHOD_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(16, indexUpdateMethod_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(17, getEncryptionSpec());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metadataSchemaUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, metadataSchemaUri_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getMetadata());
    }
    for (int i = 0; i < deployedIndexes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, deployedIndexes_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, etag_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, labels__);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getCreateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getUpdateTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getIndexStats());
    }
    if (indexUpdateMethod_
        != com.google.cloud.aiplatform.v1.Index.IndexUpdateMethod.INDEX_UPDATE_METHOD_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(16, indexUpdateMethod_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, getEncryptionSpec());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.Index)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.Index other = (com.google.cloud.aiplatform.v1.Index) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getMetadataSchemaUri().equals(other.getMetadataSchemaUri())) return false;
    if (hasMetadata() != other.hasMetadata()) return false;
    if (hasMetadata()) {
      if (!getMetadata().equals(other.getMetadata())) return false;
    }
    if (!getDeployedIndexesList().equals(other.getDeployedIndexesList())) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasIndexStats() != other.hasIndexStats()) return false;
    if (hasIndexStats()) {
      if (!getIndexStats().equals(other.getIndexStats())) return false;
    }
    if (indexUpdateMethod_ != other.indexUpdateMethod_) return false;
    if (hasEncryptionSpec() != other.hasEncryptionSpec()) return false;
    if (hasEncryptionSpec()) {
      if (!getEncryptionSpec().equals(other.getEncryptionSpec())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + METADATA_SCHEMA_URI_FIELD_NUMBER;
    hash = (53 * hash) + getMetadataSchemaUri().hashCode();
    if (hasMetadata()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getMetadata().hashCode();
    }
    if (getDeployedIndexesCount() > 0) {
      hash = (37 * hash) + DEPLOYED_INDEXES_FIELD_NUMBER;
      hash = (53 * hash) + getDeployedIndexesList().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasIndexStats()) {
      hash = (37 * hash) + INDEX_STATS_FIELD_NUMBER;
      hash = (53 * hash) + getIndexStats().hashCode();
    }
    hash = (37 * hash) + INDEX_UPDATE_METHOD_FIELD_NUMBER;
    hash = (53 * hash) + indexUpdateMethod_;
    if (hasEncryptionSpec()) {
      hash = (37 * hash) + ENCRYPTION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionSpec().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.Index parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Index parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Index parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Index parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Index parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Index parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Index parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Index parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Index parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Index parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Index parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Index parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.Index prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A representation of a collection of database items organized in a way that
   * allows for approximate nearest neighbor (a.k.a ANN) algorithms search.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.Index}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.Index)
      com.google.cloud.aiplatform.v1.IndexOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.IndexProto
          .internal_static_google_cloud_aiplatform_v1_Index_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 9:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 9:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.IndexProto
          .internal_static_google_cloud_aiplatform_v1_Index_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.Index.class,
              com.google.cloud.aiplatform.v1.Index.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.Index.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getMetadataFieldBuilder();
        getDeployedIndexesFieldBuilder();
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getIndexStatsFieldBuilder();
        getEncryptionSpecFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      description_ = "";
      metadataSchemaUri_ = "";
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      if (deployedIndexesBuilder_ == null) {
        deployedIndexes_ = java.util.Collections.emptyList();
      } else {
        deployedIndexes_ = null;
        deployedIndexesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      etag_ = "";
      internalGetMutableLabels().clear();
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      indexStats_ = null;
      if (indexStatsBuilder_ != null) {
        indexStatsBuilder_.dispose();
        indexStatsBuilder_ = null;
      }
      indexUpdateMethod_ = 0;
      encryptionSpec_ = null;
      if (encryptionSpecBuilder_ != null) {
        encryptionSpecBuilder_.dispose();
        encryptionSpecBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.IndexProto
          .internal_static_google_cloud_aiplatform_v1_Index_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Index getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.Index.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Index build() {
      com.google.cloud.aiplatform.v1.Index result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Index buildPartial() {
      com.google.cloud.aiplatform.v1.Index result = new com.google.cloud.aiplatform.v1.Index(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.aiplatform.v1.Index result) {
      if (deployedIndexesBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          deployedIndexes_ = java.util.Collections.unmodifiableList(deployedIndexes_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.deployedIndexes_ = deployedIndexes_;
      } else {
        result.deployedIndexes_ = deployedIndexesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.Index result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.metadataSchemaUri_ = metadataSchemaUri_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.metadata_ = metadataBuilder_ == null ? metadata_ : metadataBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.indexStats_ = indexStatsBuilder_ == null ? indexStats_ : indexStatsBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.indexUpdateMethod_ = indexUpdateMethod_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.encryptionSpec_ =
            encryptionSpecBuilder_ == null ? encryptionSpec_ : encryptionSpecBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.Index) {
        return mergeFrom((com.google.cloud.aiplatform.v1.Index) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.Index other) {
      if (other == com.google.cloud.aiplatform.v1.Index.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getMetadataSchemaUri().isEmpty()) {
        metadataSchemaUri_ = other.metadataSchemaUri_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasMetadata()) {
        mergeMetadata(other.getMetadata());
      }
      if (deployedIndexesBuilder_ == null) {
        if (!other.deployedIndexes_.isEmpty()) {
          if (deployedIndexes_.isEmpty()) {
            deployedIndexes_ = other.deployedIndexes_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureDeployedIndexesIsMutable();
            deployedIndexes_.addAll(other.deployedIndexes_);
          }
          onChanged();
        }
      } else {
        if (!other.deployedIndexes_.isEmpty()) {
          if (deployedIndexesBuilder_.isEmpty()) {
            deployedIndexesBuilder_.dispose();
            deployedIndexesBuilder_ = null;
            deployedIndexes_ = other.deployedIndexes_;
            bitField0_ = (bitField0_ & ~0x00000020);
            deployedIndexesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDeployedIndexesFieldBuilder()
                    : null;
          } else {
            deployedIndexesBuilder_.addAllMessages(other.deployedIndexes_);
          }
        }
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000080;
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasIndexStats()) {
        mergeIndexStats(other.getIndexStats());
      }
      if (other.indexUpdateMethod_ != 0) {
        setIndexUpdateMethodValue(other.getIndexUpdateMethodValue());
      }
      if (other.hasEncryptionSpec()) {
        mergeEncryptionSpec(other.getEncryptionSpec());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                metadataSchemaUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 50:
              {
                input.readMessage(getMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            case 58:
              {
                com.google.cloud.aiplatform.v1.DeployedIndexRef m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1.DeployedIndexRef.parser(),
                        extensionRegistry);
                if (deployedIndexesBuilder_ == null) {
                  ensureDeployedIndexesIsMutable();
                  deployedIndexes_.add(m);
                } else {
                  deployedIndexesBuilder_.addMessage(m);
                }
                break;
              } // case 58
            case 66:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            case 74:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000080;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 90
            case 114:
              {
                input.readMessage(getIndexStatsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 114
            case 128:
              {
                indexUpdateMethod_ = input.readEnum();
                bitField0_ |= 0x00000800;
                break;
              } // case 128
            case 138:
              {
                input.readMessage(getEncryptionSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 138
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Index.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Index.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Index.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Index.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Index.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The display name of the Index.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the Index.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the Index.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the Index.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the Index.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * The description of the Index.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of the Index.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of the Index.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of the Index.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of the Index.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object metadataSchemaUri_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. Points to a YAML file stored on Google Cloud Storage describing
     * additional information about the Index, that is specific to it. Unset if
     * the Index does not have any additional information. The schema is defined
     * as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * Note: The URI given on output will be immutable and probably different,
     * including the URI scheme, than the one given on input. The output URI will
     * point to a location where the user only has a read access.
     * </pre>
     *
     * <code>string metadata_schema_uri = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The metadataSchemaUri.
     */
    public java.lang.String getMetadataSchemaUri() {
      java.lang.Object ref = metadataSchemaUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        metadataSchemaUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Points to a YAML file stored on Google Cloud Storage describing
     * additional information about the Index, that is specific to it. Unset if
     * the Index does not have any additional information. The schema is defined
     * as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * Note: The URI given on output will be immutable and probably different,
     * including the URI scheme, than the one given on input. The output URI will
     * point to a location where the user only has a read access.
     * </pre>
     *
     * <code>string metadata_schema_uri = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for metadataSchemaUri.
     */
    public com.google.protobuf.ByteString getMetadataSchemaUriBytes() {
      java.lang.Object ref = metadataSchemaUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        metadataSchemaUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Points to a YAML file stored on Google Cloud Storage describing
     * additional information about the Index, that is specific to it. Unset if
     * the Index does not have any additional information. The schema is defined
     * as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * Note: The URI given on output will be immutable and probably different,
     * including the URI scheme, than the one given on input. The output URI will
     * point to a location where the user only has a read access.
     * </pre>
     *
     * <code>string metadata_schema_uri = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The metadataSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setMetadataSchemaUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      metadataSchemaUri_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Points to a YAML file stored on Google Cloud Storage describing
     * additional information about the Index, that is specific to it. Unset if
     * the Index does not have any additional information. The schema is defined
     * as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * Note: The URI given on output will be immutable and probably different,
     * including the URI scheme, than the one given on input. The output URI will
     * point to a location where the user only has a read access.
     * </pre>
     *
     * <code>string metadata_schema_uri = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMetadataSchemaUri() {
      metadataSchemaUri_ = getDefaultInstance().getMetadataSchemaUri();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Points to a YAML file stored on Google Cloud Storage describing
     * additional information about the Index, that is specific to it. Unset if
     * the Index does not have any additional information. The schema is defined
     * as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * Note: The URI given on output will be immutable and probably different,
     * including the URI scheme, than the one given on input. The output URI will
     * point to a location where the user only has a read access.
     * </pre>
     *
     * <code>string metadata_schema_uri = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for metadataSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setMetadataSchemaUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      metadataSchemaUri_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.Value metadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        metadataBuilder_;
    /**
     *
     *
     * <pre>
     * An additional information about the Index; the schema of the metadata can
     * be found in
     * [metadata_schema][google.cloud.aiplatform.v1.Index.metadata_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 6;</code>
     *
     * @return Whether the metadata field is set.
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * An additional information about the Index; the schema of the metadata can
     * be found in
     * [metadata_schema][google.cloud.aiplatform.v1.Index.metadata_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 6;</code>
     *
     * @return The metadata.
     */
    public com.google.protobuf.Value getMetadata() {
      if (metadataBuilder_ == null) {
        return metadata_ == null ? com.google.protobuf.Value.getDefaultInstance() : metadata_;
      } else {
        return metadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * An additional information about the Index; the schema of the metadata can
     * be found in
     * [metadata_schema][google.cloud.aiplatform.v1.Index.metadata_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 6;</code>
     */
    public Builder setMetadata(com.google.protobuf.Value value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
      } else {
        metadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An additional information about the Index; the schema of the metadata can
     * be found in
     * [metadata_schema][google.cloud.aiplatform.v1.Index.metadata_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 6;</code>
     */
    public Builder setMetadata(com.google.protobuf.Value.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        metadata_ = builderForValue.build();
      } else {
        metadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An additional information about the Index; the schema of the metadata can
     * be found in
     * [metadata_schema][google.cloud.aiplatform.v1.Index.metadata_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 6;</code>
     */
    public Builder mergeMetadata(com.google.protobuf.Value value) {
      if (metadataBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && metadata_ != null
            && metadata_ != com.google.protobuf.Value.getDefaultInstance()) {
          getMetadataBuilder().mergeFrom(value);
        } else {
          metadata_ = value;
        }
      } else {
        metadataBuilder_.mergeFrom(value);
      }
      if (metadata_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An additional information about the Index; the schema of the metadata can
     * be found in
     * [metadata_schema][google.cloud.aiplatform.v1.Index.metadata_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 6;</code>
     */
    public Builder clearMetadata() {
      bitField0_ = (bitField0_ & ~0x00000010);
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An additional information about the Index; the schema of the metadata can
     * be found in
     * [metadata_schema][google.cloud.aiplatform.v1.Index.metadata_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 6;</code>
     */
    public com.google.protobuf.Value.Builder getMetadataBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An additional information about the Index; the schema of the metadata can
     * be found in
     * [metadata_schema][google.cloud.aiplatform.v1.Index.metadata_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 6;</code>
     */
    public com.google.protobuf.ValueOrBuilder getMetadataOrBuilder() {
      if (metadataBuilder_ != null) {
        return metadataBuilder_.getMessageOrBuilder();
      } else {
        return metadata_ == null ? com.google.protobuf.Value.getDefaultInstance() : metadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * An additional information about the Index; the schema of the metadata can
     * be found in
     * [metadata_schema][google.cloud.aiplatform.v1.Index.metadata_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getMetadataFieldBuilder() {
      if (metadataBuilder_ == null) {
        metadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(
                getMetadata(), getParentForChildren(), isClean());
        metadata_ = null;
      }
      return metadataBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1.DeployedIndexRef> deployedIndexes_ =
        java.util.Collections.emptyList();

    private void ensureDeployedIndexesIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        deployedIndexes_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1.DeployedIndexRef>(
                deployedIndexes_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.DeployedIndexRef,
            com.google.cloud.aiplatform.v1.DeployedIndexRef.Builder,
            com.google.cloud.aiplatform.v1.DeployedIndexRefOrBuilder>
        deployedIndexesBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedIndexes created from this Index.
     * An Index can be only deleted if all its DeployedIndexes had been undeployed
     * first.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedIndexRef deployed_indexes = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.DeployedIndexRef>
        getDeployedIndexesList() {
      if (deployedIndexesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(deployedIndexes_);
      } else {
        return deployedIndexesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedIndexes created from this Index.
     * An Index can be only deleted if all its DeployedIndexes had been undeployed
     * first.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedIndexRef deployed_indexes = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getDeployedIndexesCount() {
      if (deployedIndexesBuilder_ == null) {
        return deployedIndexes_.size();
      } else {
        return deployedIndexesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedIndexes created from this Index.
     * An Index can be only deleted if all its DeployedIndexes had been undeployed
     * first.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedIndexRef deployed_indexes = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.DeployedIndexRef getDeployedIndexes(int index) {
      if (deployedIndexesBuilder_ == null) {
        return deployedIndexes_.get(index);
      } else {
        return deployedIndexesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedIndexes created from this Index.
     * An Index can be only deleted if all its DeployedIndexes had been undeployed
     * first.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedIndexRef deployed_indexes = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeployedIndexes(
        int index, com.google.cloud.aiplatform.v1.DeployedIndexRef value) {
      if (deployedIndexesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeployedIndexesIsMutable();
        deployedIndexes_.set(index, value);
        onChanged();
      } else {
        deployedIndexesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedIndexes created from this Index.
     * An Index can be only deleted if all its DeployedIndexes had been undeployed
     * first.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedIndexRef deployed_indexes = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeployedIndexes(
        int index, com.google.cloud.aiplatform.v1.DeployedIndexRef.Builder builderForValue) {
      if (deployedIndexesBuilder_ == null) {
        ensureDeployedIndexesIsMutable();
        deployedIndexes_.set(index, builderForValue.build());
        onChanged();
      } else {
        deployedIndexesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedIndexes created from this Index.
     * An Index can be only deleted if all its DeployedIndexes had been undeployed
     * first.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedIndexRef deployed_indexes = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addDeployedIndexes(com.google.cloud.aiplatform.v1.DeployedIndexRef value) {
      if (deployedIndexesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeployedIndexesIsMutable();
        deployedIndexes_.add(value);
        onChanged();
      } else {
        deployedIndexesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedIndexes created from this Index.
     * An Index can be only deleted if all its DeployedIndexes had been undeployed
     * first.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedIndexRef deployed_indexes = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addDeployedIndexes(
        int index, com.google.cloud.aiplatform.v1.DeployedIndexRef value) {
      if (deployedIndexesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeployedIndexesIsMutable();
        deployedIndexes_.add(index, value);
        onChanged();
      } else {
        deployedIndexesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedIndexes created from this Index.
     * An Index can be only deleted if all its DeployedIndexes had been undeployed
     * first.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedIndexRef deployed_indexes = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addDeployedIndexes(
        com.google.cloud.aiplatform.v1.DeployedIndexRef.Builder builderForValue) {
      if (deployedIndexesBuilder_ == null) {
        ensureDeployedIndexesIsMutable();
        deployedIndexes_.add(builderForValue.build());
        onChanged();
      } else {
        deployedIndexesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedIndexes created from this Index.
     * An Index can be only deleted if all its DeployedIndexes had been undeployed
     * first.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedIndexRef deployed_indexes = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addDeployedIndexes(
        int index, com.google.cloud.aiplatform.v1.DeployedIndexRef.Builder builderForValue) {
      if (deployedIndexesBuilder_ == null) {
        ensureDeployedIndexesIsMutable();
        deployedIndexes_.add(index, builderForValue.build());
        onChanged();
      } else {
        deployedIndexesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedIndexes created from this Index.
     * An Index can be only deleted if all its DeployedIndexes had been undeployed
     * first.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedIndexRef deployed_indexes = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllDeployedIndexes(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.DeployedIndexRef> values) {
      if (deployedIndexesBuilder_ == null) {
        ensureDeployedIndexesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, deployedIndexes_);
        onChanged();
      } else {
        deployedIndexesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedIndexes created from this Index.
     * An Index can be only deleted if all its DeployedIndexes had been undeployed
     * first.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedIndexRef deployed_indexes = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDeployedIndexes() {
      if (deployedIndexesBuilder_ == null) {
        deployedIndexes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        deployedIndexesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedIndexes created from this Index.
     * An Index can be only deleted if all its DeployedIndexes had been undeployed
     * first.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedIndexRef deployed_indexes = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeDeployedIndexes(int index) {
      if (deployedIndexesBuilder_ == null) {
        ensureDeployedIndexesIsMutable();
        deployedIndexes_.remove(index);
        onChanged();
      } else {
        deployedIndexesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedIndexes created from this Index.
     * An Index can be only deleted if all its DeployedIndexes had been undeployed
     * first.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedIndexRef deployed_indexes = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.DeployedIndexRef.Builder getDeployedIndexesBuilder(
        int index) {
      return getDeployedIndexesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedIndexes created from this Index.
     * An Index can be only deleted if all its DeployedIndexes had been undeployed
     * first.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedIndexRef deployed_indexes = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.DeployedIndexRefOrBuilder getDeployedIndexesOrBuilder(
        int index) {
      if (deployedIndexesBuilder_ == null) {
        return deployedIndexes_.get(index);
      } else {
        return deployedIndexesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedIndexes created from this Index.
     * An Index can be only deleted if all its DeployedIndexes had been undeployed
     * first.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedIndexRef deployed_indexes = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1.DeployedIndexRefOrBuilder>
        getDeployedIndexesOrBuilderList() {
      if (deployedIndexesBuilder_ != null) {
        return deployedIndexesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(deployedIndexes_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedIndexes created from this Index.
     * An Index can be only deleted if all its DeployedIndexes had been undeployed
     * first.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedIndexRef deployed_indexes = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.DeployedIndexRef.Builder addDeployedIndexesBuilder() {
      return getDeployedIndexesFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1.DeployedIndexRef.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedIndexes created from this Index.
     * An Index can be only deleted if all its DeployedIndexes had been undeployed
     * first.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedIndexRef deployed_indexes = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.DeployedIndexRef.Builder addDeployedIndexesBuilder(
        int index) {
      return getDeployedIndexesFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1.DeployedIndexRef.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedIndexes created from this Index.
     * An Index can be only deleted if all its DeployedIndexes had been undeployed
     * first.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedIndexRef deployed_indexes = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.DeployedIndexRef.Builder>
        getDeployedIndexesBuilderList() {
      return getDeployedIndexesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.DeployedIndexRef,
            com.google.cloud.aiplatform.v1.DeployedIndexRef.Builder,
            com.google.cloud.aiplatform.v1.DeployedIndexRefOrBuilder>
        getDeployedIndexesFieldBuilder() {
      if (deployedIndexesBuilder_ == null) {
        deployedIndexesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.DeployedIndexRef,
                com.google.cloud.aiplatform.v1.DeployedIndexRef.Builder,
                com.google.cloud.aiplatform.v1.DeployedIndexRefOrBuilder>(
                deployedIndexes_,
                ((bitField0_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        deployedIndexes_ = null;
      }
      return deployedIndexesBuilder_;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 8;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 8;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 8;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 8;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your Indexes.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your Indexes.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your Indexes.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your Indexes.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000080);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your Indexes.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000080;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your Indexes.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000080;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your Indexes.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000080;
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Index was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Index was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Index was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Index was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Index was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Index was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Index was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Index was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Index was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Index was most recently updated.
     * This also includes any update to the contents of the Index.
     * Note that Operations working on this Index may have their
     * [Operations.metadata.generic_metadata.update_time]
     * [google.cloud.aiplatform.v1.GenericOperationMetadata.update_time] a little
     * after the value of this timestamp, yet that does not mean their results are
     * not already reflected in the Index. Result of any successfully completed
     * Operation on the Index is reflected in it.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Index was most recently updated.
     * This also includes any update to the contents of the Index.
     * Note that Operations working on this Index may have their
     * [Operations.metadata.generic_metadata.update_time]
     * [google.cloud.aiplatform.v1.GenericOperationMetadata.update_time] a little
     * after the value of this timestamp, yet that does not mean their results are
     * not already reflected in the Index. Result of any successfully completed
     * Operation on the Index is reflected in it.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Index was most recently updated.
     * This also includes any update to the contents of the Index.
     * Note that Operations working on this Index may have their
     * [Operations.metadata.generic_metadata.update_time]
     * [google.cloud.aiplatform.v1.GenericOperationMetadata.update_time] a little
     * after the value of this timestamp, yet that does not mean their results are
     * not already reflected in the Index. Result of any successfully completed
     * Operation on the Index is reflected in it.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Index was most recently updated.
     * This also includes any update to the contents of the Index.
     * Note that Operations working on this Index may have their
     * [Operations.metadata.generic_metadata.update_time]
     * [google.cloud.aiplatform.v1.GenericOperationMetadata.update_time] a little
     * after the value of this timestamp, yet that does not mean their results are
     * not already reflected in the Index. Result of any successfully completed
     * Operation on the Index is reflected in it.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Index was most recently updated.
     * This also includes any update to the contents of the Index.
     * Note that Operations working on this Index may have their
     * [Operations.metadata.generic_metadata.update_time]
     * [google.cloud.aiplatform.v1.GenericOperationMetadata.update_time] a little
     * after the value of this timestamp, yet that does not mean their results are
     * not already reflected in the Index. Result of any successfully completed
     * Operation on the Index is reflected in it.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Index was most recently updated.
     * This also includes any update to the contents of the Index.
     * Note that Operations working on this Index may have their
     * [Operations.metadata.generic_metadata.update_time]
     * [google.cloud.aiplatform.v1.GenericOperationMetadata.update_time] a little
     * after the value of this timestamp, yet that does not mean their results are
     * not already reflected in the Index. Result of any successfully completed
     * Operation on the Index is reflected in it.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000200);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Index was most recently updated.
     * This also includes any update to the contents of the Index.
     * Note that Operations working on this Index may have their
     * [Operations.metadata.generic_metadata.update_time]
     * [google.cloud.aiplatform.v1.GenericOperationMetadata.update_time] a little
     * after the value of this timestamp, yet that does not mean their results are
     * not already reflected in the Index. Result of any successfully completed
     * Operation on the Index is reflected in it.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Index was most recently updated.
     * This also includes any update to the contents of the Index.
     * Note that Operations working on this Index may have their
     * [Operations.metadata.generic_metadata.update_time]
     * [google.cloud.aiplatform.v1.GenericOperationMetadata.update_time] a little
     * after the value of this timestamp, yet that does not mean their results are
     * not already reflected in the Index. Result of any successfully completed
     * Operation on the Index is reflected in it.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Index was most recently updated.
     * This also includes any update to the contents of the Index.
     * Note that Operations working on this Index may have their
     * [Operations.metadata.generic_metadata.update_time]
     * [google.cloud.aiplatform.v1.GenericOperationMetadata.update_time] a little
     * after the value of this timestamp, yet that does not mean their results are
     * not already reflected in the Index. Result of any successfully completed
     * Operation on the Index is reflected in it.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.cloud.aiplatform.v1.IndexStats indexStats_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.IndexStats,
            com.google.cloud.aiplatform.v1.IndexStats.Builder,
            com.google.cloud.aiplatform.v1.IndexStatsOrBuilder>
        indexStatsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Stats of the index resource.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IndexStats index_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the indexStats field is set.
     */
    public boolean hasIndexStats() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Stats of the index resource.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IndexStats index_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The indexStats.
     */
    public com.google.cloud.aiplatform.v1.IndexStats getIndexStats() {
      if (indexStatsBuilder_ == null) {
        return indexStats_ == null
            ? com.google.cloud.aiplatform.v1.IndexStats.getDefaultInstance()
            : indexStats_;
      } else {
        return indexStatsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Stats of the index resource.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IndexStats index_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setIndexStats(com.google.cloud.aiplatform.v1.IndexStats value) {
      if (indexStatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        indexStats_ = value;
      } else {
        indexStatsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stats of the index resource.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IndexStats index_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setIndexStats(
        com.google.cloud.aiplatform.v1.IndexStats.Builder builderForValue) {
      if (indexStatsBuilder_ == null) {
        indexStats_ = builderForValue.build();
      } else {
        indexStatsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stats of the index resource.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IndexStats index_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeIndexStats(com.google.cloud.aiplatform.v1.IndexStats value) {
      if (indexStatsBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && indexStats_ != null
            && indexStats_ != com.google.cloud.aiplatform.v1.IndexStats.getDefaultInstance()) {
          getIndexStatsBuilder().mergeFrom(value);
        } else {
          indexStats_ = value;
        }
      } else {
        indexStatsBuilder_.mergeFrom(value);
      }
      if (indexStats_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stats of the index resource.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IndexStats index_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearIndexStats() {
      bitField0_ = (bitField0_ & ~0x00000400);
      indexStats_ = null;
      if (indexStatsBuilder_ != null) {
        indexStatsBuilder_.dispose();
        indexStatsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stats of the index resource.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IndexStats index_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.IndexStats.Builder getIndexStatsBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getIndexStatsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Stats of the index resource.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IndexStats index_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.IndexStatsOrBuilder getIndexStatsOrBuilder() {
      if (indexStatsBuilder_ != null) {
        return indexStatsBuilder_.getMessageOrBuilder();
      } else {
        return indexStats_ == null
            ? com.google.cloud.aiplatform.v1.IndexStats.getDefaultInstance()
            : indexStats_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Stats of the index resource.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IndexStats index_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.IndexStats,
            com.google.cloud.aiplatform.v1.IndexStats.Builder,
            com.google.cloud.aiplatform.v1.IndexStatsOrBuilder>
        getIndexStatsFieldBuilder() {
      if (indexStatsBuilder_ == null) {
        indexStatsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.IndexStats,
                com.google.cloud.aiplatform.v1.IndexStats.Builder,
                com.google.cloud.aiplatform.v1.IndexStatsOrBuilder>(
                getIndexStats(), getParentForChildren(), isClean());
        indexStats_ = null;
      }
      return indexStatsBuilder_;
    }

    private int indexUpdateMethod_ = 0;
    /**
     *
     *
     * <pre>
     * Immutable. The update method to use with this Index. If not set,
     * BATCH_UPDATE will be used by default.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Index.IndexUpdateMethod index_update_method = 16 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The enum numeric value on the wire for indexUpdateMethod.
     */
    @java.lang.Override
    public int getIndexUpdateMethodValue() {
      return indexUpdateMethod_;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The update method to use with this Index. If not set,
     * BATCH_UPDATE will be used by default.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Index.IndexUpdateMethod index_update_method = 16 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The enum numeric value on the wire for indexUpdateMethod to set.
     * @return This builder for chaining.
     */
    public Builder setIndexUpdateMethodValue(int value) {
      indexUpdateMethod_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The update method to use with this Index. If not set,
     * BATCH_UPDATE will be used by default.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Index.IndexUpdateMethod index_update_method = 16 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The indexUpdateMethod.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Index.IndexUpdateMethod getIndexUpdateMethod() {
      com.google.cloud.aiplatform.v1.Index.IndexUpdateMethod result =
          com.google.cloud.aiplatform.v1.Index.IndexUpdateMethod.forNumber(indexUpdateMethod_);
      return result == null
          ? com.google.cloud.aiplatform.v1.Index.IndexUpdateMethod.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The update method to use with this Index. If not set,
     * BATCH_UPDATE will be used by default.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Index.IndexUpdateMethod index_update_method = 16 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The indexUpdateMethod to set.
     * @return This builder for chaining.
     */
    public Builder setIndexUpdateMethod(
        com.google.cloud.aiplatform.v1.Index.IndexUpdateMethod value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000800;
      indexUpdateMethod_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The update method to use with this Index. If not set,
     * BATCH_UPDATE will be used by default.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Index.IndexUpdateMethod index_update_method = 16 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIndexUpdateMethod() {
      bitField0_ = (bitField0_ & ~0x00000800);
      indexUpdateMethod_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1.EncryptionSpec encryptionSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.EncryptionSpec,
            com.google.cloud.aiplatform.v1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder>
        encryptionSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Immutable. Customer-managed encryption key spec for an Index. If set, this
     * Index and all sub-resources of this Index will be secured by this key.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 17 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return Whether the encryptionSpec field is set.
     */
    public boolean hasEncryptionSpec() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Immutable. Customer-managed encryption key spec for an Index. If set, this
     * Index and all sub-resources of this Index will be secured by this key.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 17 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The encryptionSpec.
     */
    public com.google.cloud.aiplatform.v1.EncryptionSpec getEncryptionSpec() {
      if (encryptionSpecBuilder_ == null) {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      } else {
        return encryptionSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Customer-managed encryption key spec for an Index. If set, this
     * Index and all sub-resources of this Index will be secured by this key.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 17 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setEncryptionSpec(com.google.cloud.aiplatform.v1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionSpec_ = value;
      } else {
        encryptionSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Customer-managed encryption key spec for an Index. If set, this
     * Index and all sub-resources of this Index will be secured by this key.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 17 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setEncryptionSpec(
        com.google.cloud.aiplatform.v1.EncryptionSpec.Builder builderForValue) {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpec_ = builderForValue.build();
      } else {
        encryptionSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Customer-managed encryption key spec for an Index. If set, this
     * Index and all sub-resources of this Index will be secured by this key.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 17 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder mergeEncryptionSpec(com.google.cloud.aiplatform.v1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && encryptionSpec_ != null
            && encryptionSpec_
                != com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()) {
          getEncryptionSpecBuilder().mergeFrom(value);
        } else {
          encryptionSpec_ = value;
        }
      } else {
        encryptionSpecBuilder_.mergeFrom(value);
      }
      if (encryptionSpec_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Customer-managed encryption key spec for an Index. If set, this
     * Index and all sub-resources of this Index will be secured by this key.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 17 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder clearEncryptionSpec() {
      bitField0_ = (bitField0_ & ~0x00001000);
      encryptionSpec_ = null;
      if (encryptionSpecBuilder_ != null) {
        encryptionSpecBuilder_.dispose();
        encryptionSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Customer-managed encryption key spec for an Index. If set, this
     * Index and all sub-resources of this Index will be secured by this key.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 17 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.EncryptionSpec.Builder getEncryptionSpecBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getEncryptionSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Immutable. Customer-managed encryption key spec for an Index. If set, this
     * Index and all sub-resources of this Index will be secured by this key.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 17 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder getEncryptionSpecOrBuilder() {
      if (encryptionSpecBuilder_ != null) {
        return encryptionSpecBuilder_.getMessageOrBuilder();
      } else {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Customer-managed encryption key spec for an Index. If set, this
     * Index and all sub-resources of this Index will be secured by this key.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 17 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.EncryptionSpec,
            com.google.cloud.aiplatform.v1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder>
        getEncryptionSpecFieldBuilder() {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.EncryptionSpec,
                com.google.cloud.aiplatform.v1.EncryptionSpec.Builder,
                com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder>(
                getEncryptionSpec(), getParentForChildren(), isClean());
        encryptionSpec_ = null;
      }
      return encryptionSpecBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.Index)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.Index)
  private static final com.google.cloud.aiplatform.v1.Index DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.Index();
  }

  public static com.google.cloud.aiplatform.v1.Index getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Index> PARSER =
      new com.google.protobuf.AbstractParser<Index>() {
        @java.lang.Override
        public Index parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Index> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Index> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Index getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
