/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.admin.v1beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MeasurementProtocolSecretName
implements ResourceName {
    private static final PathTemplate PROPERTY_DATA_STREAM_MEASUREMENT_PROTOCOL_SECRET = PathTemplate.createWithoutUrlEncoding((String)"properties/{property}/dataStreams/{data_stream}/measurementProtocolSecrets/{measurement_protocol_secret}");
    private volatile Map<String, String> fieldValuesMap;
    private final String property;
    private final String dataStream;
    private final String measurementProtocolSecret;

    @Deprecated
    protected MeasurementProtocolSecretName() {
        this.property = null;
        this.dataStream = null;
        this.measurementProtocolSecret = null;
    }

    private MeasurementProtocolSecretName(Builder builder) {
        this.property = (String)Preconditions.checkNotNull((Object)builder.getProperty());
        this.dataStream = (String)Preconditions.checkNotNull((Object)builder.getDataStream());
        this.measurementProtocolSecret = (String)Preconditions.checkNotNull((Object)builder.getMeasurementProtocolSecret());
    }

    public String getProperty() {
        return this.property;
    }

    public String getDataStream() {
        return this.dataStream;
    }

    public String getMeasurementProtocolSecret() {
        return this.measurementProtocolSecret;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MeasurementProtocolSecretName of(String property, String dataStream, String measurementProtocolSecret) {
        return MeasurementProtocolSecretName.newBuilder().setProperty(property).setDataStream(dataStream).setMeasurementProtocolSecret(measurementProtocolSecret).build();
    }

    public static String format(String property, String dataStream, String measurementProtocolSecret) {
        return MeasurementProtocolSecretName.newBuilder().setProperty(property).setDataStream(dataStream).setMeasurementProtocolSecret(measurementProtocolSecret).build().toString();
    }

    public static MeasurementProtocolSecretName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROPERTY_DATA_STREAM_MEASUREMENT_PROTOCOL_SECRET.validatedMatch(formattedString, "MeasurementProtocolSecretName.parse: formattedString not in valid format");
        return MeasurementProtocolSecretName.of((String)matchMap.get("property"), (String)matchMap.get("data_stream"), (String)matchMap.get("measurement_protocol_secret"));
    }

    public static List<MeasurementProtocolSecretName> parseList(List<String> formattedStrings) {
        ArrayList<MeasurementProtocolSecretName> list = new ArrayList<MeasurementProtocolSecretName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MeasurementProtocolSecretName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MeasurementProtocolSecretName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MeasurementProtocolSecretName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROPERTY_DATA_STREAM_MEASUREMENT_PROTOCOL_SECRET.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MeasurementProtocolSecretName measurementProtocolSecretName = this;
            synchronized (measurementProtocolSecretName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.property != null) {
                        fieldMapBuilder.put((Object)"property", (Object)this.property);
                    }
                    if (this.dataStream != null) {
                        fieldMapBuilder.put((Object)"data_stream", (Object)this.dataStream);
                    }
                    if (this.measurementProtocolSecret != null) {
                        fieldMapBuilder.put((Object)"measurement_protocol_secret", (Object)this.measurementProtocolSecret);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROPERTY_DATA_STREAM_MEASUREMENT_PROTOCOL_SECRET.instantiate(new String[]{"property", this.property, "data_stream", this.dataStream, "measurement_protocol_secret", this.measurementProtocolSecret});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            MeasurementProtocolSecretName that = (MeasurementProtocolSecretName)o;
            return Objects.equals(this.property, that.property) && Objects.equals(this.dataStream, that.dataStream) && Objects.equals(this.measurementProtocolSecret, that.measurementProtocolSecret);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.property);
        h *= 1000003;
        h ^= Objects.hashCode(this.dataStream);
        h *= 1000003;
        return h ^= Objects.hashCode(this.measurementProtocolSecret);
    }

    public static class Builder {
        private String property;
        private String dataStream;
        private String measurementProtocolSecret;

        protected Builder() {
        }

        public String getProperty() {
            return this.property;
        }

        public String getDataStream() {
            return this.dataStream;
        }

        public String getMeasurementProtocolSecret() {
            return this.measurementProtocolSecret;
        }

        public Builder setProperty(String property) {
            this.property = property;
            return this;
        }

        public Builder setDataStream(String dataStream) {
            this.dataStream = dataStream;
            return this;
        }

        public Builder setMeasurementProtocolSecret(String measurementProtocolSecret) {
            this.measurementProtocolSecret = measurementProtocolSecret;
            return this;
        }

        private Builder(MeasurementProtocolSecretName measurementProtocolSecretName) {
            this.property = measurementProtocolSecretName.property;
            this.dataStream = measurementProtocolSecretName.dataStream;
            this.measurementProtocolSecret = measurementProtocolSecretName.measurementProtocolSecret;
        }

        public MeasurementProtocolSecretName build() {
            return new MeasurementProtocolSecretName(this);
        }
    }
}

