/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.BetaApi;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StreamingCallSettings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;

@BetaApi(value="The surface for streaming is not stable yet and may change in the future.")
public final class ServerStreamingCallSettings<RequestT, ResponseT>
extends StreamingCallSettings<RequestT, ResponseT> {
    private final Set<StatusCode.Code> retryableCodes;

    private ServerStreamingCallSettings(Builder<RequestT, ResponseT> builder) {
        this.retryableCodes = ImmutableSet.copyOf((Collection)((Builder)builder).retryableCodes);
    }

    public Set<StatusCode.Code> getRetryableCodes() {
        return this.retryableCodes;
    }

    @Override
    public Builder<RequestT, ResponseT> toBuilder() {
        return new Builder(this);
    }

    public static <RequestT, ResponseT> Builder<RequestT, ResponseT> newBuilder() {
        return new Builder();
    }

    public static class Builder<RequestT, ResponseT>
    extends StreamingCallSettings.Builder<RequestT, ResponseT> {
        private Set<StatusCode.Code> retryableCodes;

        private Builder() {
            this.retryableCodes = ImmutableSet.of();
        }

        private Builder(ServerStreamingCallSettings<RequestT, ResponseT> settings) {
            super(settings);
            this.retryableCodes = ((ServerStreamingCallSettings)settings).retryableCodes;
        }

        public Builder<RequestT, ResponseT> setRetryableCodes(StatusCode.Code ... codes) {
            this.setRetryableCodes(Sets.newHashSet((Object[])codes));
            return this;
        }

        public Builder<RequestT, ResponseT> setRetryableCodes(Set<StatusCode.Code> retryableCodes) {
            this.retryableCodes = Sets.newHashSet(retryableCodes);
            return this;
        }

        public Set<StatusCode.Code> getRetryableCodes() {
            return this.retryableCodes;
        }

        @Override
        public ServerStreamingCallSettings<RequestT, ResponseT> build() {
            return new ServerStreamingCallSettings(this);
        }
    }
}

