/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson.longrunning.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonLongRunningClient;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.OperationsClient;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsCallableFactory;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStubSettings;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.LongRunningClient;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.longrunning.CancelOperationRequest;
import com.google.longrunning.DeleteOperationRequest;
import com.google.longrunning.GetOperationRequest;
import com.google.longrunning.ListOperationsRequest;
import com.google.longrunning.ListOperationsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonOperationsStub
extends OperationsStub {
    private static final Pattern CLIENT_PACKAGE_VERSION_PATTERN = Pattern.compile("\\.(?<version>v\\d+[a-zA-Z]*\\d*[a-zA-Z]*\\d*)\\.[\\w.]*stub");
    private static final ApiMethodDescriptor<ListOperationsRequest, ListOperationsResponse> listOperationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.longrunning.Operations/ListOperations").setHttpMethod("GET").setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=**}/operations", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", request.getFilter());
        serializer.putQueryParam(fields, "pageSize", request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(ListOperationsResponse.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<GetOperationRequest, Operation> getOperationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.longrunning.Operations/GetOperation").setHttpMethod("GET").setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=**/operations/*}", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> new HashMap()).setRequestBodyExtractor(request -> null).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(Operation.getDefaultInstance()).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create(response)).setPollingRequestFactory(compoundOperationId -> GetOperationRequest.newBuilder().setName(compoundOperationId).build()).build();
    private static final ApiMethodDescriptor<DeleteOperationRequest, Empty> deleteOperationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.longrunning.Operations/DeleteOperation").setHttpMethod("DELETE").setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=**/operations/*}", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> new HashMap()).setRequestBodyExtractor(request -> null).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(Empty.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<CancelOperationRequest, Empty> cancelOperationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.longrunning.Operations/CancelOperation").setHttpMethod("POST").setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=**/operations/*}:cancel", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> new HashMap()).setRequestBodyExtractor(request -> null).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(Empty.getDefaultInstance()).build()).build();
    private final UnaryCallable<ListOperationsRequest, ListOperationsResponse> listOperationsCallable;
    private final UnaryCallable<ListOperationsRequest, OperationsClient.ListOperationsPagedResponse> listOperationsPagedCallable;
    private final UnaryCallable<GetOperationRequest, Operation> getOperationCallable;
    private final UnaryCallable<DeleteOperationRequest, Empty> deleteOperationCallable;
    private final UnaryCallable<CancelOperationRequest, Empty> cancelOperationCallable;
    private final LongRunningClient longRunningClient;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonOperationsStub create(OperationsStubSettings settings) throws IOException {
        return new HttpJsonOperationsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonOperationsStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonOperationsStub(OperationsStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonOperationsStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonOperationsStub(OperationsStubSettings.newBuilder().build(), clientContext, callableFactory, TypeRegistry.getEmptyTypeRegistry());
    }

    public static final HttpJsonOperationsStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory, TypeRegistry typeRegistry) throws IOException {
        return new HttpJsonOperationsStub(OperationsStubSettings.newBuilder().build(), clientContext, callableFactory, typeRegistry);
    }

    protected HttpJsonOperationsStub(OperationsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonOperationsCallableFactory(), TypeRegistry.getEmptyTypeRegistry());
    }

    protected HttpJsonOperationsStub(OperationsStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory, TypeRegistry typeRegistry) throws IOException {
        this.callableFactory = callableFactory;
        Matcher packageMatcher = CLIENT_PACKAGE_VERSION_PATTERN.matcher(callableFactory.getClass().getPackage().getName());
        String apiVersion = packageMatcher.find() ? packageMatcher.group("version") : null;
        HttpJsonCallSettings<ListOperationsRequest, ListOperationsResponse> listOperationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(HttpJsonOperationsStub.getApiVersionedMethodDescriptor(listOperationsMethodDescriptor, apiVersion)).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings<GetOperationRequest, Operation> getOperationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(HttpJsonOperationsStub.getApiVersionedMethodDescriptor(getOperationMethodDescriptor, apiVersion)).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings<DeleteOperationRequest, Empty> deleteOperationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(HttpJsonOperationsStub.getApiVersionedMethodDescriptor(deleteOperationMethodDescriptor, apiVersion)).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings<CancelOperationRequest, Empty> cancelOperationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(HttpJsonOperationsStub.getApiVersionedMethodDescriptor(cancelOperationMethodDescriptor, apiVersion)).setTypeRegistry(typeRegistry).build();
        this.listOperationsCallable = callableFactory.createUnaryCallable(listOperationsTransportSettings, settings.listOperationsSettings(), clientContext);
        this.listOperationsPagedCallable = callableFactory.createPagedCallable(listOperationsTransportSettings, settings.listOperationsSettings(), clientContext);
        this.getOperationCallable = callableFactory.createUnaryCallable(getOperationTransportSettings, settings.getOperationSettings(), clientContext);
        this.deleteOperationCallable = callableFactory.createUnaryCallable(deleteOperationTransportSettings, settings.deleteOperationSettings(), clientContext);
        this.cancelOperationCallable = callableFactory.createUnaryCallable(cancelOperationTransportSettings, settings.cancelOperationSettings(), clientContext);
        this.longRunningClient = new HttpJsonLongRunningClient<GetOperationRequest, Operation>(this.getOperationCallable, getOperationMethodDescriptor.getOperationSnapshotFactory(), getOperationMethodDescriptor.getPollingRequestFactory());
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    private static <RequestT extends Message, ResponseT> ApiMethodDescriptor<RequestT, ResponseT> getApiVersionedMethodDescriptor(ApiMethodDescriptor<RequestT, ResponseT> methodDescriptor, String apiVersion) {
        if (apiVersion == null) {
            return methodDescriptor;
        }
        ApiMethodDescriptor.Builder descriptorBuilder = methodDescriptor.toBuilder();
        ProtoMessageRequestFormatter requestFormatter = (ProtoMessageRequestFormatter)descriptorBuilder.getRequestFormatter();
        return descriptorBuilder.setRequestFormatter(requestFormatter.toBuilder().updateRawPath("/v1/", '/' + apiVersion + '/').build()).build();
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listOperationsMethodDescriptor);
        methodDescriptors.add(getOperationMethodDescriptor);
        methodDescriptors.add(deleteOperationMethodDescriptor);
        methodDescriptors.add(cancelOperationMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<ListOperationsRequest, ListOperationsResponse> listOperationsCallable() {
        return this.listOperationsCallable;
    }

    @Override
    public UnaryCallable<ListOperationsRequest, OperationsClient.ListOperationsPagedResponse> listOperationsPagedCallable() {
        return this.listOperationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetOperationRequest, Operation> getOperationCallable() {
        return this.getOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteOperationRequest, Empty> deleteOperationCallable() {
        return this.deleteOperationCallable;
    }

    @Override
    public UnaryCallable<CancelOperationRequest, Empty> cancelOperationCallable() {
        return this.cancelOperationCallable;
    }

    @Override
    public LongRunningClient longRunningClient() {
        return this.longRunningClient;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

