/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.core.ApiFuture;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallContext;
import com.google.api.gax.httpjson.HttpJsonCallOptions;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.base.Preconditions;
import com.google.protobuf.TypeRegistry;
import org.threeten.bp.Instant;
import org.threeten.bp.temporal.TemporalAmount;

class HttpJsonDirectCallable<RequestT, ResponseT>
extends UnaryCallable<RequestT, ResponseT> {
    private final ApiMethodDescriptor<RequestT, ResponseT> descriptor;
    private final TypeRegistry typeRegistry;

    HttpJsonDirectCallable(ApiMethodDescriptor<RequestT, ResponseT> descriptor) {
        this(descriptor, null);
    }

    HttpJsonDirectCallable(ApiMethodDescriptor<RequestT, ResponseT> descriptor, TypeRegistry typeRegistry) {
        this.descriptor = descriptor;
        this.typeRegistry = typeRegistry;
    }

    public ApiFuture<ResponseT> futureCall(RequestT request, ApiCallContext inputContext) {
        Preconditions.checkNotNull(request);
        HttpJsonCallContext context = HttpJsonCallContext.createDefault().nullToSelf(inputContext);
        Instant deadline = context.getDeadline();
        if (context.getTimeout() != null) {
            Instant newDeadline = Instant.now().plus((TemporalAmount)context.getTimeout());
            if (deadline == null || newDeadline.isBefore(deadline)) {
                deadline = newDeadline;
            }
        }
        HttpJsonCallOptions callOptions = HttpJsonCallOptions.newBuilder().setDeadline(deadline).setCredentials(context.getCredentials()).setTypeRegistry(this.typeRegistry).build();
        return context.getChannel().issueFutureUnaryCall(callOptions, request, this.descriptor);
    }

    public String toString() {
        return String.format("direct(%s)", this.descriptor);
    }
}

