/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc.testing;

import com.google.api.gax.grpc.testing.MockGrpcService;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.TransportChannel;
import com.google.common.truth.Truth;
import io.grpc.Server;
import io.grpc.ServerServiceDefinition;
import java.io.IOException;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class MockServiceHelperTest {
    @Mock
    private MockGrpcService grpcService;
    @Mock
    private MockGrpcService grpcService2;
    @Mock
    private Server server;

    @BeforeEach
    void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.grpcService.getServiceDefinition()).thenReturn((Object)ServerServiceDefinition.builder((String)"fake-service").build());
        Mockito.when((Object)this.grpcService2.getServiceDefinition()).thenReturn((Object)ServerServiceDefinition.builder((String)"fake-service2").build());
    }

    @Test
    void testGetService() {
        MockServiceHelper serviceHelper = new MockServiceHelper(this.server, "fake-address", this.grpcService);
        Truth.assertThat((Object)serviceHelper.getService()).isSameInstanceAs((Object)this.grpcService);
        Truth.assertThat((Integer)serviceHelper.getServices().size()).isEqualTo((Object)1);
    }

    @Test
    void testGetServiceInvalid() {
        MockServiceHelper serviceHelper = new MockServiceHelper(this.server, "fake-address2", Arrays.asList(this.grpcService, this.grpcService2));
        Assertions.assertThrows(IllegalStateException.class, serviceHelper::getService);
    }

    @Test
    void testStart() throws IOException {
        MockServiceHelper serviceHelper = new MockServiceHelper(this.server, "fake-address", this.grpcService);
        serviceHelper.start();
        ((Server)Mockito.verify((Object)this.server, (VerificationMode)Mockito.times((int)1))).start();
    }

    @Test
    void testReset() {
        MockServiceHelper serviceHelper = new MockServiceHelper("fake-address", this.grpcService);
        serviceHelper.reset();
        ((MockGrpcService)Mockito.verify((Object)this.grpcService, (VerificationMode)Mockito.times((int)1))).getServiceDefinition();
        ((MockGrpcService)Mockito.verify((Object)this.grpcService, (VerificationMode)Mockito.times((int)1))).reset();
    }

    @Test
    void testCreateChannelProvider() throws Exception {
        MockServiceHelper serviceHelper = new MockServiceHelper("fake-address", this.grpcService);
        TransportChannel channel = serviceHelper.createChannelProvider().getTransportChannel();
        Assertions.assertNotNull((Object)channel);
        Assertions.assertFalse((boolean)channel.isTerminated());
        channel.shutdownNow();
    }
}

