/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc.testing;

import com.google.api.core.BetaApi;
import com.google.api.gax.grpc.GrpcHeaderInterceptor;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.inprocess.InProcessChannelBuilder;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Pattern;

@BetaApi
public class LocalChannelProvider
implements TransportChannelProvider {
    private final List<LocalHeaderInterceptor> interceptors = new CopyOnWriteArrayList<LocalHeaderInterceptor>();
    private final String address;
    private volatile HeaderProvider headerProvider;

    private LocalChannelProvider(String address, HeaderProvider headerProvider) {
        this.address = address;
        this.headerProvider = headerProvider;
    }

    public boolean shouldAutoClose() {
        return true;
    }

    public boolean needsExecutor() {
        return false;
    }

    @Deprecated
    public TransportChannelProvider withExecutor(ScheduledExecutorService executor) {
        return this.withExecutor((Executor)executor);
    }

    public TransportChannelProvider withExecutor(Executor executor) {
        throw new UnsupportedOperationException("LocalChannelProvider doesn't need an executor");
    }

    public boolean needsHeaders() {
        return this.headerProvider == null;
    }

    public boolean needsEndpoint() {
        return false;
    }

    public TransportChannelProvider withEndpoint(String endpoint) {
        throw new UnsupportedOperationException("LocalChannelProvider doesn't need an endpoint");
    }

    @BetaApi(value="The surface for customizing pool size is not stable yet and may change in the future.")
    public boolean acceptsPoolSize() {
        return false;
    }

    @BetaApi(value="The surface for customizing pool size is not stable yet and may change in the future.")
    public TransportChannelProvider withPoolSize(int size) {
        throw new UnsupportedOperationException("LocalChannelProvider doesn't allow pool size customization");
    }

    public TransportChannelProvider withHeaders(Map<String, String> headers) {
        this.headerProvider = FixedHeaderProvider.create(headers);
        return this;
    }

    public TransportChannel getTransportChannel() throws IOException {
        InProcessChannelBuilder channelBuilder = InProcessChannelBuilder.forName((String)this.address).usePlaintext();
        if (this.headerProvider != null) {
            GrpcHeaderInterceptor interceptor = new GrpcHeaderInterceptor(this.headerProvider.getHeaders());
            LocalHeaderInterceptor localHeaderInterceptor = new LocalHeaderInterceptor((ClientInterceptor)interceptor);
            this.interceptors.add(localHeaderInterceptor);
            channelBuilder.intercept(new ClientInterceptor[]{localHeaderInterceptor}).userAgent(interceptor.getUserAgentHeader());
        }
        return GrpcTransportChannel.newBuilder().setManagedChannel(channelBuilder.build()).build();
    }

    public String getTransportName() {
        return GrpcTransportChannel.getGrpcTransportName();
    }

    public boolean needsCredentials() {
        return false;
    }

    public TransportChannelProvider withCredentials(Credentials credentials) {
        throw new UnsupportedOperationException("LocalChannelProvider doesn't need credentials");
    }

    public static LocalChannelProvider create(String addressString) {
        return new LocalChannelProvider(addressString, null);
    }

    public boolean isHeaderSent(String headerKey, Pattern headerPattern) {
        Metadata.Key key = Metadata.Key.of((String)headerKey, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        if (this.interceptors.isEmpty()) {
            return false;
        }
        for (LocalHeaderInterceptor interceptor : this.interceptors) {
            if (interceptor.getSubmittedHeaders().isEmpty()) {
                return false;
            }
            for (Metadata submittedHeaders : interceptor.getSubmittedHeaders()) {
                String headerValue = (String)submittedHeaders.get(key);
                if (headerValue != null && headerPattern.matcher(headerValue).matches()) continue;
                return false;
            }
        }
        return true;
    }

    private static class LocalHeaderInterceptor
    implements ClientInterceptor {
        private final ClientInterceptor innerInterceptor;
        private final List<Metadata> submittedHeaders;

        private LocalHeaderInterceptor(ClientInterceptor innerInterceptor) {
            this.innerInterceptor = innerInterceptor;
            this.submittedHeaders = new CopyOnWriteArrayList<Metadata>();
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            ClientCall call = this.innerInterceptor.interceptCall(method, callOptions, next);
            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(call){

                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    super.start(responseListener, headers);
                    LocalHeaderInterceptor.this.submittedHeaders.add(headers);
                }
            };
        }

        List<Metadata> getSubmittedHeaders() {
            return this.submittedHeaders;
        }
    }
}

