/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.test;

import com.gs.fw.common.mithra.DefaultJtaProvider;
import com.gs.fw.common.mithra.JtaProvider;
import com.gs.fw.common.mithra.MithraDataObject;
import com.gs.fw.common.mithra.MithraDatabaseObject;
import com.gs.fw.common.mithra.MithraException;
import com.gs.fw.common.mithra.MithraManager;
import com.gs.fw.common.mithra.MithraManagerProvider;
import com.gs.fw.common.mithra.MithraObject;
import com.gs.fw.common.mithra.MithraObjectDeserializer;
import com.gs.fw.common.mithra.MithraObjectFactory;
import com.gs.fw.common.mithra.MithraObjectPortal;
import com.gs.fw.common.mithra.MithraRuntimeConfig;
import com.gs.fw.common.mithra.MithraTransactionException;
import com.gs.fw.common.mithra.attribute.AsOfAttribute;
import com.gs.fw.common.mithra.attribute.Attribute;
import com.gs.fw.common.mithra.cache.MithraReferenceThread;
import com.gs.fw.common.mithra.cache.PartialUniqueIndex;
import com.gs.fw.common.mithra.connectionmanager.IntSourceConnectionManager;
import com.gs.fw.common.mithra.connectionmanager.ObjectSourceConnectionManager;
import com.gs.fw.common.mithra.connectionmanager.SourcelessConnectionManager;
import com.gs.fw.common.mithra.database.MithraAbstractDatabaseObject;
import com.gs.fw.common.mithra.databasetype.DatabaseType;
import com.gs.fw.common.mithra.databasetype.DerbyDatabaseType;
import com.gs.fw.common.mithra.databasetype.H2DatabaseType;
import com.gs.fw.common.mithra.extractor.Extractor;
import com.gs.fw.common.mithra.finder.RelatedFinder;
import com.gs.fw.common.mithra.mithraruntime.MithraRuntimeType;
import com.gs.fw.common.mithra.notification.MithraReplicatedDatabaseObject;
import com.gs.fw.common.mithra.notification.RunsMasterQueueDatabaseObject;
import com.gs.fw.common.mithra.notification.RunsMasterQueueFinder;
import com.gs.fw.common.mithra.notification.replication.ReplicationNotificationConnectionManager;
import com.gs.fw.common.mithra.test.ConnectionManagerForTests;
import com.gs.fw.common.mithra.test.DerbyServer;
import com.gs.fw.common.mithra.test.H2DbServer;
import com.gs.fw.common.mithra.test.MithraTestConnectionManager;
import com.gs.fw.common.mithra.test.MithraTestDataParser;
import com.gs.fw.common.mithra.test.TestDataFile;
import com.gs.fw.common.mithra.test.TestDatabaseConfiguration;
import com.gs.fw.common.mithra.transaction.LocalTm;
import com.gs.fw.common.mithra.util.ListFactory;
import com.gs.fw.common.mithra.util.MithraConfigurationManager;
import com.gs.fw.common.mithra.util.MultiHashMap;
import com.gs.fw.common.mithra.util.fileparser.MithraParsedData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.TransactionManager;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MithraTestResource {
    private static final Logger logger = LoggerFactory.getLogger((String)MithraTestResource.class.getName());
    private String configFileName = "";
    private static final Class[] NO_PARAMS = new Class[0];
    private static final Object[] NO_ARGS = new Object[0];
    public static final String ROOT_KEY = "mithra.xml.root";
    private Set<String> restrictedClasses;
    private static final PartialUniqueIndex testDataIndex = new PartialUniqueIndex("", new Extractor[]{new TestDataFile.FilenameExtractor()});
    private List<TestDataFile> testPureFilesInUse;
    private boolean deleteOnCreate = true;
    private List<MithraRuntimeConfig> mithraRuntimeList = new ArrayList<MithraRuntimeConfig>();
    private Set<String> configuredObjects = new UnifiedSet();
    private DatabaseType databaseType = H2DatabaseType.getInstance();
    private boolean testConnectionsOnTearDown = false;
    private boolean isStrictParsingEnabled = false;
    private boolean validateConnectionManagers = Boolean.parseBoolean(System.getProperty("mithraTestResource.validateConnectionManagers", Boolean.TRUE.toString()));
    private static final Map<MithraTestConnectionManager, List<TestDatabaseConfiguration>> configuredDatabasesPerConnectionManager = new HashMap<MithraTestConnectionManager, List<TestDatabaseConfiguration>>();
    private final Map<MithraTestConnectionManager, List<MithraDatabaseObject>> databaseObjectPerConnectionManager = new HashMap<MithraTestConnectionManager, List<MithraDatabaseObject>>(3);
    private final Set<MithraTestConnectionManager> connectionManagersInUse = new UnifiedSet(3);
    private final Set<MithraTestConnectionManager> additionalConnectionManagersInUse = new UnifiedSet(3);
    private final Set<String> testDataFilesInUse = new UnifiedSet(3);
    private static final Map<String, MithraRuntimeType> parsedConfigurations = new UnifiedMap();
    protected List<MithraObjectPortal> portals;
    protected Map<String, List<MithraObject>> testData = new UnifiedMap();
    protected Charset charset;
    private boolean setUpCompleted;
    private MithraRuntimeType runtimeType;
    private boolean runtimeInitialized;
    private static Map<MasterQueueTableMapKey, MithraDatabaseObject> masterQueueTableMap = new UnifiedMap(3);
    private static List<MithraDatabaseObject> replicatedChildQueueTables = new ArrayList<MithraDatabaseObject>(3);
    private static Map<String, MithraDatabaseObject> createdChildQueueTables = new UnifiedMap();

    public boolean isSetUpCompleted() {
        return this.setUpCompleted;
    }

    public MithraTestResource(String configFilename) {
        this(configFilename, (DatabaseType)H2DatabaseType.getInstance());
    }

    protected MithraTestResource(String configFilename, MithraConfigurationManager manager) {
        this(configFilename, (DatabaseType)H2DatabaseType.getInstance(), manager);
    }

    public MithraTestResource(String configFilename, DatabaseType databaseType) {
        this(configFilename, databaseType, null);
    }

    protected MithraTestResource(String configFilename, DatabaseType databaseType, MithraConfigurationManager manager) {
        this.initialize(databaseType, manager);
        if (configFilename == null) {
            throw new MithraException("Could not construct MihtraTestResourceInstance, filename can not be null");
        }
        this.configFileName = configFilename;
        MithraTestResource.getLogger().debug("config file " + configFilename);
        this.runtimeType = this.loadConfigXml(configFilename);
    }

    public MithraTestResource(MithraRuntimeType mithraRuntimeType) {
        this(mithraRuntimeType, (DatabaseType)H2DatabaseType.getInstance(), null);
    }

    public MithraTestResource(MithraRuntimeType mithraRuntimeType, MithraConfigurationManager manager) {
        this(mithraRuntimeType, (DatabaseType)H2DatabaseType.getInstance(), manager);
    }

    public MithraTestResource(MithraRuntimeType mithraRuntimeType, DatabaseType databaseType, MithraConfigurationManager manager) {
        this.initialize(databaseType, manager);
        this.runtimeType = mithraRuntimeType;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    private void initializeRuntime() {
        if (!this.runtimeInitialized) {
            this.runtimeInitialized = true;
            this.initializeRuntimeConfig(this.runtimeType);
        }
    }

    private void initialize(DatabaseType databaseType, MithraConfigurationManager manager) {
        this.setDatabaseType(databaseType);
        try {
            this.startTestDatabaseServer(databaseType);
            this.initializeMithraManager(manager);
        }
        catch (Exception e) {
            MithraTestResource.getLogger().error("Unable to initialize MithraTestResource", (Throwable)e);
            throw new MithraException("Unable to initialize MithraTestResource", (Throwable)e);
        }
    }

    protected void startTestDatabaseServer(DatabaseType databaseType) {
        if (databaseType instanceof DerbyDatabaseType) {
            DerbyServer.getInstance().startDerbyServer();
        } else if (databaseType instanceof H2DatabaseType) {
            H2DbServer.getInstance().startH2DbServer();
        }
    }

    protected static Logger getLogger() {
        return logger;
    }

    public void setDeleteOnCreate(boolean deleteOnCreate) {
        this.deleteOnCreate = deleteOnCreate;
    }

    public boolean isDeleteOnCreate() {
        return this.deleteOnCreate;
    }

    public static List<MithraDatabaseObject> getReplicatedChildQueueTables() {
        return replicatedChildQueueTables;
    }

    public Set<String> getTestDataFilesInUse() {
        return this.testDataFilesInUse;
    }

    public Map<MithraTestConnectionManager, List<MithraDatabaseObject>> getDatabaseObjectPerConnectionManager() {
        return this.databaseObjectPerConnectionManager;
    }

    public void setDatabaseType(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }

    public void setStrictParsingEnabled(boolean strictParsingEnabled) {
        this.isStrictParsingEnabled = strictParsingEnabled;
    }

    @Deprecated
    public void setIgnoreUnconfiguredObjects(boolean ignoreUnconfiguredObjects) {
    }

    public void setValidateConnectionManagers(boolean validateConnectionManagers) {
        this.validateConnectionManagers = validateConnectionManagers;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public void setTestConnectionsOnTearDown(boolean testConnectionsOnTearDown) {
        this.testConnectionsOnTearDown = testConnectionsOnTearDown;
    }

    public void setUp() {
        this.initializeRuntime();
        logger.debug(System.identityHashCode(this) + " MithraTestResource set up with: " + this.configFileName);
        MithraManager mithraManager = MithraManagerProvider.getMithraManager();
        this.configureTransactionManager(mithraManager);
        for (int i = 0; i < this.mithraRuntimeList.size(); ++i) {
            MithraRuntimeConfig mithraRuntimeConfig = this.mithraRuntimeList.get(i);
            MithraTestConnectionManager connectionManager = (MithraTestConnectionManager)mithraRuntimeConfig.getConnectionManager();
            if (connectionManager == null || this.connectionManagersInUse.contains(connectionManager)) continue;
            this.additionalConnectionManagersInUse.add(connectionManager);
        }
        this.removeRestrictedClassesFromConfig();
        this.setUpDatabases();
        this.setUpPortals();
        try {
            if (this.restrictedClasses != null) {
                UnifiedSet notInUse = UnifiedSet.newSet();
                Iterator<MithraObjectPortal> it = this.portals.iterator();
                while (it.hasNext()) {
                    String classname = MithraTestResource.getClassNameFromFinder(it.next().getFinder());
                    if (this.isUsed(classname)) continue;
                    notInUse.add(classname);
                    it.remove();
                }
                if (!notInUse.isEmpty()) {
                    mithraManager.cleanUpRuntimeCacheControllers((Set)notInUse);
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception during MithraTestResource setup", (Throwable)e);
            throw new RuntimeException("Exception during MithraTestResource setup", e);
        }
        Iterator<List<MithraObject>> it = this.testData.values().iterator();
        while (it.hasNext()) {
            this.insertTestData(it.next());
        }
        mithraManager.loadMithraCache(this.portals, 2);
        this.loadPureObjects();
        this.setSetUpCompleted(true);
    }

    private void setUpPortals() {
        UnifiedMap allPortals = UnifiedMap.newMap();
        for (MithraRuntimeConfig config : this.mithraRuntimeList) {
            for (MithraObjectPortal portal : config.getObjectPortals()) {
                String key = portal.getFinder().getFinderClassName();
                MithraObjectPortal existingPortal = (MithraObjectPortal)allPortals.get(key);
                if (this.validateConnectionManagers && existingPortal != null && !this.portalsHaveSameConnectionManager(portal, existingPortal)) {
                    throw new IllegalStateException(key + " must use same connection managers in all configurations");
                }
                allPortals.put(key, portal);
            }
        }
        this.portals = FastList.newList(allPortals.values());
    }

    private boolean portalsHaveSameConnectionManager(MithraObjectPortal thisPortal, MithraObjectPortal thatPortal) {
        Object thisConnectionManager = MithraTestResource.getConnectionManagerFromPortal(thisPortal);
        Object thatConnectionManager = MithraTestResource.getConnectionManagerFromPortal(thatPortal);
        return thisConnectionManager == null ? thatConnectionManager == null : thisConnectionManager.equals(thatConnectionManager);
    }

    private static Object getConnectionManagerFromPortal(MithraObjectPortal portal) {
        if (portal.getMithraObjectDeserializer() instanceof MithraDatabaseObject) {
            return portal.getDatabaseObject().getConnectionManager();
        }
        return null;
    }

    private void removeRestrictedClassesFromConfig() {
        if (this.restrictedClasses != null) {
            Iterator<String> it = this.configuredObjects.iterator();
            while (it.hasNext()) {
                if (this.isUsed(it.next())) continue;
                it.remove();
            }
        }
    }

    private void addConfigToConfiguredObjects(MithraRuntimeConfig mithraRuntimeConfig) {
        List configs = mithraRuntimeConfig.getConfigs();
        for (MithraConfigurationManager.Config cfg : configs) {
            String className = cfg.getClassName();
            if (!this.isUsed(className)) continue;
            this.configuredObjects.add(className);
        }
    }

    public boolean isConfigured(String className) {
        this.initializeRuntime();
        return this.configuredObjects.contains(className) && this.isUsed(className);
    }

    private void loadPureObjects() {
        if (this.testPureFilesInUse != null) {
            for (int i = 0; i < this.testPureFilesInUse.size(); ++i) {
                this.insertPureParsedData(this.testPureFilesInUse.get(i));
            }
        }
    }

    public void addTestDataForPureObjects(String testDataFilename) {
        this.initializeRuntime();
        TestDataFile testDataFile = (TestDataFile)testDataIndex.get((Object)testDataFilename);
        if (testDataFile == null) {
            MithraTestResource.getLogger().debug("Parsing data file: " + testDataFilename);
            MithraTestDataParser parser = new MithraTestDataParser(testDataFilename);
            parser.setCharset(this.charset);
            List results = parser.getResults();
            MithraTestResource.getLogger().debug("Finished parsing data file: " + testDataFilename);
            testDataFile = new TestDataFile(testDataFilename, (List<MithraParsedData>)results);
            testDataIndex.put((Object)testDataFile);
        }
        if (this.testPureFilesInUse == null) {
            this.testPureFilesInUse = new ArrayList<TestDataFile>();
        }
        this.testPureFilesInUse.add(testDataFile);
    }

    private void insertPureParsedData(TestDataFile testDataFile) {
        List<MithraParsedData> parsedDataList = testDataFile.getParsedData();
        for (int i = 0; i < parsedDataList.size(); ++i) {
            MithraParsedData mithraParsedData = parsedDataList.get(i);
            List attributes = mithraParsedData.getAttributes();
            List dataObjects = mithraParsedData.getDataObjects();
            String currentClassName = mithraParsedData.getParsedClassName();
            if (!this.isConfigured(currentClassName) || dataObjects.size() <= 0) continue;
            String finderClassname = currentClassName + "Finder";
            Method method = MithraTestResource.getMethod(finderClassname, "getMithraObjectPortal", NO_PARAMS);
            MithraObjectPortal mithraObjectPortal = (MithraObjectPortal)MithraTestResource.invokeMethod(method, null, NO_ARGS);
            MithraObjectDeserializer deserializer = mithraObjectPortal.getMithraObjectDeserializer();
            if (deserializer instanceof MithraObjectFactory) {
                for (int j = 0; j < dataObjects.size(); ++j) {
                    mithraObjectPortal.getCache().getObjectFromData((MithraDataObject)dataObjects.get(j));
                }
                continue;
            }
            AsOfAttribute[] asOfAttributes = mithraObjectPortal.getFinder().getAsOfAttributes();
            Timestamp[] timestamp = new Timestamp[asOfAttributes.length];
            for (int j = 0; j < dataObjects.size(); ++j) {
                MithraDataObject data = (MithraDataObject)dataObjects.get(j);
                for (int t = 0; t < asOfAttributes.length; ++t) {
                    timestamp[t] = asOfAttributes[t].isToIsInclusive() ? asOfAttributes[t].getToAttribute().timestampValueOf((Object)data) : asOfAttributes[t].getFromAttribute().timestampValueOf((Object)data);
                }
                mithraObjectPortal.getCache().getObjectFromData(data, timestamp);
            }
        }
        testDataFile.setInserted(true);
    }

    private static Method getMethod(Class underlyingObjectClass, String methodName, Class[] parameterTypes) {
        try {
            return underlyingObjectClass.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            MithraTestResource.getLogger().error("Class " + underlyingObjectClass.getName() + " does not have method " + methodName);
            throw new MithraException("Class " + underlyingObjectClass.getName() + " does not have method " + methodName, (Throwable)e);
        }
    }

    protected static Method getMethod(Object underlyingObject, String methodName, Class[] parameterTypes) {
        return MithraTestResource.getMethod(underlyingObject.getClass(), methodName, parameterTypes);
    }

    protected static Method getMethod(String classname, String methodName, Class[] parameterTypes) {
        try {
            return MithraTestResource.getMethod(Class.forName(classname), methodName, parameterTypes);
        }
        catch (ClassNotFoundException e) {
            MithraTestResource.getLogger().error("Could not find class " + classname);
            throw new MithraException("Could not find class " + classname, (Throwable)e);
        }
    }

    protected static Object invokeMethod(Method method, Object underlyingObject, Object[] arguments) {
        try {
            return method.invoke(underlyingObject, arguments);
        }
        catch (IllegalAccessException e) {
            MithraTestResource.getLogger().error("Could not access method " + method.getName() + " in class " + underlyingObject.getClass().getName());
            throw new MithraException("Could not access method " + method.getName() + " in class " + underlyingObject.getClass().getName(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            MithraTestResource.getLogger().error("Exception during the invocation of " + method.getName() + " in class " + underlyingObject.getClass().getName(), (Throwable)e);
            throw new MithraException("Exception during the invocation of " + method.getName() + " in class " + underlyingObject.getClass().getName(), (Throwable)e);
        }
    }

    private void configureTransactionManager(MithraManager mithraManager) {
        mithraManager.setJtaTransactionManagerProvider((JtaProvider)new DefaultJtaProvider((TransactionManager)new LocalTm()));
    }

    public boolean isUsed(String classname) {
        return this.restrictedClasses == null || this.restrictedClasses.contains(classname);
    }

    private void setSetUpCompleted(boolean setUpCompleted) {
        this.setUpCompleted = setUpCompleted;
    }

    private void setUpDatabases() {
        for (MithraTestConnectionManager connectionManager : this.additionalConnectionManagersInUse) {
            connectionManager.setUpDatabases(this, true);
        }
        for (MithraTestConnectionManager connectionManager : this.connectionManagersInUse) {
            connectionManager.setUpDatabases(this, false);
        }
        this.connectionManagersInUse.addAll(this.additionalConnectionManagersInUse);
    }

    public void tearDown() {
        logger.debug(System.identityHashCode(this) + " MithraTestResource tear down");
        MithraManager mithra = MithraManagerProvider.getMithraManager();
        try {
            while (mithra.isInTransaction()) {
                logger.error("incomplete transaction. attempting rollback");
                mithra.getCurrentTransaction().rollback();
            }
        }
        catch (MithraTransactionException e) {
            logger.error("rollback failed. subsequent tests may cascade fail", (Throwable)e);
        }
        if (this.testConnectionsOnTearDown && !ConnectionManagerForTests.getInstance().ensureAllConnectionsReturnedToPool()) {
            logger.error("all connections were not returned to the pool", (Throwable)new Exception("for tracing"));
        }
        this.tearDownDatabases();
        mithra.cleanUpPrimaryKeyGenerators();
        mithra.cleanUpRuntimeCacheControllers(this.configuredObjects);
        this.databaseObjectPerConnectionManager.clear();
        this.connectionManagersInUse.clear();
        this.tearDownPureObjects();
        this.restrictedClasses = null;
        this.testPureFilesInUse = null;
        this.mithraRuntimeList = null;
        this.configuredObjects.clear();
        this.additionalConnectionManagersInUse.clear();
        this.testDataFilesInUse.clear();
        if (this.portals != null) {
            this.portals.clear();
        }
        MithraReferenceThread.getInstance().runNow();
    }

    private void tearDownPureObjects() {
        if (this.testPureFilesInUse != null) {
            for (int i = 0; i < this.testPureFilesInUse.size(); ++i) {
                List<MithraParsedData> parsedDataList = this.testPureFilesInUse.get(i).getParsedData();
                for (int p = 0; p < parsedDataList.size(); ++p) {
                    MithraParsedData mithraParsedData = parsedDataList.get(p);
                    String className = mithraParsedData.getParsedClassName();
                    try {
                        this.resetPortal(className);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error("Could not tear down portal for class " + className, (Throwable)e);
                    }
                }
            }
        }
    }

    private void tearDownDatabases() {
        for (MithraTestConnectionManager connectionManager : this.connectionManagersInUse) {
            connectionManager.tearDownDatabases(this);
        }
    }

    public void createDatabaseForStringSourceAttributeWithTableSharding(ObjectSourceConnectionManager connectionManager, String sourceAttribute) {
        this.createDatabaseForStringSourceAttribute(connectionManager, sourceAttribute, null, true);
    }

    public void createDatabaseForStringSourceAttributeWithTableSharding(ObjectSourceConnectionManager connectionManager, String sourceAttribute, String testDataFilename) {
        this.createDatabaseForStringSourceAttribute(connectionManager, sourceAttribute, testDataFilename, true);
    }

    public void createDatabaseForStringSourceAttribute(ObjectSourceConnectionManager connectionManager, String sourceAttribute) {
        this.createDatabaseForStringSourceAttribute(connectionManager, sourceAttribute, null, false);
    }

    public void createDatabaseForStringSourceAttribute(ObjectSourceConnectionManager connectionManager, String sourceAttribute, String testDataFilename) {
        this.createDatabaseForStringSourceAttribute(connectionManager, sourceAttribute, testDataFilename, false);
    }

    private void createDatabaseForStringSourceAttribute(ObjectSourceConnectionManager connectionManager, String sourceAttribute, String testDataFilename, boolean isTableSharding) {
        this.initializeRuntime();
        MithraTestConnectionManager testConnectionManager = (MithraTestConnectionManager)connectionManager;
        TestDatabaseConfiguration testDbConfig = this.createTestDbConfig(this.getConnectionManagerIdentifier(testConnectionManager, sourceAttribute, isTableSharding), sourceAttribute, String.class);
        this.createTestDatabase(testDbConfig, testConnectionManager, testDataFilename);
    }

    public void createDatabaseForStringSourceAttribute(ObjectSourceConnectionManager connectionManager, String sourceAttribute, String resourceName, String testDataFilename) {
        this.initializeRuntime();
        TestDatabaseConfiguration testDbConfig = this.createTestDbConfig(resourceName, sourceAttribute, String.class);
        this.createTestDatabase(testDbConfig, (MithraTestConnectionManager)connectionManager, testDataFilename);
    }

    public void createDatabaseForIntSourceAttribute(IntSourceConnectionManager connectionManager, int sourceAttribute) {
        this.createDatabaseForIntSourceAttribute(connectionManager, sourceAttribute, null, false);
    }

    public void createDatabaseForIntSourceAttribute(IntSourceConnectionManager connectionManager, int sourceAttribute, String testDataFilename) {
        this.createDatabaseForIntSourceAttribute(connectionManager, sourceAttribute, testDataFilename, false);
    }

    public void createDatabaseForIntSourceAttributeWithTableSharding(IntSourceConnectionManager connectionManager, int sourceAttribute) {
        this.createDatabaseForIntSourceAttribute(connectionManager, sourceAttribute, null, true);
    }

    public void createDatabaseForIntSourceAttributeWithTableSharding(IntSourceConnectionManager connectionManager, int sourceAttribute, String testDataFilename) {
        this.createDatabaseForIntSourceAttribute(connectionManager, sourceAttribute, testDataFilename, true);
    }

    private void createDatabaseForIntSourceAttribute(IntSourceConnectionManager connectionManager, int sourceAttribute, String testDataFilename, boolean isTableSharding) {
        this.initializeRuntime();
        MithraTestConnectionManager testConnectionManager = (MithraTestConnectionManager)connectionManager;
        TestDatabaseConfiguration testDbConfig = this.createTestDbConfig(this.getConnectionManagerIdentifier(testConnectionManager, sourceAttribute, isTableSharding), sourceAttribute, Integer.TYPE);
        this.createTestDatabase(testDbConfig, testConnectionManager, testDataFilename);
    }

    private String getConnectionManagerIdentifier(MithraTestConnectionManager testConnectionManager, Object sourceAttribute, boolean isTableSharding) {
        return isTableSharding ? testConnectionManager.getConnectionManagerIdentifier() : testConnectionManager.getConnectionManagerIdentifier() + sourceAttribute;
    }

    private TestDatabaseConfiguration createTestDbConfig(String databaseName, Object sourceId, Class type) {
        TestDatabaseConfiguration configuration = new TestDatabaseConfiguration(databaseName, sourceId, type, this.isStrictParsingEnabled);
        configuration.setCharset(this.charset);
        return configuration;
    }

    public void createDatabaseForIntSourceAttribute(IntSourceConnectionManager connectionManager, int sourceAttribute, String resourceName, String testDataFilename) {
        this.initializeRuntime();
        MithraTestConnectionManager testConnectionManager = (MithraTestConnectionManager)connectionManager;
        TestDatabaseConfiguration testDbConfig = this.createTestDbConfig(resourceName, sourceAttribute, Integer.TYPE);
        this.createTestDatabase(testDbConfig, testConnectionManager, testDataFilename);
    }

    public void createSingleDatabase(SourcelessConnectionManager connectionManager) {
        this.createSingleDatabase(connectionManager, null);
    }

    public void createSingleDatabase(SourcelessConnectionManager connectionManager, String testDataFilename) {
        this.initializeRuntime();
        MithraTestConnectionManager testConnectionManager = (MithraTestConnectionManager)connectionManager;
        TestDatabaseConfiguration testDbConfig = this.createTestDbConfig(testConnectionManager.getConnectionManagerIdentifier(), null, null);
        this.createTestDatabase(testDbConfig, testConnectionManager, testDataFilename);
    }

    public void createSingleDatabase(SourcelessConnectionManager connectionManager, URL streamLocation, InputStream is) {
        this.initializeRuntime();
        MithraTestConnectionManager testConnectionManager = (MithraTestConnectionManager)connectionManager;
        TestDatabaseConfiguration testDbConfig = this.createTestDbConfig(testConnectionManager.getConnectionManagerIdentifier(), null, null);
        this.createTestDatabase(testDbConfig, testConnectionManager, streamLocation, is);
    }

    public void createSingleDatabase(SourcelessConnectionManager connectionManager, String resourceName, String testDataFilename) {
        this.initializeRuntime();
        TestDatabaseConfiguration testDbConfig = this.createTestDbConfig(resourceName, null, null);
        this.createTestDatabase(testDbConfig, (MithraTestConnectionManager)connectionManager, testDataFilename);
    }

    private void createTestDatabase(TestDatabaseConfiguration testDbConfig, MithraTestConnectionManager testConnectionManager, String testDataFilename) {
        this.initializeRuntime();
        TestDatabaseConfiguration createdTestDatabaseConfiguration = this.registerDbConfigWithConnectionManager(testDbConfig, testConnectionManager);
        createdTestDatabaseConfiguration.createTables(testConnectionManager, this);
        if (testDataFilename != null) {
            createdTestDatabaseConfiguration.parseTestDataFile(testDataFilename);
            this.testDataFilesInUse.add(testDataFilename);
        }
        testConnectionManager.addTestDbConfiguration(createdTestDatabaseConfiguration);
        this.connectionManagersInUse.add(testConnectionManager);
    }

    private void createTestDatabase(TestDatabaseConfiguration testDbConfig, MithraTestConnectionManager testConnectionManager, URL streamLocation, InputStream is) {
        this.initializeRuntime();
        TestDatabaseConfiguration createdTestDatabaseConfiguration = this.registerDbConfigWithConnectionManager(testDbConfig, testConnectionManager);
        createdTestDatabaseConfiguration.createTables(testConnectionManager, this);
        if (streamLocation != null) {
            createdTestDatabaseConfiguration.parseTestDataStream(streamLocation, is);
            this.testDataFilesInUse.add(streamLocation.toString());
        }
        testConnectionManager.addTestDbConfiguration(createdTestDatabaseConfiguration);
        this.connectionManagersInUse.add(testConnectionManager);
    }

    private TestDatabaseConfiguration registerDbConfigWithConnectionManager(TestDatabaseConfiguration testDbConfig, MithraTestConnectionManager testConnectionManager) {
        TestDatabaseConfiguration createdTestDatabaseConfiguration;
        List<TestDatabaseConfiguration> databasesPerConnectionManager = this.checkDatabasesPerConnectionManagerIfAbsentPutNew(testConnectionManager);
        int index = databasesPerConnectionManager.indexOf(testDbConfig);
        TestDatabaseConfiguration testDatabaseConfiguration = createdTestDatabaseConfiguration = index >= 0 ? databasesPerConnectionManager.get(index) : null;
        if (createdTestDatabaseConfiguration != null) {
            createdTestDatabaseConfiguration.setCharset(this.charset);
        }
        boolean connectionManagerWasNotAlreadyRegistered = testDbConfig.addToConnectionManager(testConnectionManager);
        if (createdTestDatabaseConfiguration == null || createdTestDatabaseConfiguration.isShutdown() || connectionManagerWasNotAlreadyRegistered) {
            if (createdTestDatabaseConfiguration != null) {
                databasesPerConnectionManager.set(index, testDbConfig);
            } else {
                databasesPerConnectionManager.add(testDbConfig);
            }
            createdTestDatabaseConfiguration = testDbConfig;
        }
        return createdTestDatabaseConfiguration;
    }

    public static <T> T findObjectInList(T key, List<T> list) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            T entry = list.get(i);
            if (!entry.equals(key)) continue;
            return entry;
        }
        return null;
    }

    private List<TestDatabaseConfiguration> checkDatabasesPerConnectionManagerIfAbsentPutNew(MithraTestConnectionManager testConnectionManager) {
        List<TestDatabaseConfiguration> databasesPerConnectionManager = configuredDatabasesPerConnectionManager.get(testConnectionManager);
        if (databasesPerConnectionManager == null) {
            databasesPerConnectionManager = new ArrayList<TestDatabaseConfiguration>();
            configuredDatabasesPerConnectionManager.put(testConnectionManager, databasesPerConnectionManager);
        }
        return databasesPerConnectionManager;
    }

    public void loadMithraConfiguration(String mithraConfigXml) {
        MithraRuntimeType runtimeType = this.loadConfigXml(mithraConfigXml);
        this.loadMithraConfiguration(runtimeType);
    }

    public void loadMithraConfiguration(MithraRuntimeType runtimeType) {
        List<MithraRuntimeConfig> runtimeList = this.initializeRuntimeConfig(runtimeType);
        if (this.isSetUpCompleted()) {
            for (int i = 0; i < runtimeList.size(); ++i) {
                MithraRuntimeConfig mithraRuntimeConfig = runtimeList.get(i);
                MithraTestConnectionManager connectionManager = (MithraTestConnectionManager)mithraRuntimeConfig.getConnectionManager();
                if (!this.connectionManagersInUse.contains(connectionManager)) {
                    this.additionalConnectionManagersInUse.add(connectionManager);
                    continue;
                }
                connectionManager.addDatabaseObjectsToTestDatabases(mithraRuntimeConfig.getDatabaseObjects(), this);
            }
        }
    }

    public void addTestDataToDatabase(String testDataFilename, ObjectSourceConnectionManager connectionManager, String sourceAttribute) {
        this.addTestDataToDatabase(testDataFilename, connectionManager, sourceAttribute, false);
    }

    public void addTestDataToDatabaseWithTableSharding(String testDataFilename, ObjectSourceConnectionManager connectionManager, String sourceAttribute) {
        this.addTestDataToDatabase(testDataFilename, connectionManager, sourceAttribute, true);
    }

    private void addTestDataToDatabase(String testDataFilename, ObjectSourceConnectionManager connectionManager, String sourceAttribute, boolean isTableSharding) {
        this.initializeRuntime();
        MithraTestConnectionManager testConnectionManager = (MithraTestConnectionManager)connectionManager;
        TestDatabaseConfiguration testDbConfig = this.createTestDbConfig(this.getConnectionManagerIdentifier(testConnectionManager, sourceAttribute, isTableSharding), sourceAttribute, String.class);
        this.parseTestDataForTestDbConfig(testDataFilename, testDbConfig, testConnectionManager);
    }

    public void addTestDataToDatabase(String testDataFilename, IntSourceConnectionManager connectionManager, int sourceAttribute) {
        this.addTestDataToDatabase(testDataFilename, connectionManager, sourceAttribute, false);
    }

    public void addTestDataToDatabaseWithTableSharding(String testDataFilename, IntSourceConnectionManager connectionManager, int sourceAttribute) {
        this.addTestDataToDatabase(testDataFilename, connectionManager, sourceAttribute, true);
    }

    private void addTestDataToDatabase(String testDataFilename, IntSourceConnectionManager connectionManager, int sourceAttribute, boolean isTableSharding) {
        this.initializeRuntime();
        MithraTestConnectionManager testConnectionManager = (MithraTestConnectionManager)connectionManager;
        TestDatabaseConfiguration testDbConfig = this.createTestDbConfig(this.getConnectionManagerIdentifier(testConnectionManager, sourceAttribute, isTableSharding), sourceAttribute, Integer.TYPE);
        this.parseTestDataForTestDbConfig(testDataFilename, testDbConfig, testConnectionManager);
    }

    public void addTestDataToDatabase(String testDataFilename, SourcelessConnectionManager connectionManager) {
        this.initializeRuntime();
        MithraTestConnectionManager testConnectionManager = (MithraTestConnectionManager)connectionManager;
        TestDatabaseConfiguration testDbConfig = this.createTestDbConfig(testConnectionManager.getConnectionManagerIdentifier(), null, null);
        this.parseTestDataForTestDbConfig(testDataFilename, testDbConfig, testConnectionManager);
        this.testDataFilesInUse.add(testDataFilename);
    }

    public void addTestDataToDatabase(URL streamLocation, InputStream is, ObjectSourceConnectionManager connectionManager, String sourceAttribute) {
        this.addTestDataToDatabase(streamLocation, is, connectionManager, sourceAttribute, false);
    }

    public void addTestDataToDatabaseWithTableSharding(URL streamLocation, InputStream is, ObjectSourceConnectionManager connectionManager, String sourceAttribute) {
        this.addTestDataToDatabase(streamLocation, is, connectionManager, sourceAttribute, true);
    }

    public void addTestDataToDatabase(URL streamLocation, InputStream is, IntSourceConnectionManager connectionManager, int sourceAttribute) {
        this.addTestDataToDatabase(streamLocation, is, connectionManager, sourceAttribute, false);
    }

    public void addTestDataToDatabaseWithTableSharding(URL streamLocation, InputStream is, IntSourceConnectionManager connectionManager, int sourceAttribute) {
        this.addTestDataToDatabase(streamLocation, is, connectionManager, sourceAttribute, true);
    }

    public void addTestDataToDatabase(URL streamLocation, InputStream is, SourcelessConnectionManager connectionManager) {
        this.initializeRuntime();
        MithraTestConnectionManager testConnectionManager = (MithraTestConnectionManager)connectionManager;
        TestDatabaseConfiguration testDbConfig = this.createTestDbConfig(testConnectionManager.getConnectionManagerIdentifier(), null, null);
        this.parseTestDataForTestDbConfig(streamLocation, is, testDbConfig, testConnectionManager);
        this.testDataFilesInUse.add(streamLocation.toString());
    }

    private void addTestDataToDatabase(URL streamLocation, InputStream is, IntSourceConnectionManager connectionManager, int sourceAttribute, boolean isTableSharding) {
        this.initializeRuntime();
        MithraTestConnectionManager testConnectionManager = (MithraTestConnectionManager)connectionManager;
        TestDatabaseConfiguration testDbConfig = this.createTestDbConfig(this.getConnectionManagerIdentifier(testConnectionManager, sourceAttribute, isTableSharding), sourceAttribute, Integer.TYPE);
        this.parseTestDataForTestDbConfig(streamLocation, is, testDbConfig, testConnectionManager);
    }

    private void addTestDataToDatabase(URL streamLocation, InputStream is, ObjectSourceConnectionManager connectionManager, String sourceAttribute, boolean isTableSharding) {
        this.initializeRuntime();
        MithraTestConnectionManager testConnectionManager = (MithraTestConnectionManager)connectionManager;
        TestDatabaseConfiguration testDbConfig = this.createTestDbConfig(this.getConnectionManagerIdentifier(testConnectionManager, sourceAttribute, isTableSharding), sourceAttribute, String.class);
        this.parseTestDataForTestDbConfig(streamLocation, is, testDbConfig, testConnectionManager);
    }

    private void parseTestDataForTestDbConfig(URL streamLocation, InputStream is, TestDatabaseConfiguration testDbConfig, MithraTestConnectionManager connectionManager) {
        TestDatabaseConfiguration configuredTestDbConfig;
        List<TestDatabaseConfiguration> databasesPerConnectionManager = configuredDatabasesPerConnectionManager.get(connectionManager);
        if (databasesPerConnectionManager != null && (configuredTestDbConfig = MithraTestResource.findObjectInList(testDbConfig, databasesPerConnectionManager)) != null) {
            configuredTestDbConfig.parseAndInsertTestData(this, connectionManager, streamLocation, is, this.isSetUpCompleted());
        }
    }

    private void parseTestDataForTestDbConfig(String testDataFilename, TestDatabaseConfiguration testDbConfig, MithraTestConnectionManager connectionManager) {
        TestDatabaseConfiguration configuredTestDbConfig;
        List<TestDatabaseConfiguration> databasesPerConnectionManager = configuredDatabasesPerConnectionManager.get(connectionManager);
        if (databasesPerConnectionManager != null && (configuredTestDbConfig = MithraTestResource.findObjectInList(testDbConfig, databasesPerConnectionManager)) != null) {
            configuredTestDbConfig.parseAndInsertTestData(this, connectionManager, testDataFilename, this.isSetUpCompleted());
        }
    }

    private void parseBcpTestDataForTestDbConfig(String bcpFilename, String delimiter, List<Attribute> attributes, Format dateFormat, TestDatabaseConfiguration testDbConfig, MithraTestConnectionManager connectionManager) {
        TestDatabaseConfiguration configuredTestDbConfig;
        List<TestDatabaseConfiguration> databasesPerConnectionManager = configuredDatabasesPerConnectionManager.get(connectionManager);
        if (databasesPerConnectionManager != null && (configuredTestDbConfig = MithraTestResource.findObjectInList(testDbConfig, databasesPerConnectionManager)) != null) {
            configuredTestDbConfig.parseAndInsertBcpTestData(this, bcpFilename, delimiter, attributes, dateFormat, this.isSetUpCompleted());
        }
    }

    private void resetPortal(String classname) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        Class<?> aClass = Class.forName(classname + "Finder");
        Method method = aClass.getMethod("zResetPortal", NO_PARAMS);
        method.invoke(null, NO_ARGS);
    }

    private static String getClassNameFromFinder(RelatedFinder finder) {
        String classname = finder.getClass().getName();
        int index = classname.indexOf("Finder$");
        classname = classname.substring(0, index);
        return classname;
    }

    private static String getClassNameFromDatabaseObject(MithraDatabaseObject databaseObject) {
        String classname = databaseObject.getClass().getName();
        int index = classname.lastIndexOf("DatabaseObject");
        classname = classname.substring(0, index);
        return classname;
    }

    protected InputStream getConfigXml(String fileName) throws FileNotFoundException {
        String xmlRoot = System.getProperty(ROOT_KEY);
        if (xmlRoot == null) {
            MithraTestResource.getLogger().debug("Could not find mithra.xml.root property. Will attempt to find " + fileName + " in classpath");
            InputStream result = this.getClass().getClassLoader().getResourceAsStream(fileName);
            if (result == null) {
                throw new RuntimeException("could not find " + fileName + " in classpath. Additionally, " + ROOT_KEY + " was not specified");
            }
            return result;
        }
        String fullPath = xmlRoot;
        if (!xmlRoot.endsWith(File.separator)) {
            fullPath = fullPath + File.separator;
        }
        return new FileInputStream(fullPath + fileName);
    }

    private void initializeMithraManager(MithraConfigurationManager manager) {
        MithraManager mithra = MithraManagerProvider.getMithraManager();
        mithra.setTransactionTimeout(60);
        this.initializeMithraManagerConfigManager(mithra, manager);
    }

    protected void initializeMithraManagerConfigManager(MithraManager mithra, MithraConfigurationManager manager) {
        if (manager != null) {
            mithra.setConfigManager(manager);
        } else if (!mithra.getConfigManager().getClass().equals(MithraConfigurationManager.class)) {
            mithra.setConfigManager(new MithraConfigurationManager());
        }
    }

    private MithraRuntimeType loadConfigXml(String configXmlFilename) {
        try {
            MithraRuntimeType runtimeConfig = parsedConfigurations.get(configXmlFilename);
            if (runtimeConfig == null) {
                InputStream mithraXml = this.getConfigXml(configXmlFilename);
                runtimeConfig = MithraManagerProvider.getMithraManager().parseConfiguration(mithraXml);
                mithraXml.close();
                parsedConfigurations.put(configXmlFilename, runtimeConfig);
            }
            return runtimeConfig;
        }
        catch (FileNotFoundException e) {
            logger.error("Cannot find file " + configXmlFilename + " in the classpath", (Throwable)e);
            throw new RuntimeException("Cannot find file " + configXmlFilename + " in the classpath", e);
        }
        catch (IOException e) {
            logger.error("Error while closing InputStream", (Throwable)e);
            throw new RuntimeException("Error while closing InputStream", e);
        }
    }

    private List<MithraRuntimeConfig> initializeRuntimeConfig(MithraRuntimeType runtimeConfig) {
        if (this.isDeleteOnCreate()) {
            runtimeConfig.setDestroyExistingPortal(true);
        }
        List runtimeList = MithraManagerProvider.getMithraManager().initDatabaseObjects(runtimeConfig);
        this.populateDatabaseObjectPerConnectionManagerMap(runtimeList);
        this.mithraRuntimeList.addAll(runtimeList);
        for (MithraRuntimeConfig cfg : runtimeList) {
            this.addConfigToConfiguredObjects(cfg);
        }
        return runtimeList;
    }

    private void populateDatabaseObjectPerConnectionManagerMap(List<MithraRuntimeConfig> mithraRuntimeList) {
        for (int i = 0; i < mithraRuntimeList.size(); ++i) {
            MithraRuntimeConfig runtimeConfig = mithraRuntimeList.get(i);
            List databaseObjectList = runtimeConfig.getDatabaseObjects();
            if (databaseObjectList == null) continue;
            ArrayList databaseObjects = new ArrayList();
            MithraTestConnectionManager connectionManager = (MithraTestConnectionManager)runtimeConfig.getConnectionManager();
            databaseObjects.addAll(databaseObjectList);
            List<MithraDatabaseObject> savedDatabaseObjects = this.databaseObjectPerConnectionManager.get(connectionManager);
            if (savedDatabaseObjects == null) {
                this.databaseObjectPerConnectionManager.put(connectionManager, databaseObjects);
                continue;
            }
            savedDatabaseObjects.addAll(databaseObjects);
        }
    }

    public void setRestrictedClassList(Class[] classList) {
        if (classList != null) {
            this.restrictedClasses = new UnifiedSet(classList.length);
            int length = classList.length;
            for (int i = 0; i < length; ++i) {
                this.restrictedClasses.add(classList[i].getName());
            }
        }
    }

    public static <T> T findObjectInCollection(T key, Collection<T> collection) {
        Iterator<T> it = collection.iterator();
        for (int i = 0; i < collection.size(); ++i) {
            T obj = it.next();
            if (!obj.equals(key)) continue;
            return obj;
        }
        return null;
    }

    public Set<MithraTestConnectionManager> getAdditionalConnectionManagersInUse() {
        return this.additionalConnectionManagersInUse;
    }

    public void loadBcpFile(String bcpFilename, String delimiter, List<Attribute> attributes, String dateFormatString, SourcelessConnectionManager connectionManager) {
        this.loadBcpFile(bcpFilename, delimiter, attributes, connectionManager, dateFormatString != null ? new SimpleDateFormat(dateFormatString) : null);
    }

    public void loadBcpFile(String bcpFilename, String delimiter, List<Attribute> attributes, SourcelessConnectionManager connectionManager, Format dateFormat) {
        this.initializeRuntime();
        MithraTestConnectionManager testConnectionManager = (MithraTestConnectionManager)connectionManager;
        TestDatabaseConfiguration testDbConfig = this.createTestDbConfig(testConnectionManager.getConnectionManagerIdentifier(), null, null);
        this.parseBcpTestDataForTestDbConfig(bcpFilename, delimiter, attributes, dateFormat, testDbConfig, testConnectionManager);
        this.testDataFilesInUse.add(bcpFilename);
    }

    public void loadBcpFile(String bcpFilename, String delimiter, List<Attribute> attributes, String dateFormatString, ObjectSourceConnectionManager connectionManager, String sourceAttribute) {
        this.loadBcpFile(bcpFilename, delimiter, attributes, connectionManager, (Format)(dateFormatString != null ? new SimpleDateFormat(dateFormatString) : null), sourceAttribute);
    }

    public void loadBcpFile(String bcpFilename, String delimiter, List<Attribute> attributes, ObjectSourceConnectionManager connectionManager, Format dateFormat, String sourceAttribute) {
        this.initializeRuntime();
        MithraTestConnectionManager testConnectionManager = (MithraTestConnectionManager)connectionManager;
        TestDatabaseConfiguration testDbConfig = this.createTestDbConfig(testConnectionManager.getConnectionManagerIdentifier() + sourceAttribute, sourceAttribute, String.class);
        this.parseBcpTestDataForTestDbConfig(bcpFilename, delimiter, attributes, dateFormat, testDbConfig, testConnectionManager);
        this.testDataFilesInUse.add(bcpFilename);
    }

    public TestDatabaseConfiguration getDatabaseConfigurationForDatabase(MithraTestConnectionManager connectionManager, String sourceAttribute) {
        return this.getDatabaseConfigurationForDatabase(connectionManager, sourceAttribute, String.class);
    }

    public TestDatabaseConfiguration getDatabaseConfigurationForDatabase(MithraTestConnectionManager connectionManager, Integer sourceAttribute) {
        return this.getDatabaseConfigurationForDatabase(connectionManager, sourceAttribute, Integer.class);
    }

    private TestDatabaseConfiguration getDatabaseConfigurationForDatabase(MithraTestConnectionManager connectionManager, Object sourceAttribute, Class sourceAttributeClass) {
        this.initializeRuntime();
        TestDatabaseConfiguration testDbConfig = sourceAttribute == null ? this.createTestDbConfig(connectionManager.getConnectionManagerIdentifier(), null, null) : this.createTestDbConfig(connectionManager.getConnectionManagerIdentifier() + sourceAttribute, sourceAttribute, sourceAttributeClass);
        List<TestDatabaseConfiguration> databasesPerConnectionManager = configuredDatabasesPerConnectionManager.get(connectionManager);
        return databasesPerConnectionManager == null ? null : MithraTestResource.findObjectInList(testDbConfig, databasesPerConnectionManager);
    }

    public void loadBcpFile(String bcpFilename, String delimiter, List<Attribute> attributes, String dateFormatString, IntSourceConnectionManager connectionManager, int sourceAttribute) {
        this.loadBcpFile(bcpFilename, delimiter, attributes, connectionManager, (Format)(dateFormatString != null ? new SimpleDateFormat(dateFormatString) : null), sourceAttribute);
    }

    public void loadBcpFile(String bcpFilename, String delimiter, List<Attribute> attributes, IntSourceConnectionManager connectionManager, Format dateFormat, int sourceAttribute) {
        this.initializeRuntime();
        MithraTestConnectionManager testConnectionManager = (MithraTestConnectionManager)connectionManager;
        TestDatabaseConfiguration testDbConfig = this.createTestDbConfig(testConnectionManager.getConnectionManagerIdentifier() + sourceAttribute, sourceAttribute, Integer.TYPE);
        this.parseBcpTestDataForTestDbConfig(bcpFilename, delimiter, attributes, dateFormat, testDbConfig, testConnectionManager);
        this.testDataFilesInUse.add(bcpFilename);
    }

    public void insertTestData(List<? extends MithraObject> testDataList) {
        this.initializeRuntime();
        List<MithraDataObject> dataObjects = this.getDataObjectsFromDomainObjects(testDataList);
        MithraObjectPortal portal = dataObjects.get(0).zGetMithraObjectPortal();
        Attribute sourceAttribute = portal.getFinder().getSourceAttribute();
        if (sourceAttribute != null) {
            List<List> segregated = this.segregateBySourceAttribute(dataObjects, sourceAttribute);
            int segregatedSize = segregated.size();
            for (int i = 0; i < segregatedSize; ++i) {
                List segregatedList = segregated.get(i);
                Object source = sourceAttribute.valueOf(segregatedList.get(0));
                this.insertTestData(segregatedList, source);
            }
        } else {
            this.insertTestData(dataObjects, null);
        }
        portal.reloadCache();
    }

    private void insertTestData(List<? extends MithraDataObject> dataObjects, Object source) {
        if (dataObjects != null && !dataObjects.isEmpty()) {
            MithraDataObject firstData = dataObjects.get(0);
            RelatedFinder finder = firstData.zGetMithraObjectPortal().getFinder();
            ((MithraAbstractDatabaseObject)finder.getMithraObjectPortal().getDatabaseObject()).insertData(Arrays.asList(finder.getPersistentAttributes()), dataObjects, source);
            finder.getMithraObjectPortal().clearQueryCache();
        }
    }

    public void collectTestData(MithraObject mithraObject) {
        this.initializeRuntime();
        String clazz = mithraObject.getClass().getName();
        FastList mithraObjectsForClazz = this.testData.get(clazz);
        if (mithraObjectsForClazz == null) {
            mithraObjectsForClazz = FastList.newList();
            this.testData.put(clazz, (List<MithraObject>)mithraObjectsForClazz);
        }
        mithraObjectsForClazz.add(mithraObject);
    }

    private List<MithraDataObject> getDataObjectsFromDomainObjects(List<? extends MithraObject> testDataList) {
        ArrayList<MithraDataObject> dataObjects = new ArrayList<MithraDataObject>(testDataList.size());
        for (int i = 0; i < testDataList.size(); ++i) {
            dataObjects.add(testDataList.get(i).zGetCurrentData());
        }
        return dataObjects;
    }

    protected List<List> segregateBySourceAttribute(List<? extends MithraDataObject> mithraDataObjects, Attribute sourceAttribute) {
        MultiHashMap map = new MultiHashMap();
        for (int i = 0; i < mithraDataObjects.size(); ++i) {
            map.put(sourceAttribute.valueOf((Object)mithraDataObjects.get(i)), (Object)mithraDataObjects.get(i));
        }
        if (map.size() > 1) {
            return map.valuesAsList();
        }
        return ListFactory.create(mithraDataObjects);
    }

    public void createReplicationNotificationTables(ReplicationNotificationConnectionManager replicationNotificationConnectionManager) {
        int i;
        this.initializeRuntime();
        RunsMasterQueueDatabaseObject dbo = (RunsMasterQueueDatabaseObject)RunsMasterQueueFinder.getMithraObjectPortal().getDatabaseObject();
        List connectionManagerList = replicationNotificationConnectionManager.getConnectionManagerList();
        for (i = 0; i < connectionManagerList.size(); ++i) {
            String schemaName;
            Object connectionManager = connectionManagerList.get(i);
            MasterQueueTableMapKey key = new MasterQueueTableMapKey(connectionManager, schemaName = replicationNotificationConnectionManager.getSchema("", i));
            if (masterQueueTableMap.containsKey(key)) continue;
            dbo.createTestTable((Object)i);
            masterQueueTableMap.put(key, (MithraDatabaseObject)dbo);
        }
        for (i = 0; i < replicatedChildQueueTables.size(); ++i) {
            MithraDatabaseObject obj = replicatedChildQueueTables.get(i);
            String className = MithraTestResource.getClassNameFromDatabaseObject(obj);
            if (createdChildQueueTables.containsKey(className)) continue;
            ((MithraReplicatedDatabaseObject)obj).createChildQueueTestTable();
            createdChildQueueTables.put(className, obj);
        }
    }

    public void tearDownReplicationNotificationTables(ReplicationNotificationConnectionManager replicationNotificationConnectionManager) {
        RunsMasterQueueDatabaseObject dbo = (RunsMasterQueueDatabaseObject)RunsMasterQueueFinder.getMithraObjectPortal().getDatabaseObject();
        List connectionManagerList = replicationNotificationConnectionManager.getConnectionManagerList();
        for (int i = 0; i < connectionManagerList.size(); ++i) {
            String schemaName;
            Object connectionManager = connectionManagerList.get(i);
            MasterQueueTableMapKey key = new MasterQueueTableMapKey(connectionManager, schemaName = replicationNotificationConnectionManager.getSchema("", i));
            if (!masterQueueTableMap.containsKey(key)) continue;
            dbo.deleteAllRowsFromTestTable((Object)i);
            for (int j = 0; j < replicatedChildQueueTables.size(); ++j) {
                MithraReplicatedDatabaseObject obj = (MithraReplicatedDatabaseObject)replicatedChildQueueTables.get(j);
                obj.deleteAllReplicationNotificationData();
            }
        }
    }

    private class MasterQueueTableMapKey {
        private final Object connectionManager;
        private final String schemaName;

        public MasterQueueTableMapKey(Object connectionManager, String schemaName) {
            this.connectionManager = connectionManager;
            this.schemaName = schemaName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MasterQueueTableMapKey that = (MasterQueueTableMapKey)o;
            if (!this.connectionManager.equals(that.connectionManager)) {
                return false;
            }
            return !(this.schemaName != null ? !this.schemaName.equals(that.schemaName) : that.schemaName != null);
        }

        public int hashCode() {
            int result = this.connectionManager.hashCode();
            result = 29 * result + (this.schemaName != null ? this.schemaName.hashCode() : 0);
            return result;
        }
    }
}

