/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.sorted.immutable;

import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.set.sorted.ImmutableSortedSet;
import com.gs.collections.api.set.sorted.SortedSetIterable;
import com.gs.collections.impl.UnmodifiableIteratorAdapter;
import com.gs.collections.impl.set.sorted.immutable.AbstractImmutableSortedSet;
import com.gs.collections.impl.set.sorted.mutable.TreeSortedSet;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableTreeSet<T>
extends AbstractImmutableSortedSet<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final TreeSortedSet<T> delegate;

    private ImmutableTreeSet(TreeSortedSet<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean contains(Object object) {
        return this.delegate.contains(object);
    }

    @Override
    public Iterator<T> iterator() {
        return new UnmodifiableIteratorAdapter<T>(this.delegate.iterator());
    }

    public static <T> ImmutableSortedSet<T> newSetWith(T ... elements) {
        return new ImmutableTreeSet<T>(TreeSortedSet.newSetWith(elements));
    }

    public static <T> ImmutableSortedSet<T> newSetWith(Comparator<? super T> comparator, T ... elements) {
        return new ImmutableTreeSet<T>(TreeSortedSet.newSetWith(comparator, elements));
    }

    public static <T> ImmutableSortedSet<T> newSet(SortedSet<T> set) {
        return new ImmutableTreeSet<T>(TreeSortedSet.newSet(set));
    }

    @Override
    public void forEach(Procedure<? super T> procedure) {
        this.delegate.forEach(procedure);
    }

    @Override
    public T first() {
        return this.delegate.first();
    }

    @Override
    public T last() {
        return this.delegate.last();
    }

    @Override
    public Comparator<? super T> comparator() {
        return this.delegate.comparator();
    }

    public int compareTo(SortedSetIterable<T> o) {
        return this.delegate.compareTo(o);
    }
}

