/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.mutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.DoubleSet;
import com.gs.collections.api.set.primitive.ImmutableDoubleSet;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.impl.collection.mutable.primitive.AbstractSynchronizedDoubleCollection;
import com.gs.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableDoubleSet;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class SynchronizedDoubleSet
extends AbstractSynchronizedDoubleCollection
implements MutableDoubleSet {
    private static final long serialVersionUID = 1L;

    SynchronizedDoubleSet(MutableDoubleSet set) {
        super((MutableDoubleCollection)set);
    }

    SynchronizedDoubleSet(MutableDoubleSet set, Object newLock) {
        super((MutableDoubleCollection)set, newLock);
    }

    public static SynchronizedDoubleSet of(MutableDoubleSet set) {
        return new SynchronizedDoubleSet(set);
    }

    public static SynchronizedDoubleSet of(MutableDoubleSet set, Object lock) {
        return new SynchronizedDoubleSet(set, lock);
    }

    @GuardedBy(value="getLock()")
    private MutableDoubleSet getMutableDoubleSet() {
        return (MutableDoubleSet)this.getDoubleCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedDoubleSet without(double element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableDoubleSet().remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedDoubleSet with(double element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableDoubleSet().add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedDoubleSet withAll(DoubleIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableDoubleSet().addAll(elements.toArray());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedDoubleSet withoutAll(DoubleIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableDoubleSet().removeAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleSet select(DoublePredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleSet().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleSet reject(DoublePredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleSet().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableSet<V> collect(DoubleToObjectFunction<? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleSet().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object otherSet) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleSet().equals(otherSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleSet().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyDoubleIterable asLazy() {
        Object object = this.getLock();
        synchronized (object) {
            return new LazyDoubleIterableAdapter((DoubleIterable)this);
        }
    }

    public MutableDoubleSet asUnmodifiable() {
        return new UnmodifiableDoubleSet(this);
    }

    public MutableDoubleSet asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoubleSet freeze() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleSet().freeze();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableDoubleSet toImmutable() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleSet().toImmutable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        Object object = this.getLock();
        synchronized (object) {
            return (T)this.getMutableDoubleSet().injectInto(injectedValue, function);
        }
    }
}

