/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.BooleanFunction0;
import com.gs.collections.api.block.function.primitive.BooleanToBooleanFunction;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.function.primitive.CharToBooleanFunction;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.predicate.primitive.CharBooleanPredicate;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.CharBooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableBooleanCollection;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.iterator.BooleanIterator;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.map.primitive.CharBooleanMap;
import com.gs.collections.api.map.primitive.ImmutableCharBooleanMap;
import com.gs.collections.api.map.primitive.MutableCharBooleanMap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.BooleanSet;
import com.gs.collections.api.set.primitive.CharSet;
import com.gs.collections.api.set.primitive.ImmutableCharSet;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.tuple.primitive.CharBooleanPair;
import com.gs.collections.impl.bag.mutable.primitive.BooleanHashBag;
import com.gs.collections.impl.bag.mutable.primitive.CharHashBag;
import com.gs.collections.impl.block.factory.primitive.CharPredicates;
import com.gs.collections.impl.collection.mutable.primitive.SynchronizedBooleanCollection;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableBooleanCollection;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.BooleanLists;
import com.gs.collections.impl.factory.primitive.CharBooleanMaps;
import com.gs.collections.impl.factory.primitive.CharSets;
import com.gs.collections.impl.lazy.AbstractLazyIterable;
import com.gs.collections.impl.lazy.primitive.CollectCharToObjectIterable;
import com.gs.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import com.gs.collections.impl.lazy.primitive.SelectCharIterable;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.BooleanArrayList;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedCharBooleanMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableCharBooleanMap;
import com.gs.collections.impl.set.mutable.primitive.BooleanHashSet;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedCharSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableCharSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharBooleanHashMap
implements MutableCharBooleanMap,
Externalizable {
    static final boolean EMPTY_VALUE = false;
    private static final long serialVersionUID = 1L;
    private static final char EMPTY_KEY = '\u0000';
    private static final char REMOVED_KEY = '\u0001';
    @Deprecated
    private static final float DEFAULT_LOAD_FACTOR = 0.5f;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private char[] keys;
    private BitSet values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private SentinelValues sentinelValues;

    public CharBooleanHashMap() {
        this.allocateTable(16);
    }

    public CharBooleanHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    public CharBooleanHashMap(CharBooleanMap map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    @Deprecated
    public CharBooleanHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity);
    }

    public MutableCharBooleanMap asUnmodifiable() {
        return new UnmodifiableCharBooleanMap(this);
    }

    public MutableCharBooleanMap asSynchronized() {
        return new SynchronizedCharBooleanMap(this);
    }

    public ImmutableCharBooleanMap toImmutable() {
        return CharBooleanMaps.immutable.withAll((CharBooleanMap)this);
    }

    public static CharBooleanHashMap newWithKeysValues(char key1, boolean value1) {
        return new CharBooleanHashMap(1).withKeyValue(key1, value1);
    }

    public static CharBooleanHashMap newWithKeysValues(char key1, boolean value1, char key2, boolean value2) {
        return new CharBooleanHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static CharBooleanHashMap newWithKeysValues(char key1, boolean value1, char key2, boolean value2, char key3, boolean value3) {
        return new CharBooleanHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static CharBooleanHashMap newWithKeysValues(char key1, boolean value1, char key2, boolean value2, char key3, boolean value3, char key4, boolean value4) {
        return new CharBooleanHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public CharBooleanHashMap withKeyValue(char key1, boolean value1) {
        this.put(key1, value1);
        return this;
    }

    public CharBooleanHashMap withKeysValues(char key1, boolean value1, char key2, boolean value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public CharBooleanHashMap withKeysValues(char key1, boolean value1, char key2, boolean value2, char key3, boolean value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public CharBooleanHashMap withKeysValues(char key1, boolean value1, char key2, boolean value2, char key3, boolean value3, char key4, boolean value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public CharBooleanHashMap withoutKey(char key) {
        this.removeKey(key);
        return this;
    }

    public CharBooleanHashMap withoutAllKeys(CharIterable keys) {
        keys.forEach(new CharProcedure(){

            public void value(char key) {
                CharBooleanHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    private static boolean isEmptyKey(char key) {
        return key == '\u0000';
    }

    private static boolean isRemovedKey(char key) {
        return key == '\u0001';
    }

    private static boolean isNonSentinel(char key) {
        return !CharBooleanHashMap.isEmptyKey(key) && !CharBooleanHashMap.isRemovedKey(key);
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new char[sizeToAllocate];
        this.values = new BitSet(sizeToAllocate);
    }

    public int size() {
        return this.occupiedWithData + (this.sentinelValues == null ? 0 : this.sentinelValues.size());
    }

    public boolean isEmpty() {
        return this.occupiedWithData == 0 && (this.sentinelValues == null || this.sentinelValues.size() == 0);
    }

    public boolean notEmpty() {
        return this.occupiedWithData != 0 || this.sentinelValues != null && this.sentinelValues.size() != 0;
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        char[] old = this.keys;
        BitSet oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!CharBooleanHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues.get(i));
        }
    }

    int probe(char element) {
        int index = this.spread(element);
        char keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == '\u0000') {
            return index;
        }
        int removedIndex = keyAtIndex == '\u0001' ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (this.keys[nextIndex &= this.keys.length - 1] == element) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == '\u0001') {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.keys[nextIndex] == '\u0000') break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(char element) {
        int code = element;
        code ^= 0x3D ^ code >> 16;
        code += code << 3;
        code ^= code >> 4;
        code *= 668265261;
        code ^= code >> 15;
        return code & this.keys.length - 1;
    }

    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, '\u0000');
        this.values.clear();
    }

    public void put(char key, boolean value) {
        if (CharBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return;
        }
        if (CharBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values.set(index, value);
            return;
        }
        this.addKeyValueAtIndex(key, value, index);
    }

    public void putAll(CharBooleanMap map) {
        map.forEachKeyValue(new CharBooleanProcedure(){

            public void value(char key, boolean value) {
                CharBooleanHashMap.this.put(key, value);
            }
        });
    }

    public boolean containsKey(char key) {
        if (CharBooleanHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (CharBooleanHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    public boolean containsValue(boolean value) {
        if (this.sentinelValues != null && this.sentinelValues.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharBooleanHashMap.isNonSentinel(this.keys[i]) || this.values.get(i) != value) continue;
            return true;
        }
        return false;
    }

    public boolean contains(boolean value) {
        return this.containsValue(value);
    }

    public boolean containsAll(boolean ... source) {
        for (boolean each : source) {
            if (this.contains(each)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(BooleanIterable source) {
        return source.allSatisfy(new BooleanPredicate(){

            public boolean accept(boolean value) {
                return CharBooleanHashMap.this.contains(value);
            }
        });
    }

    public boolean get(char key) {
        return this.getIfAbsent(key, false);
    }

    public boolean getIfAbsent(char key, boolean ifAbsent) {
        if (CharBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (CharBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return ifAbsent;
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (CharBooleanHashMap.isNonSentinel(this.keys[index])) {
            return this.values.get(index);
        }
        return ifAbsent;
    }

    public boolean getOrThrow(char key) {
        if (CharBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (CharBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (CharBooleanHashMap.isNonSentinel(this.keys[index])) {
            return this.values.get(index);
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean getIfAbsentPut(char key, boolean value) {
        if (CharBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return value;
        }
        if (CharBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values.get(index);
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public boolean getIfAbsentPut(char key, BooleanFunction0 function) {
        if (CharBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            boolean value = function.value();
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return value;
        }
        if (CharBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            boolean value = function.value();
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values.get(index);
        }
        boolean value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public <P> boolean getIfAbsentPutWith(char key, BooleanFunction<? super P> function, P parameter) {
        if (CharBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.booleanValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            boolean value = function.booleanValueOf(parameter);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return value;
        }
        if (CharBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.booleanValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            boolean value = function.booleanValueOf(parameter);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values.get(index);
        }
        boolean value = function.booleanValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public boolean getIfAbsentPutWithKey(char key, CharToBooleanFunction function) {
        if (CharBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            boolean value = function.valueOf(key);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return value;
        }
        if (CharBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            boolean value = function.valueOf(key);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values.get(index);
        }
        boolean value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public boolean updateValue(char key, boolean initialValueIfAbsent, BooleanToBooleanFunction function) {
        if (CharBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.zeroValue;
        }
        if (CharBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values.set(index, function.valueOf(this.values.get(index)));
            return this.values.get(index);
        }
        boolean value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    private void addKeyValueAtIndex(char key, boolean value, int index) {
        if (this.keys[index] == '\u0001') {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values.set(index, value);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    public void removeKey(char key) {
        if (CharBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = false;
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        if (CharBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = false;
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = '\u0001';
            this.values.set(index, false);
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
        }
    }

    public void remove(char key) {
        this.removeKey(key);
    }

    public boolean removeKeyIfAbsent(char key, boolean value) {
        if (CharBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            boolean oldValue = this.sentinelValues.zeroValue;
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = false;
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        if (CharBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            boolean oldValue = this.sentinelValues.oneValue;
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = false;
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = '\u0001';
            boolean oldValue = this.values.get(index);
            this.values.set(index, false);
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return oldValue;
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CharBooleanMap)) {
            return false;
        }
        CharBooleanMap other = (CharBooleanMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey('\u0000') || other.containsKey('\u0001')) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey('\u0000') || this.sentinelValues.zeroValue != other.getOrThrow('\u0000'))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey('\u0001') || this.sentinelValues.oneValue != other.getOrThrow('\u0001'))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            char key = this.keys[i];
            if (!CharBooleanHashMap.isNonSentinel(key) || other.containsKey(key) && this.values.get(i) == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += 0 ^ (this.sentinelValues.zeroValue ? 1231 : 1237);
            }
            if (this.sentinelValues.containsOneKey) {
                result += 1 ^ (this.sentinelValues.oneValue ? 1231 : 1237);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.keys[i] ^ (this.values.get(i) ? 1231 : 1237);
        }
        return result;
    }

    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append(String.valueOf('\u0000')).append("=").append(String.valueOf(this.sentinelValues.zeroValue));
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(String.valueOf('\u0001')).append("=").append(String.valueOf(this.sentinelValues.oneValue));
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            char key = this.keys[i];
            if (!CharBooleanHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(String.valueOf(key)).append("=").append(String.valueOf(this.values.get(i)));
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public BooleanIterator booleanIterator() {
        return new InternalBooleanIterator();
    }

    public void forEach(BooleanProcedure procedure) {
        this.forEachValue(procedure);
    }

    public void forEachValue(BooleanProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values.get(i));
        }
    }

    public void forEachKey(CharProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value('\u0000');
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value('\u0001');
            }
        }
        for (char key : this.keys) {
            if (!CharBooleanHashMap.isNonSentinel(key)) continue;
            procedure.value(key);
        }
    }

    public void forEachKeyValue(CharBooleanProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value('\u0000', this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value('\u0001', this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values.get(i));
        }
    }

    public CharBooleanHashMap select(CharBooleanPredicate predicate) {
        CharBooleanHashMap result = new CharBooleanHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept('\u0000', this.sentinelValues.zeroValue)) {
                result.put('\u0000', this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept('\u0001', this.sentinelValues.oneValue)) {
                result.put('\u0001', this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharBooleanHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values.get(i))) continue;
            result.put(this.keys[i], this.values.get(i));
        }
        return result;
    }

    public CharBooleanHashMap reject(CharBooleanPredicate predicate) {
        CharBooleanHashMap result = new CharBooleanHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept('\u0000', this.sentinelValues.zeroValue)) {
                result.put('\u0000', this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept('\u0001', this.sentinelValues.oneValue)) {
                result.put('\u0001', this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharBooleanHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values.get(i))) continue;
            result.put(this.keys[i], this.values.get(i));
        }
        return result;
    }

    public <V> V injectInto(V injectedValue, ObjectBooleanToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values.get(i));
        }
        return result;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.sentinelValues != null) {
                if (this.sentinelValues.containsZeroKey) {
                    appendable.append(String.valueOf(this.sentinelValues.zeroValue));
                    first = false;
                }
                if (this.sentinelValues.containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(this.sentinelValues.oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.keys.length; ++i) {
                char key = this.keys[i];
                if (!CharBooleanHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(this.values.get(i)));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MutableBooleanCollection select(BooleanPredicate predicate) {
        BooleanArrayList result = new BooleanArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharBooleanHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values.get(i))) continue;
            result.add(this.values.get(i));
        }
        return result;
    }

    public MutableBooleanCollection reject(BooleanPredicate predicate) {
        BooleanArrayList result = new BooleanArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharBooleanHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values.get(i))) continue;
            result.add(this.values.get(i));
        }
        return result;
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean value) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharBooleanHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values.get(i))) continue;
            return this.values.get(i);
        }
        return value;
    }

    public <V> MutableCollection<V> collect(BooleanToObjectFunction<? extends V> function) {
        FastList target = FastList.newList(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                target.add(function.valueOf(this.sentinelValues.zeroValue));
            }
            if (this.sentinelValues.containsOneKey) {
                target.add(function.valueOf(this.sentinelValues.oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            target.add(function.valueOf(this.values.get(i)));
        }
        return target;
    }

    public int count(BooleanPredicate predicate) {
        int count = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                ++count;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharBooleanHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values.get(i))) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(BooleanPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return true;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharBooleanHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values.get(i))) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(BooleanPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharBooleanHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(BooleanPredicate predicate) {
        return !this.anySatisfy(predicate);
    }

    public boolean[] toArray() {
        boolean[] array = new boolean[this.size()];
        int index = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                array[index] = this.sentinelValues.zeroValue;
                ++index;
            }
            if (this.sentinelValues.containsOneKey) {
                array[index] = this.sentinelValues.oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            array[index] = this.values.get(i);
            ++index;
        }
        return array;
    }

    public MutableBooleanList toList() {
        return BooleanArrayList.newList((BooleanIterable)this);
    }

    public MutableBooleanSet toSet() {
        return BooleanHashSet.newSet((BooleanIterable)this);
    }

    public MutableBooleanBag toBag() {
        return BooleanHashBag.newBag((BooleanIterable)this);
    }

    public LazyBooleanIterable asLazy() {
        return new LazyBooleanIterableAdapter((BooleanIterable)this);
    }

    public LazyCharIterable keysView() {
        return new KeysView();
    }

    public RichIterable<CharBooleanPair> keyValuesView() {
        return new KeyValuesView();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        out.writeFloat(0.5f);
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeChar(0);
                out.writeBoolean(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeChar(1);
                out.writeBoolean(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeChar(this.keys[i]);
            out.writeBoolean(this.values.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        in.readFloat();
        for (int i = 0; i < size; ++i) {
            this.put(in.readChar(), in.readBoolean());
        }
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public MutableCharSet keySet() {
        return new KeySet();
    }

    public MutableBooleanCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ char[] access$902(CharBooleanHashMap x0, char[] x1) {
        x0.keys = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyValuesView
    extends AbstractLazyIterable<CharBooleanPair> {
        private KeyValuesView() {
        }

        public void forEach(Procedure<? super CharBooleanPair> procedure) {
            if (CharBooleanHashMap.this.sentinelValues != null) {
                if (CharBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair('\u0000', CharBooleanHashMap.this.sentinelValues.zeroValue));
                }
                if (CharBooleanHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair('\u0001', CharBooleanHashMap.this.sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < CharBooleanHashMap.this.keys.length; ++i) {
                if (!CharBooleanHashMap.isNonSentinel(CharBooleanHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(CharBooleanHashMap.this.keys[i], CharBooleanHashMap.this.values.get(i)));
            }
        }

        public void forEachWithIndex(ObjectIntProcedure<? super CharBooleanPair> objectIntProcedure) {
            int index = 0;
            if (CharBooleanHashMap.this.sentinelValues != null) {
                if (CharBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair('\u0000', CharBooleanHashMap.this.sentinelValues.zeroValue), index);
                    ++index;
                }
                if (CharBooleanHashMap.this.sentinelValues.containsOneKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair('\u0001', CharBooleanHashMap.this.sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < CharBooleanHashMap.this.keys.length; ++i) {
                if (!CharBooleanHashMap.isNonSentinel(CharBooleanHashMap.this.keys[i])) continue;
                objectIntProcedure.value((Object)PrimitiveTuples.pair(CharBooleanHashMap.this.keys[i], CharBooleanHashMap.this.values.get(i)), index);
                ++index;
            }
        }

        public <P> void forEachWith(Procedure2<? super CharBooleanPair, ? super P> procedure, P parameter) {
            if (CharBooleanHashMap.this.sentinelValues != null) {
                if (CharBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair('\u0000', CharBooleanHashMap.this.sentinelValues.zeroValue), parameter);
                }
                if (CharBooleanHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair('\u0001', CharBooleanHashMap.this.sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < CharBooleanHashMap.this.keys.length; ++i) {
                if (!CharBooleanHashMap.isNonSentinel(CharBooleanHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(CharBooleanHashMap.this.keys[i], CharBooleanHashMap.this.values.get(i)), parameter);
            }
        }

        public Iterator<CharBooleanPair> iterator() {
            return new InternalKeyValuesIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InternalKeyValuesIterator
        implements Iterator<CharBooleanPair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public CharBooleanPair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (CharBooleanHashMap.this.containsKey('\u0000')) {
                        return PrimitiveTuples.pair('\u0000', CharBooleanHashMap.this.sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (CharBooleanHashMap.this.containsKey('\u0001')) {
                        return PrimitiveTuples.pair('\u0001', CharBooleanHashMap.this.sentinelValues.oneValue);
                    }
                }
                char[] keys = CharBooleanHashMap.this.keys;
                while (!CharBooleanHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                CharBooleanPair result = PrimitiveTuples.pair(keys[this.position], CharBooleanHashMap.this.values.get(this.position));
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != CharBooleanHashMap.this.size();
            }
        }
    }

    private class KeySetIterator
    implements CharIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < CharBooleanHashMap.this.size();
        }

        public char next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (CharBooleanHashMap.this.containsKey('\u0000')) {
                    return '\u0000';
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (CharBooleanHashMap.this.containsKey('\u0001')) {
                    return '\u0001';
                }
            }
            char[] keys = CharBooleanHashMap.this.keys;
            while (!CharBooleanHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            char result = keys[this.position];
            ++this.position;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesCollection
    implements MutableBooleanCollection {
        private ValuesCollection() {
        }

        public void clear() {
            CharBooleanHashMap.this.clear();
        }

        public MutableBooleanCollection select(BooleanPredicate predicate) {
            return CharBooleanHashMap.this.select(predicate);
        }

        public MutableBooleanCollection reject(BooleanPredicate predicate) {
            return CharBooleanHashMap.this.reject(predicate);
        }

        public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
            return CharBooleanHashMap.this.detectIfNone(predicate, ifNone);
        }

        public <V> MutableCollection<V> collect(BooleanToObjectFunction<? extends V> function) {
            return CharBooleanHashMap.this.collect(function);
        }

        public MutableBooleanCollection with(boolean element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        public MutableBooleanCollection without(boolean element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        public MutableBooleanCollection withAll(BooleanIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        public MutableBooleanCollection withoutAll(BooleanIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        public MutableBooleanCollection asSynchronized() {
            return SynchronizedBooleanCollection.of(this);
        }

        public MutableBooleanCollection asUnmodifiable() {
            return UnmodifiableBooleanCollection.of(this);
        }

        public ImmutableBooleanCollection toImmutable() {
            return BooleanLists.immutable.withAll((BooleanIterable)this);
        }

        public boolean contains(boolean value) {
            return CharBooleanHashMap.this.containsValue(value);
        }

        public boolean containsAll(boolean ... source) {
            return CharBooleanHashMap.this.containsAll(source);
        }

        public boolean containsAll(BooleanIterable source) {
            return CharBooleanHashMap.this.containsAll(source);
        }

        public MutableBooleanList toList() {
            return CharBooleanHashMap.this.toList();
        }

        public MutableBooleanSet toSet() {
            return CharBooleanHashMap.this.toSet();
        }

        public MutableBooleanBag toBag() {
            return CharBooleanHashMap.this.toBag();
        }

        public LazyBooleanIterable asLazy() {
            return new LazyBooleanIterableAdapter((BooleanIterable)this);
        }

        public <V> V injectInto(V injectedValue, ObjectBooleanToObjectFunction<? super V, ? extends V> function) {
            return CharBooleanHashMap.this.injectInto(injectedValue, function);
        }

        public boolean isEmpty() {
            return CharBooleanHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return CharBooleanHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (CharBooleanHashMap.this.sentinelValues != null) {
                    if (CharBooleanHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(CharBooleanHashMap.this.sentinelValues.zeroValue));
                        first = false;
                    }
                    if (CharBooleanHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(CharBooleanHashMap.this.sentinelValues.oneValue));
                        first = false;
                    }
                }
                for (int i = 0; i < CharBooleanHashMap.this.keys.length; ++i) {
                    char key = CharBooleanHashMap.this.keys[i];
                    if (!CharBooleanHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(CharBooleanHashMap.this.values.get(i)));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public BooleanIterator booleanIterator() {
            return CharBooleanHashMap.this.booleanIterator();
        }

        public void forEach(BooleanProcedure procedure) {
            CharBooleanHashMap.this.forEach(procedure);
        }

        public int count(BooleanPredicate predicate) {
            return CharBooleanHashMap.this.count(predicate);
        }

        public boolean anySatisfy(BooleanPredicate predicate) {
            return CharBooleanHashMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(BooleanPredicate predicate) {
            return CharBooleanHashMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(BooleanPredicate predicate) {
            return CharBooleanHashMap.this.noneSatisfy(predicate);
        }

        public boolean add(boolean element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(boolean ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(BooleanIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean remove(boolean item) {
            int oldSize = CharBooleanHashMap.this.size();
            if (CharBooleanHashMap.this.sentinelValues != null) {
                if (CharBooleanHashMap.this.sentinelValues.containsZeroKey && item == CharBooleanHashMap.this.sentinelValues.zeroValue) {
                    CharBooleanHashMap.this.removeKey('\u0000');
                }
                if (CharBooleanHashMap.this.sentinelValues.containsOneKey && item == CharBooleanHashMap.this.sentinelValues.oneValue) {
                    CharBooleanHashMap.this.removeKey('\u0001');
                }
            }
            for (int i = 0; i < CharBooleanHashMap.this.keys.length; ++i) {
                if (!CharBooleanHashMap.isNonSentinel(CharBooleanHashMap.this.keys[i]) || item != CharBooleanHashMap.this.values.get(i)) continue;
                CharBooleanHashMap.this.removeKey(CharBooleanHashMap.this.keys[i]);
            }
            return oldSize != CharBooleanHashMap.this.size();
        }

        public boolean removeAll(BooleanIterable source) {
            int oldSize = CharBooleanHashMap.this.size();
            BooleanIterator iterator = source.booleanIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != CharBooleanHashMap.this.size();
        }

        public boolean removeAll(boolean ... source) {
            int oldSize = CharBooleanHashMap.this.size();
            for (boolean item : source) {
                this.remove(item);
            }
            return oldSize != CharBooleanHashMap.this.size();
        }

        public boolean retainAll(BooleanIterable source) {
            int oldSize = CharBooleanHashMap.this.size();
            Object sourceSet = source instanceof BooleanSet ? (BooleanSet)source : source.toSet();
            CharBooleanHashMap retained = CharBooleanHashMap.this.select(new CharBooleanPredicate((BooleanSet)sourceSet){
                final /* synthetic */ BooleanSet val$sourceSet;
                {
                    this.val$sourceSet = booleanSet;
                }

                public boolean accept(char key, boolean value) {
                    return this.val$sourceSet.contains(value);
                }
            });
            if (retained.size() != oldSize) {
                CharBooleanHashMap.access$902(CharBooleanHashMap.this, retained.keys);
                CharBooleanHashMap.this.values = retained.values;
                CharBooleanHashMap.this.occupiedWithData = retained.occupiedWithData;
                CharBooleanHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                CharBooleanHashMap.this.sentinelValues = retained.sentinelValues;
                return true;
            }
            return false;
        }

        public boolean retainAll(boolean ... source) {
            return this.retainAll((BooleanIterable)BooleanHashSet.newSetWith(source));
        }

        public int size() {
            return CharBooleanHashMap.this.size();
        }

        public boolean[] toArray() {
            return CharBooleanHashMap.this.toArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    implements MutableCharSet {
        private KeySet() {
        }

        public CharIterator charIterator() {
            return new KeySetIterator();
        }

        public void forEach(CharProcedure procedure) {
            CharBooleanHashMap.this.forEachKey(procedure);
        }

        public int count(CharPredicate predicate) {
            int count = 0;
            if (CharBooleanHashMap.this.sentinelValues != null) {
                if (CharBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    ++count;
                }
                if (CharBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    ++count;
                }
            }
            for (char key : CharBooleanHashMap.this.keys) {
                if (!CharBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(CharPredicate predicate) {
            if (CharBooleanHashMap.this.sentinelValues != null) {
                if (CharBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    return true;
                }
                if (CharBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    return true;
                }
            }
            for (char key : CharBooleanHashMap.this.keys) {
                if (!CharBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(CharPredicate predicate) {
            if (CharBooleanHashMap.this.sentinelValues != null) {
                if (CharBooleanHashMap.this.sentinelValues.containsZeroKey && !predicate.accept('\u0000')) {
                    return false;
                }
                if (CharBooleanHashMap.this.sentinelValues.containsOneKey && !predicate.accept('\u0001')) {
                    return false;
                }
            }
            for (char key : CharBooleanHashMap.this.keys) {
                if (!CharBooleanHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(CharPredicate predicate) {
            if (CharBooleanHashMap.this.sentinelValues != null) {
                if (CharBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    return false;
                }
                if (CharBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    return false;
                }
            }
            for (char key : CharBooleanHashMap.this.keys) {
                if (!CharBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean add(char element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(char ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(CharIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean remove(char key) {
            int oldSize = CharBooleanHashMap.this.size();
            CharBooleanHashMap.this.removeKey(key);
            return oldSize != CharBooleanHashMap.this.size();
        }

        public boolean removeAll(CharIterable source) {
            int oldSize = CharBooleanHashMap.this.size();
            CharIterator iterator = source.charIterator();
            while (iterator.hasNext()) {
                CharBooleanHashMap.this.removeKey(iterator.next());
            }
            return oldSize != CharBooleanHashMap.this.size();
        }

        public boolean removeAll(char ... source) {
            int oldSize = CharBooleanHashMap.this.size();
            for (char item : source) {
                CharBooleanHashMap.this.removeKey(item);
            }
            return oldSize != CharBooleanHashMap.this.size();
        }

        public boolean retainAll(CharIterable source) {
            int oldSize = CharBooleanHashMap.this.size();
            Object sourceSet = source instanceof CharSet ? (CharSet)source : source.toSet();
            CharBooleanHashMap retained = CharBooleanHashMap.this.select(new CharBooleanPredicate((CharSet)sourceSet){
                final /* synthetic */ CharSet val$sourceSet;
                {
                    this.val$sourceSet = charSet;
                }

                public boolean accept(char key, boolean value) {
                    return this.val$sourceSet.contains(key);
                }
            });
            if (retained.size() != oldSize) {
                CharBooleanHashMap.access$902(CharBooleanHashMap.this, retained.keys);
                CharBooleanHashMap.this.values = retained.values;
                CharBooleanHashMap.this.occupiedWithData = retained.occupiedWithData;
                CharBooleanHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                CharBooleanHashMap.this.sentinelValues = retained.sentinelValues;
                return true;
            }
            return false;
        }

        public boolean retainAll(char ... source) {
            return this.retainAll((CharIterable)CharHashSet.newSetWith(source));
        }

        public void clear() {
            CharBooleanHashMap.this.clear();
        }

        public MutableCharSet select(CharPredicate predicate) {
            CharHashSet result = new CharHashSet();
            if (CharBooleanHashMap.this.sentinelValues != null) {
                if (CharBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    result.add('\u0000');
                }
                if (CharBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    result.add('\u0001');
                }
            }
            for (char key : CharBooleanHashMap.this.keys) {
                if (!CharBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableCharSet reject(CharPredicate predicate) {
            CharHashSet result = new CharHashSet();
            if (CharBooleanHashMap.this.sentinelValues != null) {
                if (CharBooleanHashMap.this.sentinelValues.containsZeroKey && !predicate.accept('\u0000')) {
                    result.add('\u0000');
                }
                if (CharBooleanHashMap.this.sentinelValues.containsOneKey && !predicate.accept('\u0001')) {
                    result.add('\u0001');
                }
            }
            for (char key : CharBooleanHashMap.this.keys) {
                if (!CharBooleanHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableCharSet with(char element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        public MutableCharSet without(char element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        public MutableCharSet withAll(CharIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        public MutableCharSet withoutAll(CharIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        public char detectIfNone(CharPredicate predicate, char ifNone) {
            if (CharBooleanHashMap.this.sentinelValues != null) {
                if (CharBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    return '\u0000';
                }
                if (CharBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    return '\u0001';
                }
            }
            for (char key : CharBooleanHashMap.this.keys) {
                if (!CharBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return ifNone;
        }

        public <V> MutableSet<V> collect(CharToObjectFunction<? extends V> function) {
            MutableSet result = Sets.mutable.with();
            if (CharBooleanHashMap.this.sentinelValues != null) {
                if (CharBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    result.add(function.valueOf('\u0000'));
                }
                if (CharBooleanHashMap.this.sentinelValues.containsOneKey) {
                    result.add(function.valueOf('\u0001'));
                }
            }
            for (char key : CharBooleanHashMap.this.keys) {
                if (!CharBooleanHashMap.isNonSentinel(key)) continue;
                result.add(function.valueOf(key));
            }
            return result;
        }

        public MutableCharSet asUnmodifiable() {
            return UnmodifiableCharSet.of(this);
        }

        public MutableCharSet asSynchronized() {
            return SynchronizedCharSet.of(this);
        }

        public long sum() {
            long sum = 0L;
            if (CharBooleanHashMap.this.sentinelValues != null) {
                if (CharBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    sum += 0L;
                }
                if (CharBooleanHashMap.this.sentinelValues.containsOneKey) {
                    ++sum;
                }
            }
            for (char key : CharBooleanHashMap.this.keys) {
                if (!CharBooleanHashMap.isNonSentinel(key)) continue;
                sum += (long)key;
            }
            return sum;
        }

        public char max() {
            if (CharBooleanHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            char max = '\u0000';
            boolean isMaxSet = false;
            if (CharBooleanHashMap.this.sentinelValues != null) {
                if (CharBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    max = '\u0000';
                    isMaxSet = true;
                }
                if (CharBooleanHashMap.this.sentinelValues.containsOneKey && (!isMaxSet || max < '\u0001')) {
                    max = '\u0001';
                    isMaxSet = true;
                }
            }
            for (int i = 0; i < CharBooleanHashMap.this.keys.length; ++i) {
                if (!CharBooleanHashMap.isNonSentinel(CharBooleanHashMap.this.keys[i]) || isMaxSet && max >= CharBooleanHashMap.this.keys[i]) continue;
                max = CharBooleanHashMap.this.keys[i];
                isMaxSet = true;
            }
            return max;
        }

        public char maxIfEmpty(char defaultValue) {
            if (CharBooleanHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public char min() {
            if (CharBooleanHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            char min = '\u0000';
            boolean isMinSet = false;
            if (CharBooleanHashMap.this.sentinelValues != null) {
                if (CharBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    min = '\u0000';
                    isMinSet = true;
                }
                if (CharBooleanHashMap.this.sentinelValues.containsOneKey && (!isMinSet || '\u0001' < min)) {
                    min = '\u0001';
                    isMinSet = true;
                }
            }
            for (int i = 0; i < CharBooleanHashMap.this.keys.length; ++i) {
                if (!CharBooleanHashMap.isNonSentinel(CharBooleanHashMap.this.keys[i]) || isMinSet && CharBooleanHashMap.this.keys[i] >= min) continue;
                min = CharBooleanHashMap.this.keys[i];
                isMinSet = true;
            }
            return min;
        }

        public char minIfEmpty(char defaultValue) {
            if (CharBooleanHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            char[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                char first = sortedArray[middleIndex];
                char second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public char[] toSortedArray() {
            char[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableCharList toSortedList() {
            return CharArrayList.newList((CharIterable)this).sortThis();
        }

        public char[] toArray() {
            int size = CharBooleanHashMap.this.size();
            final char[] result = new char[size];
            CharBooleanHashMap.this.forEachKey(new CharProcedure(){
                private int index;

                public void value(char each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public boolean contains(char value) {
            return CharBooleanHashMap.this.containsKey(value);
        }

        public boolean containsAll(char ... source) {
            for (char item : source) {
                if (CharBooleanHashMap.this.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(CharIterable source) {
            CharIterator iterator = source.charIterator();
            while (iterator.hasNext()) {
                if (CharBooleanHashMap.this.containsKey(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public MutableCharList toList() {
            return CharArrayList.newList((CharIterable)this);
        }

        public MutableCharSet toSet() {
            return CharHashSet.newSet((CharIterable)this);
        }

        public MutableCharBag toBag() {
            return CharHashBag.newBag((CharIterable)this);
        }

        public LazyCharIterable asLazy() {
            return new LazyCharIterableAdapter((CharIterable)this);
        }

        public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (CharBooleanHashMap.this.sentinelValues != null) {
                if (CharBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, '\u0000');
                }
                if (CharBooleanHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, '\u0001');
                }
            }
            for (int i = 0; i < CharBooleanHashMap.this.keys.length; ++i) {
                if (!CharBooleanHashMap.isNonSentinel(CharBooleanHashMap.this.keys[i])) continue;
                result = function.valueOf(result, CharBooleanHashMap.this.keys[i]);
            }
            return result;
        }

        public CharSet freeze() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".freeze() not implemented yet");
        }

        public ImmutableCharSet toImmutable() {
            return CharSets.immutable.withAll((CharIterable)this);
        }

        public int size() {
            return CharBooleanHashMap.this.size();
        }

        public boolean isEmpty() {
            return CharBooleanHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return CharBooleanHashMap.this.notEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CharSet)) {
                return false;
            }
            CharSet other = (CharSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            int result = 0;
            if (CharBooleanHashMap.this.sentinelValues != null) {
                if (CharBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0;
                }
                if (CharBooleanHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (int i = 0; i < CharBooleanHashMap.this.keys.length; ++i) {
                if (!CharBooleanHashMap.isNonSentinel(CharBooleanHashMap.this.keys[i])) continue;
                result += CharBooleanHashMap.this.keys[i];
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (CharBooleanHashMap.this.sentinelValues != null) {
                    if (CharBooleanHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf('\u0000'));
                        first = false;
                    }
                    if (CharBooleanHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf('\u0001'));
                        first = false;
                    }
                }
                for (char key : CharBooleanHashMap.this.keys) {
                    if (!CharBooleanHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeysView
    implements LazyCharIterable {
        private KeysView() {
        }

        public boolean isEmpty() {
            return CharBooleanHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return CharBooleanHashMap.this.notEmpty();
        }

        public int size() {
            return CharBooleanHashMap.this.size();
        }

        public boolean contains(char key) {
            return CharBooleanHashMap.this.containsKey(key);
        }

        public boolean containsAll(char ... keys) {
            for (char key : keys) {
                if (CharBooleanHashMap.this.containsKey(key)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(CharIterable source) {
            return source.allSatisfy(new CharPredicate(){

                public boolean accept(char key) {
                    return CharBooleanHashMap.this.containsKey(key);
                }
            });
        }

        public CharIterator charIterator() {
            return new KeySetIterator();
        }

        public void forEach(CharProcedure procedure) {
            CharBooleanHashMap.this.forEachKey(procedure);
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (CharBooleanHashMap.this.sentinelValues != null) {
                    if (CharBooleanHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf('\u0000'));
                        first = false;
                    }
                    if (CharBooleanHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf('\u0001'));
                        first = false;
                    }
                }
                for (char key : CharBooleanHashMap.this.keys) {
                    if (!CharBooleanHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public int count(CharPredicate predicate) {
            int count = 0;
            if (CharBooleanHashMap.this.sentinelValues != null) {
                if (CharBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    ++count;
                }
                if (CharBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    ++count;
                }
            }
            for (char key : CharBooleanHashMap.this.keys) {
                if (!CharBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(CharPredicate predicate) {
            if (CharBooleanHashMap.this.sentinelValues != null) {
                if (CharBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    return true;
                }
                if (CharBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    return true;
                }
            }
            for (char key : CharBooleanHashMap.this.keys) {
                if (!CharBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(CharPredicate predicate) {
            if (CharBooleanHashMap.this.sentinelValues != null) {
                if (CharBooleanHashMap.this.sentinelValues.containsZeroKey && !predicate.accept('\u0000')) {
                    return false;
                }
                if (CharBooleanHashMap.this.sentinelValues.containsOneKey && !predicate.accept('\u0001')) {
                    return false;
                }
            }
            for (char key : CharBooleanHashMap.this.keys) {
                if (!CharBooleanHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(CharPredicate predicate) {
            return !this.anySatisfy(predicate);
        }

        public LazyCharIterable select(CharPredicate predicate) {
            return new SelectCharIterable((CharIterable)this, predicate);
        }

        public LazyCharIterable reject(CharPredicate predicate) {
            return new SelectCharIterable((CharIterable)this, CharPredicates.not(predicate));
        }

        public char detectIfNone(CharPredicate predicate, char value) {
            if (CharBooleanHashMap.this.sentinelValues != null) {
                if (CharBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    return '\u0000';
                }
                if (CharBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    return '\u0001';
                }
            }
            for (char key : CharBooleanHashMap.this.keys) {
                if (!CharBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return value;
        }

        public <V> LazyIterable<V> collect(CharToObjectFunction<? extends V> function) {
            return new CollectCharToObjectIterable<V>((CharIterable)this, function);
        }

        public long sum() {
            long result = 0L;
            if (CharBooleanHashMap.this.sentinelValues != null) {
                if (CharBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0L;
                }
                if (CharBooleanHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (char key : CharBooleanHashMap.this.keys) {
                if (!CharBooleanHashMap.isNonSentinel(key)) continue;
                result += (long)key;
            }
            return result;
        }

        public char max() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            CharIterator iterator = this.charIterator();
            char max = iterator.next();
            while (iterator.hasNext()) {
                char value = iterator.next();
                if (max >= value) continue;
                max = value;
            }
            return max;
        }

        public char min() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            CharIterator iterator = this.charIterator();
            char min = iterator.next();
            while (iterator.hasNext()) {
                char value = iterator.next();
                if (value >= min) continue;
                min = value;
            }
            return min;
        }

        public char minIfEmpty(char defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public char maxIfEmpty(char defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            char[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                char first = sortedArray[middleIndex];
                char second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public char[] toSortedArray() {
            char[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public char[] toArray() {
            int size = CharBooleanHashMap.this.size();
            final char[] result = new char[size];
            CharBooleanHashMap.this.forEachKey(new CharProcedure(){
                private int index;

                public void value(char each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (CharBooleanHashMap.this.sentinelValues != null) {
                if (CharBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, '\u0000');
                }
                if (CharBooleanHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, '\u0001');
                }
            }
            for (int i = 0; i < CharBooleanHashMap.this.keys.length; ++i) {
                if (!CharBooleanHashMap.isNonSentinel(CharBooleanHashMap.this.keys[i])) continue;
                result = function.valueOf(result, CharBooleanHashMap.this.keys[i]);
            }
            return result;
        }

        public MutableCharList toList() {
            return CharArrayList.newList((CharIterable)this);
        }

        public MutableCharList toSortedList() {
            return CharArrayList.newList((CharIterable)this).sortThis();
        }

        public MutableCharSet toSet() {
            return CharHashSet.newSet((CharIterable)this);
        }

        public MutableCharBag toBag() {
            return CharHashBag.newBag((CharIterable)this);
        }

        public LazyCharIterable asLazy() {
            return this;
        }
    }

    private class InternalBooleanIterator
    implements BooleanIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalBooleanIterator() {
        }

        public boolean hasNext() {
            return this.count < CharBooleanHashMap.this.size();
        }

        public boolean next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (CharBooleanHashMap.this.containsKey('\u0000')) {
                    return CharBooleanHashMap.this.sentinelValues.zeroValue;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (CharBooleanHashMap.this.containsKey('\u0001')) {
                    return CharBooleanHashMap.this.sentinelValues.oneValue;
                }
            }
            char[] keys = CharBooleanHashMap.this.keys;
            while (!CharBooleanHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            boolean result = CharBooleanHashMap.this.values.get(this.position);
            ++this.position;
            return result;
        }
    }

    private static final class SentinelValues {
        private boolean containsZeroKey;
        private boolean containsOneKey;
        private boolean zeroValue;
        private boolean oneValue;

        private SentinelValues() {
        }

        public int size() {
            return (this.containsZeroKey ? 1 : 0) + (this.containsOneKey ? 1 : 0);
        }

        public boolean containsValue(boolean value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && this.zeroValue == value;
            boolean valueEqualsOneValue = this.containsOneKey && this.oneValue == value;
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }
}

