/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.impl.bag.mutable.primitive.ShortHashBag;
import com.gs.collections.impl.block.factory.primitive.ShortPredicates;
import com.gs.collections.impl.factory.primitive.ShortSets;
import com.gs.collections.impl.list.mutable.primitive.ShortArrayList;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;
import com.gs.collections.impl.utility.internal.primitive.ShortIterableIterate;
import com.gs.collections.impl.utility.primitive.LazyShortIterate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLazyShortIterable
implements LazyShortIterable {
    public int size() {
        return this.count(ShortPredicates.alwaysTrue());
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public boolean isEmpty() {
        return ShortIterableIterate.isEmpty((ShortIterable)this);
    }

    public boolean notEmpty() {
        return ShortIterableIterate.notEmpty((ShortIterable)this);
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        ShortIterableIterate.appendString((ShortIterable)this, appendable, start, separator, end);
    }

    public boolean contains(short value) {
        return this.anySatisfy(ShortPredicates.equal(value));
    }

    public boolean containsAll(short ... source) {
        return this.containsAll((ShortIterable)ShortSets.immutable.of(source));
    }

    public boolean containsAll(ShortIterable source) {
        return source.allSatisfy(new ShortPredicate(){

            public boolean accept(short value) {
                return AbstractLazyShortIterable.this.contains(value);
            }
        });
    }

    public LazyShortIterable select(ShortPredicate predicate) {
        return LazyShortIterate.select((ShortIterable)this, predicate);
    }

    public LazyShortIterable reject(ShortPredicate predicate) {
        return LazyShortIterate.select((ShortIterable)this, ShortPredicates.not(predicate));
    }

    public <V> LazyIterable<V> collect(ShortToObjectFunction<? extends V> function) {
        return LazyShortIterate.collect((ShortIterable)this, function);
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        return ShortIterableIterate.detectIfNone((ShortIterable)this, predicate, ifNone);
    }

    public int count(ShortPredicate predicate) {
        return ShortIterableIterate.count((ShortIterable)this, predicate);
    }

    public boolean anySatisfy(ShortPredicate predicate) {
        return ShortIterableIterate.anySatisfy((ShortIterable)this, predicate);
    }

    public boolean allSatisfy(ShortPredicate predicate) {
        return ShortIterableIterate.allSatisfy((ShortIterable)this, predicate);
    }

    public boolean noneSatisfy(ShortPredicate predicate) {
        return ShortIterableIterate.noneSatisfy((ShortIterable)this, predicate);
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        return ShortIterableIterate.injectInto((ShortIterable)this, injectedValue, function);
    }

    public long sum() {
        return ShortIterableIterate.sum((ShortIterable)this);
    }

    public short max() {
        return ShortIterableIterate.max((ShortIterable)this);
    }

    public short maxIfEmpty(short ifEmpty) {
        return ShortIterableIterate.maxIfEmpty((ShortIterable)this, ifEmpty);
    }

    public short min() {
        return ShortIterableIterate.min((ShortIterable)this);
    }

    public short minIfEmpty(short ifEmpty) {
        return ShortIterableIterate.minIfEmpty((ShortIterable)this, ifEmpty);
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        short[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            short first = sortedArray[middleIndex];
            short second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public short[] toSortedArray() {
        return this.toSortedList().toArray();
    }

    public MutableShortList toSortedList() {
        return ShortArrayList.newList((ShortIterable)this).sortThis();
    }

    public short[] toArray() {
        return this.toList().toArray();
    }

    public MutableShortList toList() {
        final ShortArrayList list = new ShortArrayList();
        this.forEach(new ShortProcedure(){

            public void value(short each) {
                list.add(each);
            }
        });
        return list;
    }

    public MutableShortSet toSet() {
        final ShortHashSet set = new ShortHashSet();
        this.forEach(new ShortProcedure(){

            public void value(short each) {
                set.add(each);
            }
        });
        return set;
    }

    public MutableShortBag toBag() {
        final ShortHashBag bag = new ShortHashBag();
        this.forEach(new ShortProcedure(){

            public void value(short each) {
                bag.add(each);
            }
        });
        return bag;
    }

    public LazyShortIterable asLazy() {
        return this;
    }
}

