/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.mutable.primitive;

import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LongIterable;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.bag.primitive.ImmutableLongBag;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.procedure.primitive.LongIntProcedure;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.impl.bag.mutable.primitive.UnmodifiableLongBag;
import com.gs.collections.impl.collection.mutable.primitive.AbstractSynchronizedLongCollection;
import com.gs.collections.impl.factory.primitive.LongBags;
import com.gs.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class SynchronizedLongBag
extends AbstractSynchronizedLongCollection
implements MutableLongBag {
    private static final long serialVersionUID = 1L;

    SynchronizedLongBag(MutableLongBag bag) {
        super((MutableLongCollection)bag);
    }

    SynchronizedLongBag(MutableLongBag bag, Object newLock) {
        super((MutableLongCollection)bag, newLock);
    }

    @GuardedBy(value="getLock()")
    private MutableLongBag getMutableLongBag() {
        return (MutableLongBag)this.getLongCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedLongBag with(long element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableLongBag().add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedLongBag without(long element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableLongBag().remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedLongBag withAll(LongIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableLongBag().addAll(elements.toArray());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedLongBag withoutAll(LongIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableLongBag().removeAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOccurrences(long item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableLongBag().addOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeOccurrences(long item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongBag().removeOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeDistinct() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongBag().sizeDistinct();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int occurrencesOf(long item) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongBag().occurrencesOf(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachWithOccurrences(LongIntProcedure procedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableLongBag().forEachWithOccurrences(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableLongBag select(LongPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongBag().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableLongBag reject(LongPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongBag().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableBag<V> collect(LongToObjectFunction<? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongBag().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object otherBag) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongBag().equals(otherBag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongBag().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyLongIterable asLazy() {
        Object object = this.getLock();
        synchronized (object) {
            return new LazyLongIterableAdapter((LongIterable)this);
        }
    }

    public MutableLongBag asUnmodifiable() {
        return new UnmodifiableLongBag(this);
    }

    public MutableLongBag asSynchronized() {
        return this;
    }

    public ImmutableLongBag toImmutable() {
        return LongBags.immutable.withAll((LongIterable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        Object object = this.getLock();
        synchronized (object) {
            return (T)this.getMutableLongBag().injectInto(injectedValue, function);
        }
    }
}

