/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.set.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.set.MutableSet;

/**
 * This file was automatically generated from template file mutablePrimitiveSet.stg.
 *
 * @since 3.0.
 */
public interface MutableCharSet extends MutableCharCollection, CharSet
{
    MutableCharSet select(CharPredicate predicate);

    MutableCharSet reject(CharPredicate predicate);

    <V> MutableSet<V> collect(CharToObjectFunction<? extends V> function);

    MutableCharSet with(char element);

    MutableCharSet without(char element);

    MutableCharSet withAll(CharIterable elements);

    MutableCharSet withoutAll(CharIterable elements);

    MutableCharSet asUnmodifiable();

    MutableCharSet asSynchronized();

    /**
     * Returns a frozen copy of this set. A frozen copy is the same thing as an immutable copy without safe-publish guarantees.
     */
    CharSet freeze();

    /**
     * Returns an immutable copy of this set.
     */
    ImmutableCharSet toImmutable();
}
