/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.IntFunction0;
import com.gs.collections.api.block.function.primitive.IntToIntFunction;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.predicate.primitive.ObjectIntPredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;

/**
 * This file was automatically generated from template file mutableObjectPrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableObjectIntMap<K> extends ObjectIntMap<K>
{
    void clear();

    void put(K key, int value);

    void putAll(ObjectIntMap<? extends K> map);

    void removeKey(K key);

    void remove(Object key);

    int removeKeyIfAbsent(K key, int value);

    int getIfAbsentPut(K key, int value);

    int getIfAbsentPut(K key, IntFunction0 function);

    int getIfAbsentPutWithKey(K key, IntFunction<? super K> function);

    <P> int getIfAbsentPutWith(K key, IntFunction<? super P> function, P parameter);

    int updateValue(K key, int initialValueIfAbsent, IntToIntFunction function);

    MutableObjectIntMap<K> select(ObjectIntPredicate<? super K> predicate);

    MutableObjectIntMap<K> reject(ObjectIntPredicate<? super K> predicate);

    MutableIntCollection select(IntPredicate predicate);

    MutableIntCollection reject(IntPredicate predicate);

    <V> MutableCollection<V> collect(IntToObjectFunction<? extends V> function);

    MutableObjectIntMap<K> withKeyValue(K key, int value);

    MutableObjectIntMap<K> withoutKey(K key);

    MutableObjectIntMap<K> withoutAllKeys(Iterable<? extends K> keys);

    MutableObjectIntMap<K> asUnmodifiable();

    MutableObjectIntMap<K> asSynchronized();

    int addToValue(K key, int toBeAdded);
}
