/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction0;
import com.gs.collections.api.block.function.primitive.FloatToFloatFunction;
import com.gs.collections.api.block.predicate.primitive.FloatFloatPredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableFloatFloatMap extends FloatFloatMap
{
    void clear();

    void put(float key, float value);

    void putAll(FloatFloatMap map);

    void removeKey(float key);

    void remove(float key);

    float removeKeyIfAbsent(float key, float value);

    float getIfAbsentPut(float key, float value);

    float getIfAbsentPut(float key, FloatFunction0 function);

    float getIfAbsentPutWithKey(float key, FloatToFloatFunction function);

    <P> float getIfAbsentPutWith(float key, FloatFunction<? super P> function, P parameter);

    float updateValue(float key, float initialValueIfAbsent, FloatToFloatFunction function);

    MutableFloatFloatMap select(FloatFloatPredicate predicate);

    MutableFloatFloatMap reject(FloatFloatPredicate predicate);

    MutableFloatCollection select(FloatPredicate predicate);

    MutableFloatCollection reject(FloatPredicate predicate);

    <V> MutableCollection<V> collect(FloatToObjectFunction<? extends V> function);

    MutableFloatFloatMap withKeyValue(float key, float value);

    MutableFloatFloatMap withoutKey(float key);

    MutableFloatFloatMap withoutAllKeys(FloatIterable keys);

    MutableFloatFloatMap asUnmodifiable();

    MutableFloatFloatMap asSynchronized();

    float addToValue(float key, float toBeAdded);
}
