/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.function.primitive.FloatToCharFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.CharFunction0;
import com.gs.collections.api.block.function.primitive.CharToCharFunction;
import com.gs.collections.api.block.predicate.primitive.FloatCharPredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableFloatCharMap extends FloatCharMap
{
    void clear();

    void put(float key, char value);

    void putAll(FloatCharMap map);

    void removeKey(float key);

    void remove(float key);

    char removeKeyIfAbsent(float key, char value);

    char getIfAbsentPut(float key, char value);

    char getIfAbsentPut(float key, CharFunction0 function);

    char getIfAbsentPutWithKey(float key, FloatToCharFunction function);

    <P> char getIfAbsentPutWith(float key, CharFunction<? super P> function, P parameter);

    char updateValue(float key, char initialValueIfAbsent, CharToCharFunction function);

    MutableFloatCharMap select(FloatCharPredicate predicate);

    MutableFloatCharMap reject(FloatCharPredicate predicate);

    MutableCharCollection select(CharPredicate predicate);

    MutableCharCollection reject(CharPredicate predicate);

    <V> MutableCollection<V> collect(CharToObjectFunction<? extends V> function);

    MutableFloatCharMap withKeyValue(float key, char value);

    MutableFloatCharMap withoutKey(float key);

    MutableFloatCharMap withoutAllKeys(FloatIterable keys);

    MutableFloatCharMap asUnmodifiable();

    MutableFloatCharMap asSynchronized();

    char addToValue(float key, char toBeAdded);
}
