/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.primitive.CharObjectPredicate;
import com.gs.collections.api.collection.MutableCollection;

/**
 * This file was automatically generated from template file mutablePrimitiveObjectMap.stg.
 *
 * @since 3.0.
 */
public interface MutableCharObjectMap<V> extends CharObjectMap<V>, MutablePrimitiveObjectMap<V>
{
    V put(char key, V value);

    /**
     * @since 5.0.
     */
    void putAll(CharObjectMap<? extends V> map);

    V removeKey(char key);

    V remove(char key);

    V getIfAbsentPut(char key, V value);

    V getIfAbsentPut(char key, Function0<? extends V> function);

    V getIfAbsentPutWithKey(char key, CharToObjectFunction<? extends V> function);

    <P> V getIfAbsentPutWith(char key, Function<? super P, ? extends V> function, P parameter);

    /**
     * Look up the value associated with {@code key}, apply the {@code function} to it, and replace the value. If there
     * is no value associated with {@code key}, start it off with a value supplied by {@code factory}.
     */
    V updateValue(char key, Function0<? extends V> factory, Function<? super V, ? extends V> function);

    /**
     * Same as {@link #updateValue(char, Function0, Function)} with a Function2 and specified parameter which is
     * passed to the function.
     */
    <P> V updateValueWith(char key, Function0<? extends V> factory, Function2<? super V, ? super P, ? extends V> function, P parameter);

    MutableCharObjectMap<V> select(CharObjectPredicate<? super V> predicate);

    MutableCharObjectMap<V> reject(CharObjectPredicate<? super V> predicate);

    MutableCollection<V> select(Predicate<? super V> predicate);

    MutableCollection<V> reject(Predicate<? super V> predicate);

    <V1> MutableCollection<V1> collect(Function<? super V, ? extends V1> function);

    <P, VV> MutableCollection<VV> collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter);

    MutableCharObjectMap<V> withKeyValue(char key, V value);

    MutableCharObjectMap<V> withoutKey(char key);

    MutableCharObjectMap<V> withoutAllKeys(CharIterable keys);

    MutableCharObjectMap<V> asUnmodifiable();

    MutableCharObjectMap<V> asSynchronized();
}
