/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.function.primitive.CharToFloatFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction0;
import com.gs.collections.api.block.function.primitive.FloatToFloatFunction;
import com.gs.collections.api.block.predicate.primitive.CharFloatPredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableCharFloatMap extends CharFloatMap
{
    void clear();

    void put(char key, float value);

    void putAll(CharFloatMap map);

    void removeKey(char key);

    void remove(char key);

    float removeKeyIfAbsent(char key, float value);

    float getIfAbsentPut(char key, float value);

    float getIfAbsentPut(char key, FloatFunction0 function);

    float getIfAbsentPutWithKey(char key, CharToFloatFunction function);

    <P> float getIfAbsentPutWith(char key, FloatFunction<? super P> function, P parameter);

    float updateValue(char key, float initialValueIfAbsent, FloatToFloatFunction function);

    MutableCharFloatMap select(CharFloatPredicate predicate);

    MutableCharFloatMap reject(CharFloatPredicate predicate);

    MutableFloatCollection select(FloatPredicate predicate);

    MutableFloatCollection reject(FloatPredicate predicate);

    <V> MutableCollection<V> collect(FloatToObjectFunction<? extends V> function);

    MutableCharFloatMap withKeyValue(char key, float value);

    MutableCharFloatMap withoutKey(char key);

    MutableCharFloatMap withoutAllKeys(CharIterable keys);

    MutableCharFloatMap asUnmodifiable();

    MutableCharFloatMap asSynchronized();

    float addToValue(char key, float toBeAdded);
}
