/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.predicate.primitive.CharBytePredicate;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableByteCollection;

/**
 * This file was automatically generated from template file immutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface ImmutableCharByteMap extends CharByteMap
{
    ImmutableCharByteMap select(CharBytePredicate predicate);

    ImmutableCharByteMap reject(CharBytePredicate predicate);

    ImmutableByteCollection select(BytePredicate predicate);

    ImmutableByteCollection reject(BytePredicate predicate);

    <V> ImmutableCollection<V> collect(ByteToObjectFunction<? extends V> function);

    ImmutableCharByteMap newWithKeyValue(char key, byte value);

    ImmutableCharByteMap newWithoutKey(char key);

    ImmutableCharByteMap newWithoutAllKeys(CharIterable keys);
}
