/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.predicate.primitive.ByteBooleanPredicate;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableBooleanCollection;

/**
 * This file was automatically generated from template file immutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface ImmutableByteBooleanMap extends ByteBooleanMap
{
    ImmutableByteBooleanMap select(ByteBooleanPredicate predicate);

    ImmutableByteBooleanMap reject(ByteBooleanPredicate predicate);

    ImmutableBooleanCollection select(BooleanPredicate predicate);

    ImmutableBooleanCollection reject(BooleanPredicate predicate);

    <V> ImmutableCollection<V> collect(BooleanToObjectFunction<? extends V> function);

    ImmutableByteBooleanMap newWithKeyValue(byte key, boolean value);

    ImmutableByteBooleanMap newWithoutKey(byte key);

    ImmutableByteBooleanMap newWithoutAllKeys(ByteIterable keys);
}
