/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.list.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.collection.primitive.ImmutableDoubleCollection;
import com.gs.collections.api.list.ImmutableList;

/**
 * This file was automatically generated from template file immutablePrimitiveList.stg.
 *
 * @since 3.0.
 */
public interface ImmutableDoubleList extends ImmutableDoubleCollection, DoubleList
{
    ImmutableDoubleList select(DoublePredicate predicate);

    ImmutableDoubleList reject(DoublePredicate predicate);

    <V> ImmutableList<V> collect(DoubleToObjectFunction<? extends V> function);

    ImmutableDoubleList newWith(double element);

    ImmutableDoubleList newWithout(double element);

    ImmutableDoubleList newWithAll(DoubleIterable elements);

    ImmutableDoubleList newWithoutAll(DoubleIterable elements);

    ImmutableDoubleList toReversed();

    ImmutableDoubleList subList(int fromIndex, int toIndex);
}
