/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.set.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.set.primitive.ImmutableLongSet;

/**
 * A factory which creates instances of type {@link ImmutableLongSet}.
 * This file was automatically generated from template file immutablePrimitiveSetFactory.stg.
 *
 * @since 4.0.
 */
public interface ImmutableLongSetFactory
{
    /**
     * Same as {@link #with()}.
     */
    ImmutableLongSet of();

    ImmutableLongSet with();

    /**
     * Same as {@link #with(long)}.
     */
    ImmutableLongSet of(long one);

    ImmutableLongSet with(long one);

    /**
     * Same as {@link #with(long[])}.
     */
    ImmutableLongSet of(long... items);

    ImmutableLongSet with(long... items);

    /**
     * Same as {@link #withAll(LongIterable)}.
     */
    ImmutableLongSet ofAll(LongIterable items);

    ImmutableLongSet withAll(LongIterable items);
}
