/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.map.primitive;

import com.gs.collections.api.map.primitive.ImmutableByteCharMap;
import com.gs.collections.api.map.primitive.ByteCharMap;

/**
 * A factory which creates instances of type {@link ImmutableByteCharMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactory.stg.
 *
 * @since 4.0.
 */
public interface ImmutableByteCharMapFactory
{
    /**
     * Same as {@link #with()}.
     */
    ImmutableByteCharMap of();

    ImmutableByteCharMap with();

    /**
     * Same as {@link #with(byte, char)}.
     */
    ImmutableByteCharMap of(byte key, char value);

    ImmutableByteCharMap with(byte key, char value);

    /**
     * Same as {@link #withAll(ByteCharMap)}.
     */
    ImmutableByteCharMap ofAll(ByteCharMap map);

    ImmutableByteCharMap withAll(ByteCharMap map);
}
