/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.collection.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.collection.ImmutableCollection;

/**
 * This file was automatically generated from template file immutablePrimitiveCollection.stg.
 *
 * @since 3.0.
 */
public interface ImmutableIntCollection extends IntIterable
{
    <V> ImmutableCollection<V> collect(IntToObjectFunction<? extends V> function);

    ImmutableIntCollection select(IntPredicate predicate);

    ImmutableIntCollection reject(IntPredicate predicate);

    ImmutableIntCollection newWith(int element);

    ImmutableIntCollection newWithout(int element);

    ImmutableIntCollection newWithAll(IntIterable elements);

    ImmutableIntCollection newWithoutAll(IntIterable elements);
}
