/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api;

import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.set.primitive.MutableDoubleSet;

/**
 * DoubleIterable is an interface which is memory-optimized for double primitives.
 * It is inspired by the interface RichIterable, and contains a subset of the internal iterator methods on RichIterable like collect, sum, etc.
 * The API also includes an external iterator method, which returns an DoubleIterator. DoubleIterator helps iterate over the DoubleIterable without boxing the primitives.
 * This file was automatically generated from template file primitiveIterable.stg.
 */
public interface DoubleIterable extends PrimitiveIterable
{
    DoubleIterator doubleIterator();

    double[] toArray();

    boolean contains(double value);

    boolean containsAll(double... source);

    boolean containsAll(DoubleIterable source);

    void forEach(DoubleProcedure procedure);

    DoubleIterable select(DoublePredicate predicate);

    DoubleIterable reject(DoublePredicate predicate);

    <V> RichIterable<V> collect(DoubleToObjectFunction<? extends V> function);

    double detectIfNone(DoublePredicate predicate, double ifNone);

    int count(DoublePredicate predicate);

    boolean anySatisfy(DoublePredicate predicate);

    boolean allSatisfy(DoublePredicate predicate);

    boolean noneSatisfy(DoublePredicate predicate);

    MutableDoubleList toList();

    MutableDoubleSet toSet();

    MutableDoubleBag toBag();

    LazyDoubleIterable asLazy();

    <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function);

    double sum();

    double max();

    double maxIfEmpty(double defaultValue);

    double min();

    double minIfEmpty(double defaultValue);

    double average();

    double median();

    double[] toSortedArray();

    MutableDoubleList toSortedList();

}
