/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.math.io.files.ASCIIFile;
import org.math.plot.FrameView;
import org.math.plot.Plot2DPanel;
import org.math.plot.Plot3DPanel;
import org.math.plot.canvas.PlotCanvas;
import org.math.plot.components.LegendPanel;
import org.math.plot.components.PlotToolBar;
import org.math.plot.plotObjects.Axis;
import org.math.plot.plotObjects.Plotable;
import org.math.plot.plots.Plot;
import org.math.plot.utils.Array;

public abstract class PlotPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public PlotToolBar plotToolBar;
    public PlotCanvas plotCanvas;
    public LegendPanel plotLegend;
    public static final String EAST = "East";
    public static final String SOUTH = "South";
    public static final String NORTH = "North";
    public static final String WEST = "West";
    public static final String INVISIBLE = "INVISIBLE";
    public static final String SCATTER = "SCATTER";
    public static final String LINE = "LINE";
    public static final String BAR = "BAR";
    public static final String HISTOGRAM = "HISTOGRAM";
    public static final String BOX = "BOX";
    public static final String STAIRCASE = "STAIRCASE";
    public static final String GRID = "GRID";
    public static final Color[] COLORLIST = new Color[]{Color.BLUE, Color.RED, Color.GREEN, Color.YELLOW, Color.ORANGE, Color.PINK, Color.CYAN, Color.MAGENTA};
    private Font font = new Font("Arial", 0, 10);

    public PlotPanel(PlotCanvas _canvas, String legendOrientation) {
        this.plotCanvas = _canvas;
        this.setBackground(Color.WHITE);
        this.setLayout(new BorderLayout());
        this.addPlotToolBar(NORTH);
        this.addLegend(legendOrientation);
        this.add((Component)this.plotCanvas, "Center");
    }

    public PlotPanel(PlotCanvas _canvas) {
        this(_canvas, INVISIBLE);
    }

    public void addLegend(String location) {
        if (location.equalsIgnoreCase(EAST)) {
            this.plotLegend = new LegendPanel(this, LegendPanel.VERTICAL);
            this.add((Component)this.plotLegend, EAST);
        } else if (location.equalsIgnoreCase(SOUTH)) {
            this.plotLegend = new LegendPanel(this, LegendPanel.HORIZONTAL);
            this.add((Component)this.plotLegend, SOUTH);
        } else if (location.equalsIgnoreCase(WEST)) {
            this.plotLegend = new LegendPanel(this, LegendPanel.VERTICAL);
            this.add((Component)this.plotLegend, WEST);
        } else if (location.equalsIgnoreCase(NORTH)) {
            this.plotLegend = new LegendPanel(this, LegendPanel.HORIZONTAL);
            this.add((Component)this.plotLegend, NORTH);
        } else if (location.equalsIgnoreCase(INVISIBLE)) {
            this.plotLegend = new LegendPanel(this, LegendPanel.INVISIBLE);
        } else {
            System.err.println("Orientation " + location + " is unknonw.");
        }
    }

    public void removeLegend() {
        this.remove(this.plotLegend);
    }

    public void setLegendOrientation(String location) {
        this.removeLegend();
        this.addLegend(location);
    }

    public void addPlotToolBar(String location) {
        if (location.equalsIgnoreCase(EAST)) {
            this.removePlotToolBar();
            this.plotToolBar = new PlotToolBar(this);
            this.plotToolBar.setFloatable(false);
            this.add((Component)this.plotToolBar, EAST);
        } else if (location.equalsIgnoreCase(SOUTH)) {
            this.removePlotToolBar();
            this.plotToolBar = new PlotToolBar(this);
            this.plotToolBar.setFloatable(false);
            this.add((Component)this.plotToolBar, SOUTH);
        } else if (location.equalsIgnoreCase(WEST)) {
            this.removePlotToolBar();
            this.plotToolBar = new PlotToolBar(this);
            this.plotToolBar.setFloatable(false);
            this.add((Component)this.plotToolBar, WEST);
        } else if (location.equalsIgnoreCase(NORTH)) {
            this.removePlotToolBar();
            this.plotToolBar = new PlotToolBar(this);
            this.plotToolBar.setFloatable(false);
            this.add((Component)this.plotToolBar, NORTH);
        } else {
            System.err.println("Location " + location + " is unknonw.");
        }
    }

    public void removePlotToolBar() {
        if (this.plotToolBar == null) {
            return;
        }
        this.remove(this.plotToolBar);
    }

    public void setPlotToolBarOrientation(String location) {
        this.addPlotToolBar(location);
    }

    public PlotToolBar getPlotToolBar() {
        return this.plotToolBar;
    }

    public void setAdjustBounds(boolean adjust) {
        this.plotCanvas.setAdjustBounds(adjust);
        if (this.plotToolBar != null) {
            this.plotToolBar.ajustBoundsChanged();
        }
    }

    public void setActionMode(int am) {
        this.plotCanvas.setActionMode(am);
    }

    public void setNoteCoords(boolean b) {
        this.plotCanvas.setNoteCoords(b);
    }

    public void setEditable(boolean b) {
        this.plotCanvas.setEditable(b);
    }

    public boolean getEditable() {
        return this.plotCanvas.getEditable();
    }

    public void setNotable(boolean b) {
        this.plotCanvas.setNotable(b);
    }

    public boolean getNotable() {
        return this.plotCanvas.getNotable();
    }

    public LinkedList<Plot> getPlots() {
        return this.plotCanvas.getPlots();
    }

    public Plot getPlot(int i) {
        return this.plotCanvas.getPlot(i);
    }

    public int getPlotIndex(Plot p) {
        return this.plotCanvas.getPlotIndex(p);
    }

    public LinkedList<Plotable> getPlotables() {
        return this.plotCanvas.getPlotables();
    }

    public Plotable getPlotable(int i) {
        return this.plotCanvas.getPlotable(i);
    }

    public Axis getAxis(int i) {
        return this.plotCanvas.getGrid().getAxis(i);
    }

    public String[] getAxisScales() {
        return this.plotCanvas.getAxisScales();
    }

    public void setAxisLabels(String ... labels) {
        this.plotCanvas.setAxisLabels(labels);
    }

    public void setAxisLabel(int axe, String label) {
        this.plotCanvas.setAxisLabel(axe, label);
    }

    public void setAxisScales(String ... scales) {
        this.plotCanvas.setAxisScales(scales);
    }

    public void setAxisScale(int axe, String scale) {
        this.plotCanvas.setAxiScale(axe, scale);
    }

    public void setFixedBounds(double[] min, double[] max) {
        this.plotCanvas.setFixedBounds(min, max);
    }

    public void setFixedBounds(int axe, double min, double max) {
        this.plotCanvas.setFixedBounds(axe, min, max);
    }

    public void includeInBounds(double ... into) {
        this.plotCanvas.includeInBounds(into);
    }

    public void includeInBounds(Plot plot) {
        this.plotCanvas.includeInBounds(plot);
    }

    public void setAutoBounds() {
        this.plotCanvas.setAutoBounds();
    }

    public void setAutoBounds(int axe) {
        this.plotCanvas.setAutoBounds(axe);
    }

    public double[][] mapData(Object[][] stringdata) {
        return this.plotCanvas.mapData(stringdata);
    }

    public void resetMapData() {
        this.plotCanvas.resetMapData();
    }

    public void addLabel(String text, Color c, double ... where) {
        this.plotCanvas.addLabel(text, c, where);
    }

    public void addBaseLabel(String text, Color c, double ... where) {
        this.plotCanvas.addBaseLabel(text, c, where);
    }

    public void addPlotable(Plotable p) {
        this.plotCanvas.addPlotable(p);
    }

    public void removePlotable(Plotable p) {
        this.plotCanvas.removePlotable(p);
    }

    public void removePlotable(int i) {
        this.plotCanvas.removePlotable(i);
    }

    public void removeAllPlotables() {
        this.plotCanvas.removeAllPlotables();
    }

    public int addPlot(Plot newPlot) {
        return this.plotCanvas.addPlot(newPlot);
    }

    protected Color getNewColor() {
        return COLORLIST[this.plotCanvas.plots.size() % COLORLIST.length];
    }

    public int addPlot(String type, String name, double[] ... v) {
        return this.addPlot(type, name, this.getNewColor(), v);
    }

    public abstract int addPlot(String var1, String var2, Color var3, double[] ... var4);

    public void setPlot(int I, Plot p) {
        this.plotCanvas.setPlot(I, p);
    }

    public void changePlotData(int I, double[] ... XY) {
        this.plotCanvas.changePlotData(I, XY);
    }

    public void changePlotName(int I, String name) {
        this.plotCanvas.changePlotName(I, name);
    }

    public void changePlotColor(int I, Color c) {
        this.plotCanvas.changePlotColor(I, c);
    }

    public void removePlot(int I) {
        this.plotCanvas.removePlot(I);
    }

    public void removePlot(Plot p) {
        this.plotCanvas.removePlot(p);
    }

    public void removeAllPlots() {
        this.plotCanvas.removeAllPlots();
    }

    public void addVectortoPlot(int numPlot, double[][] v) {
        this.plotCanvas.addVectortoPlot(numPlot, v);
    }

    public void addQuantiletoPlot(int numPlot, int numAxe, double rate, boolean symetric, double[] q) {
        this.plotCanvas.addQuantiletoPlot(numPlot, numAxe, rate, symetric, q);
    }

    public void addQuantiletoPlot(int numPlot, int numAxe, double rate, boolean symetric, double q) {
        this.plotCanvas.addQuantiletoPlot(numPlot, numAxe, rate, symetric, q);
    }

    public void addQuantilestoPlot(int numPlot, int numAxe, double[][] q) {
        this.plotCanvas.addQuantilestoPlot(numPlot, numAxe, q);
    }

    public void addQuantilestoPlot(int numPlot, int numAxe, double[] q) {
        this.plotCanvas.addQuantilestoPlot(numPlot, numAxe, q);
    }

    public void addGaussQuantilestoPlot(int numPlot, int numAxe, double[] s) {
        this.plotCanvas.addGaussQuantilestoPlot(numPlot, numAxe, s);
    }

    public void addGaussQuantilestoPlot(int numPlot, int numAxe, double s) {
        this.plotCanvas.addGaussQuantilestoPlot(numPlot, numAxe, s);
    }

    public void toGraphicFile(File file) throws IOException {
        this.plotToolBar.setVisible(false);
        Image image = this.createImage(this.getWidth(), this.getHeight());
        this.paint(image.getGraphics());
        image = new ImageIcon(image).getImage();
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D g = bufferedImage.createGraphics();
        g.drawImage(image, 0, 0, Color.WHITE, null);
        g.dispose();
        this.plotToolBar.setVisible(true);
        try {
            ImageIO.write((RenderedImage)bufferedImage, "PNG", file);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        String man = "Usage: jplot.<sh|bat> <-2D|-3D> [-l <INVISIBLE|NORTH|SOUTH|EAST|WEST>] [options] <ASCII file (n rows, m columns)> [[options] other ASCII file]\n[-l <INVISIBLE|NORTH|SOUTH|EAST|WEST>] giving the legend position\n[options] are:\n  -t <SCATTER|LINE|BAR|HISTOGRAM2D(<integer h>)|HISTOGRAM3D(<integer h>,<integer k>)|GRID3D|CLOUD2D(<integer h>,<integer k>)|CLOUD3D(<integer h>,<integer k>,<integer l>)>    type of the plot\n      SCATTER|LINE|BAR: each line of the ASCII file contains coordinates of one point.\n      HISTOGRAM2D(<integer h>): ASCII file contains the 1D sample (i.e. m=1) to split in h slices.\n      HISTOGRAM3D(<integer h>,<integer k>): ASCII file contains the 2D sample (i.e. m=2) to split in h*k slices (h slices on X axis and k slices on Y axis).\n      GRID3D: ASCII file is a matrix, first row gives n X grid values, first column gives m Y grid values, other values are Z values.\n      CLOUD2D(<integer h>,<integer k>): ASCII file contains the 2D sample (i.e. m=2) to split in h*k slices (h slices on X axis and k slices on Y axis), density of cloud corresponds to frequency of X-Y slice in given 2D sample.\n      CLOUD3D(<integer h>,<integer k>,<integer l>): ASCII file contains the 3D sample (i.e. m=3) to split in h*k*l slices (h slices on X axis, k slices on Y axis, l slices on Y axis), density of cloud corresponds to frequency of X-Y-Z slice in given 3D sample.\n  -n name    name of the plot\n  -v <ASCII file (n,3|2)>    vector data to add to the plot\n  -q<X|Y|Z>(<float Q>) <ASCII file (n,1)>    Q-quantile to add to the plot on <X|Y|Z> axis. Each line of the given ASCII file contains the value of quantile for probvability Q.\n  -qP<X|Y|Z> <ASCII file (n,p)>    p-quantiles density to add to the plot on <X|Y|Z> axis. Each line of the given ASCII file contains p values.\n  -qN<X|Y|Z> <ASCII file (n,1)>    Gaussian density to add to the plot on <X|Y|Z> axis. Each line of the given ASCII file contains a standard deviation.";
        if (args.length == 0) {
            double[][] data = new double[20][];
            for (int i = 0; i < data.length; ++i) {
                data[i] = new double[]{Math.random(), Math.random(), Math.random()};
            }
            ASCIIFile.writeDoubleArray((File)new File("tmp.dat"), (double[][])data);
            args = new String[]{"-3D", "-l", "SOUTH", "-t", SCATTER, "tmp.dat"};
            System.out.println(man);
            System.out.println("\nExample: jplot.<sh|bat> " + Array.cat(args));
        }
        PlotPanel p = null;
        if (args[0].equals("-2D")) {
            p = new Plot2DPanel();
        } else if (args[0].equals("-3D")) {
            p = new Plot3DPanel();
        } else {
            System.out.println(man);
        }
        try {
            String leg = INVISIBLE;
            String type = SCATTER;
            String name = "";
            double[][] v = null;
            double[] qX = null;
            double[] qY = null;
            double[] qZ = null;
            double qXp = 0.0;
            double qYp = 0.0;
            double qZp = 0.0;
            double[][] qPX = null;
            double[][] qPY = null;
            double[][] qPZ = null;
            double[] qNX = null;
            double[] qNY = null;
            double[] qNZ = null;
            for (int i = 1; i < args.length; ++i) {
                if (args[i].equals("-l")) {
                    leg = args[i + 1];
                    ++i;
                    continue;
                }
                if (args[i].equals("-t")) {
                    type = args[i + 1];
                    ++i;
                    continue;
                }
                if (args[i].equals("-n")) {
                    name = args[i + 1];
                    ++i;
                    continue;
                }
                if (args[i].equals("-v")) {
                    v = ASCIIFile.readDoubleArray((File)new File(args[i + 1]));
                    ++i;
                    continue;
                }
                if (args[i].startsWith("-qX(")) {
                    qX = ASCIIFile.readDouble1DArray((File)new File(args[i + 1]));
                    qXp = Double.parseDouble(args[i].substring(4, args[i].length() - 1));
                    ++i;
                    continue;
                }
                if (args[i].startsWith("-qY(")) {
                    qY = ASCIIFile.readDouble1DArray((File)new File(args[i + 1]));
                    qYp = Double.parseDouble(args[i].substring(4, args[i].length() - 1));
                    ++i;
                    continue;
                }
                if (args[i].startsWith("-qZ(")) {
                    qZ = ASCIIFile.readDouble1DArray((File)new File(args[i + 1]));
                    qZp = Double.parseDouble(args[i].substring(4, args[i].length() - 1));
                    ++i;
                    continue;
                }
                if (args[i].equals("-qPX")) {
                    qPX = ASCIIFile.readDoubleArray((File)new File(args[i + 1]));
                    ++i;
                    continue;
                }
                if (args[i].equals("-qPY")) {
                    qPY = ASCIIFile.readDoubleArray((File)new File(args[i + 1]));
                    ++i;
                    continue;
                }
                if (args[i].equals("-qPZ")) {
                    qPZ = ASCIIFile.readDoubleArray((File)new File(args[i + 1]));
                    ++i;
                    continue;
                }
                if (args[i].equals("-qNX")) {
                    qNX = ASCIIFile.readDouble1DArray((File)new File(args[i + 1]));
                    ++i;
                    continue;
                }
                if (args[i].equals("-qNY")) {
                    qNY = ASCIIFile.readDouble1DArray((File)new File(args[i + 1]));
                    ++i;
                    continue;
                }
                if (args[i].equals("-qNZ")) {
                    qNZ = ASCIIFile.readDouble1DArray((File)new File(args[i + 1]));
                    ++i;
                    continue;
                }
                File input_file = new File(args[i]);
                int n = 0;
                if (input_file.exists()) {
                    if (name.length() == 0) {
                        name = input_file.getName();
                    }
                    if (p instanceof Plot2DPanel) {
                        Plot2DPanel p2d = (Plot2DPanel)p;
                        if (type.equals(SCATTER)) {
                            n = p2d.addScatterPlot(name, ASCIIFile.readDoubleArray((File)input_file));
                        } else if (type.equals(LINE)) {
                            n = p2d.addLinePlot(name, ASCIIFile.readDoubleArray((File)input_file));
                        } else if (type.equals(BAR)) {
                            n = p2d.addBarPlot(name, ASCIIFile.readDoubleArray((File)input_file));
                        } else if (type.startsWith("HISTOGRAM2D(")) {
                            n = p2d.addHistogramPlot(name, ASCIIFile.readDouble1DArray((File)input_file), Integer.parseInt(type.substring(12, type.length() - 1)));
                        } else if (type.startsWith("CLOUD2D(")) {
                            n = p2d.addCloudPlot(name, ASCIIFile.readDoubleArray((File)input_file), Integer.parseInt(type.substring(8, type.indexOf(","))), Integer.parseInt(type.substring(type.indexOf(",") + 1, type.length() - 1)));
                        } else {
                            p2d.addPlot(type, name, ASCIIFile.readDoubleArray((File)input_file));
                        }
                    } else {
                        Plot3DPanel p3d = (Plot3DPanel)p;
                        if (type.equals(SCATTER)) {
                            n = p3d.addScatterPlot(name, ASCIIFile.readDoubleArray((File)input_file));
                        } else if (type.equals(LINE)) {
                            n = p3d.addLinePlot(name, ASCIIFile.readDoubleArray((File)input_file));
                        } else if (type.equals(BAR)) {
                            n = p3d.addBarPlot(name, ASCIIFile.readDoubleArray((File)input_file));
                        } else if (type.startsWith("HISTOGRAM3D(")) {
                            n = p3d.addHistogramPlot(name, ASCIIFile.readDoubleArray((File)input_file), Integer.parseInt(type.substring(12, type.indexOf(","))), Integer.parseInt(type.substring(type.indexOf(",") + 1, type.length() - 1)));
                        } else if (type.equals("GRID3D")) {
                            n = p3d.addGridPlot(name, ASCIIFile.readDoubleArray((File)input_file));
                        } else if (type.startsWith("CLOUD3D(")) {
                            n = p3d.addCloudPlot(name, ASCIIFile.readDoubleArray((File)input_file), Integer.parseInt(type.substring(8, type.indexOf(","))), Integer.parseInt(type.substring(type.indexOf(",") + 1, type.indexOf(",", type.indexOf(",") + 1))), Integer.parseInt(type.substring(type.indexOf(",", type.indexOf(",") + 1) + 1, type.length() - 1)));
                        } else {
                            p3d.addPlot(type, name, ASCIIFile.readDoubleArray((File)input_file));
                        }
                    }
                    if (v != null) {
                        p.addVectortoPlot(n, v);
                    }
                    if (qX != null) {
                        p.addQuantiletoPlot(n, 0, qXp, false, qX);
                    }
                    if (qY != null) {
                        p.addQuantiletoPlot(n, 1, qYp, false, qY);
                    }
                    if (qZ != null) {
                        p.addQuantiletoPlot(n, 2, qZp, false, qZ);
                    }
                    if (qPX != null) {
                        p.addQuantilestoPlot(n, 0, qPX);
                    }
                    if (qPY != null) {
                        p.addQuantilestoPlot(n, 1, qPY);
                    }
                    if (qPZ != null) {
                        p.addQuantilestoPlot(n, 2, qPZ);
                    }
                    if (qNX != null) {
                        p.addGaussQuantilestoPlot(n, 0, qNX);
                    }
                    if (qNY != null) {
                        p.addGaussQuantilestoPlot(n, 1, qNY);
                    }
                    if (qNZ != null) {
                        p.addGaussQuantilestoPlot(n, 2, qNZ);
                    }
                    type = SCATTER;
                    leg = "SOUTH";
                    name = "";
                    qX = null;
                    qY = null;
                    qZ = null;
                    qXp = 0.0;
                    qYp = 0.0;
                    qZp = 0.0;
                    v = null;
                    qPX = null;
                    qPY = null;
                    qPZ = null;
                    qNX = null;
                    qNY = null;
                    qNZ = null;
                    continue;
                }
                System.out.println("File " + args[i] + " unknown.");
                System.out.println(man);
            }
            p.setLegendOrientation(leg);
            FrameView f = new FrameView(p);
            f.setDefaultCloseOperation(3);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("\n" + man);
        }
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
    }
}

