/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.lassp.houle.RngPack;

import edu.cornell.lassp.houle.RngPack.RanMT;
import edu.cornell.lassp.houle.RngPack.RandomElement;
import edu.cornell.lassp.houle.RngPack.RandomJava;
import edu.cornell.lassp.houle.RngPack.RandomSeedable;
import edu.cornell.lassp.houle.RngPack.Ranecu;
import edu.cornell.lassp.houle.RngPack.Ranlux;
import edu.cornell.lassp.houle.RngPack.Ranmar;

public class RandomApp {
    static String[] generators = new String[]{"ranmar", "ranecu", "ranlux", "randomjava", "null", "ranmt"};
    static String[] distributions = new String[]{"flat", "gaussian", "choose1", "choose2", "coin1", "coin2"};
    static final int RANMAR = 0;
    static final int RANECU = 1;
    static final int RANLUX = 2;
    static final int RANJAVA = 3;
    static final int NULL = 4;
    static final int RANMT = 5;
    static final int FLAT = 0;
    static final int GAUSSIAN = 1;
    static final int CHOOSE1 = 2;
    static final int CHOOSE2 = 3;
    static final int COIN1 = 4;
    static final int COIN2 = 5;

    public static void main(String[] args) {
        int i;
        boolean seeded = false;
        boolean gselected = false;
        boolean dselected = false;
        boolean noprint = false;
        boolean numbered = false;
        boolean luxuryset = false;
        int generator = 0;
        int distribution = 0;
        long seed = RandomSeedable.ClockSeed();
        int luxury = 3;
        int n = 1;
        block6: for (i = 0; i < args.length; ++i) {
            int j;
            String a = args[i].toLowerCase().intern();
            if (a == "noprint") {
                noprint = true;
                continue;
            }
            if (a == "seed") {
                if (seeded) {
                    RandomApp.die("RandomApp: only one seed can be passed");
                }
                if (i == args.length - 1) {
                    RandomApp.die("RandomApp: missing seed.");
                }
                a = new String(args[++i]);
                try {
                    seed = Long.parseLong(a);
                }
                catch (NumberFormatException ex) {
                    RandomApp.die("RandomApp: seed is not a valid number.");
                }
                seeded = true;
                continue;
            }
            if (a == "luxury") {
                if (luxuryset) {
                    RandomApp.die("RandomApp: only one luxury level can be passed");
                }
                if (i == args.length - 1) {
                    RandomApp.die("RandomApp: missing luxury level.");
                }
                a = new String(args[++i]);
                try {
                    luxury = Integer.parseInt(a);
                }
                catch (NumberFormatException ex) {
                    RandomApp.die("RandomApp: luxury level is not a valid number.");
                }
                luxuryset = true;
                if (luxury >= 0 && luxury <= 4) continue;
                RandomApp.die("RandomApp: luxury level must be between 0 and 4");
                continue;
            }
            for (j = 0; j < generators.length; ++j) {
                if (a != generators[j]) continue;
                if (gselected) {
                    RandomApp.die("RandomApp: only one generator can be selected.");
                }
                generator = j;
                gselected = true;
                continue block6;
            }
            for (j = 0; j < distributions.length; ++j) {
                if (a != distributions[j]) continue;
                if (dselected) {
                    RandomApp.die("RandomApp: only one distribution can be selected.");
                }
                distribution = j;
                dselected = true;
                continue block6;
            }
            try {
                n = Integer.parseInt(a);
                if (numbered) {
                    RandomApp.die("RandomApp: only one number of random numbers can be selected.");
                }
                numbered = true;
                continue;
            }
            catch (NumberFormatException ex) {
                RandomApp.die("RandomApp: syntax error <" + a + ">");
            }
        }
        RandomElement e = null;
        if (generator == 0) {
            e = new Ranmar(seed);
        } else if (generator == 1) {
            e = new Ranecu(seed);
        } else if (generator == 2) {
            e = new Ranlux(luxury, seed);
        } else if (generator == 3) {
            e = new RandomJava();
        } else if (generator == 5) {
            e = new RanMT(seed);
        }
        for (i = 1; i <= n; ++i) {
            double x = 0.0;
            if (generator != 4) {
                if (distribution == 0) {
                    x = e.raw();
                } else if (distribution == 1) {
                    x = e.gaussian();
                } else if (distribution == 2) {
                    x = e.choose(5);
                } else if (distribution == 3) {
                    x = e.choose(7, 10);
                } else if (distribution == 4) {
                    x = e.coin() ? 1.0 : 0.0;
                } else if (distribution == 5) {
                    x = e.coin(0.7) ? 1.0 : 0.0;
                } else {
                    RandomApp.die("Invalid distribution: " + distribution);
                }
            }
            if (noprint) continue;
            System.out.println(x);
        }
    }

    static void die(String s) {
        System.err.println(s);
        System.exit(-1);
    }

    static double nullgen() {
        return 0.0;
    }
}

