/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.flattener;

import com.github.wnameless.json.flattener.ObjectMapperFactory;
import com.github.wnameless.json.flattener.PrintMode;
import com.github.wnameless.json.flattener.StringEscapePolicy;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.text.translate.CharSequenceTranslator;

public class JsonifyLinkedHashMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 1L;
    private CharSequenceTranslator translator = StringEscapePolicy.DEFAULT.getCharSequenceTranslator();

    public void setTranslator(CharSequenceTranslator translator) {
        this.translator = translator;
    }

    public String toString(PrintMode printMode) {
        try {
            switch (printMode) {
                case REGULAR: {
                    return ObjectMapperFactory.getWriter().writeValueAsString(ObjectMapperFactory.get(this.translator).readValue(this.toString(), Object.class));
                }
                case PRETTY: {
                    return ObjectMapperFactory.getWriter().writerWithDefaultPrettyPrinter().writeValueAsString(ObjectMapperFactory.get(this.translator).readValue(this.toString(), Object.class));
                }
            }
            return ObjectMapperFactory.getWriter().writeValueAsString(ObjectMapperFactory.get(this.translator).readValue(this.toString(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (Map.Entry mem : this.entrySet()) {
            sb.append('\"');
            sb.append(mem.getKey());
            sb.append('\"');
            sb.append(':');
            if (mem.getValue() instanceof String) {
                sb.append('\"');
                sb.append(this.translator.translate((CharSequence)((String)mem.getValue())));
                sb.append('\"');
            } else {
                sb.append(mem.getValue());
            }
            sb.append(',');
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append('}');
        return sb.toString();
    }
}

