/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.unflattener;

import com.github.wnameless.json.base.JsonCore;
import com.github.wnameless.json.unflattener.JsonUnflattener;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

public final class JsonUnflattenerFactory {
    private final Consumer<JsonUnflattener> configurer;
    private final Optional<JsonCore<?>> jsonCore;

    public JsonUnflattenerFactory(Consumer<JsonUnflattener> configurer) {
        if (configurer == null) {
            throw new NullPointerException();
        }
        this.configurer = configurer;
        this.jsonCore = Optional.empty();
    }

    public JsonUnflattenerFactory(Consumer<JsonUnflattener> configurer, JsonCore<?> jsonCore) {
        if (configurer == null) {
            throw new NullPointerException();
        }
        this.configurer = configurer;
        this.jsonCore = Optional.of(jsonCore);
    }

    public JsonUnflattener build(String json) {
        JsonUnflattener jf = this.jsonCore.isPresent() ? new JsonUnflattener(this.jsonCore.get(), json) : new JsonUnflattener(json);
        this.configurer.accept(jf);
        return jf;
    }

    public JsonUnflattener build(Map<String, ?> flattenedMap) {
        JsonUnflattener jf = this.jsonCore.isPresent() ? new JsonUnflattener(this.jsonCore.get(), flattenedMap) : new JsonUnflattener(flattenedMap);
        this.configurer.accept(jf);
        return jf;
    }

    public JsonUnflattener build(Reader jsonReader) throws IOException {
        JsonUnflattener jf = this.jsonCore.isPresent() ? new JsonUnflattener(this.jsonCore.get(), jsonReader) : new JsonUnflattener(jsonReader);
        this.configurer.accept(jf);
        return jf;
    }

    public int hashCode() {
        int result = 27;
        result = 31 * result + this.configurer.hashCode();
        result = 31 * result + this.jsonCore.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsonUnflattenerFactory)) {
            return false;
        }
        JsonUnflattenerFactory other = (JsonUnflattenerFactory)o;
        return this.configurer.equals(other.configurer) && this.jsonCore.equals(other.jsonCore);
    }

    public String toString() {
        return "JsonUnflattenerFactory{configurer=" + this.configurer + ", jsonCore=" + this.jsonCore + "}";
    }
}

