/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.base;

import com.github.wnameless.json.base.GsonJsonValue;
import com.github.wnameless.json.base.JsonCore;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.io.Reader;

public class GsonJsonCore
implements JsonCore<GsonJsonValue> {
    private final Gson gson;

    private Gson getInstance() {
        return this.gson == null ? LazyHolder.INSTANCE : this.gson;
    }

    public GsonJsonCore() {
        this.gson = null;
    }

    public GsonJsonCore(Gson gson) {
        if (gson == null) {
            throw new NullPointerException();
        }
        this.gson = gson;
    }

    public GsonJsonValue parse(String json) {
        return new GsonJsonValue((JsonElement)this.getInstance().fromJson(json, JsonElement.class));
    }

    public GsonJsonValue parse(Reader jsonReader) throws IOException {
        return new GsonJsonValue((JsonElement)this.getInstance().fromJson(jsonReader, JsonElement.class));
    }

    private static class LazyHolder {
        public static final Gson INSTANCE = new GsonBuilder().serializeNulls().create();

        private LazyHolder() {
        }
    }
}

