/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.base;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.wnameless.json.base.JacksonJsonArray;
import com.github.wnameless.json.base.JacksonJsonObject;
import com.github.wnameless.json.base.JsonValueCore;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;

public final class JacksonJsonValue
implements JsonValueCore<JacksonJsonValue> {
    private final JsonNode jsonValue;

    public JacksonJsonValue(JsonNode jsonValue) {
        if (jsonValue == null) {
            throw new NullPointerException();
        }
        this.jsonValue = jsonValue;
    }

    @Override
    public boolean isObject() {
        return this.jsonValue.isObject();
    }

    @Override
    public boolean isArray() {
        return this.jsonValue.isArray();
    }

    @Override
    public boolean isString() {
        return this.jsonValue.isTextual();
    }

    @Override
    public boolean isBoolean() {
        return this.jsonValue.isBoolean();
    }

    @Override
    public boolean isNumber() {
        return this.jsonValue.isNumber();
    }

    @Override
    public boolean isNull() {
        return this.jsonValue.isNull();
    }

    @Override
    public JacksonJsonObject asObject() {
        return new JacksonJsonObject((ObjectNode)this.jsonValue);
    }

    @Override
    public JacksonJsonArray asArray() {
        return new JacksonJsonArray((ArrayNode)this.jsonValue);
    }

    @Override
    public JacksonJsonValue asValue() {
        return this;
    }

    @Override
    public String asString() {
        return this.jsonValue.asText();
    }

    @Override
    public boolean asBoolean() {
        return this.jsonValue.asBoolean();
    }

    @Override
    public int asInt() {
        return this.jsonValue.asInt();
    }

    @Override
    public long asLong() {
        return this.jsonValue.asLong();
    }

    @Override
    public BigInteger asBigInteger() {
        return this.jsonValue.bigIntegerValue();
    }

    @Override
    public double asDouble() {
        return this.jsonValue.asDouble();
    }

    @Override
    public BigDecimal asBigDecimal() {
        return this.jsonValue.decimalValue();
    }

    public int hashCode() {
        return this.jsonValue.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JacksonJsonValue)) {
            return false;
        }
        return Objects.equals(this.jsonValue, ((JacksonJsonValue)o).jsonValue);
    }

    public String toString() {
        return this.jsonValue.toString();
    }

    @Override
    public String toJson() {
        return this.toString();
    }

    public JsonNode getSource() {
        return this.jsonValue;
    }
}

