/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.util.value;

import java.lang.ref.WeakReference;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeakShared<T> {
    @NotNull
    private final Supplier<T> supplier;
    @Nullable
    private WeakReference<T> reference = null;

    public WeakShared(@NotNull @NotNull Supplier<@NotNull T> supplier) {
        this.supplier = supplier;
    }

    @NotNull
    protected T create() {
        return this.supplier.get();
    }

    @NotNull
    public T get() {
        T value;
        if (this.reference == null) {
            value = this.create();
            this.reference = new WeakReference<T>(value);
        } else {
            value = this.reference.get();
            if (value == null) {
                value = this.create();
                this.reference = new WeakReference<T>(value);
            }
        }
        return value;
    }

    public T getIfPresent() {
        WeakReference<T> ref = this.reference;
        return ref != null ? (T)ref.get() : null;
    }
}

