/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.theme.info;

import com.github.weisj.darklaf.theme.info.FontSizePreset;
import java.io.Serializable;

public class FontSizeRule
implements Serializable {
    private static final FontSizeRule DEFAULT = new FontSizeRule(AdjustmentType.NO_ADJUSTMENT, 1.0f);
    private final AdjustmentType type;
    private final FontSizePreset preset;
    private final float relativeAdjustment;

    protected FontSizeRule(FontSizePreset preset) {
        this.preset = preset;
        this.type = preset.getType();
        this.relativeAdjustment = 1.0f;
    }

    protected FontSizeRule(AdjustmentType type, float relativeAdjustment) {
        this.type = type;
        this.relativeAdjustment = relativeAdjustment;
        this.preset = null;
    }

    public FontSizePreset getPreset() {
        return this.preset;
    }

    public static FontSizeRule getDefault() {
        return DEFAULT;
    }

    public static FontSizeRule fromPreset(FontSizePreset preset) {
        return new FontSizeRule(preset);
    }

    public static FontSizeRule relativeAdjustment(float percent) {
        return new FontSizeRule(AdjustmentType.RELATIVE_ADJUSTMENT, percent);
    }

    public static FontSizeRule relativeAdjustment(int percent) {
        return new FontSizeRule(AdjustmentType.RELATIVE_ADJUSTMENT, (float)percent / 100.0f);
    }

    public float adjustFontSize(float size) {
        if (this.preset != null) {
            return this.preset.adjustFontSize(size);
        }
        return this.type.adjustSize(size, this.relativeAdjustment);
    }

    public AdjustmentType getType() {
        if (this.preset == null && this.type == AdjustmentType.RELATIVE_ADJUSTMENT && this.relativeAdjustment == 1.0f) {
            return AdjustmentType.NO_ADJUSTMENT;
        }
        return this.type;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("FontSizeRule{type=").append(this.type);
        if (this.preset != null) {
            builder.append(", preset=").append(this.preset);
        } else {
            switch (this.type) {
                case RELATIVE_ADJUSTMENT: {
                    builder.append(", relativeAdjustment=").append(this.relativeAdjustment);
                    break;
                }
            }
        }
        builder.append("}");
        return builder.toString();
    }

    public int getPercentage() {
        if (this.preset != null) {
            return this.preset.getPercentage();
        }
        return Math.round(this.relativeAdjustment * 100.0f);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FontSizeRule that = (FontSizeRule)o;
        return Float.compare(that.getPercentage(), this.getPercentage()) == 0;
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.preset != null ? this.preset.hashCode() : 0);
        result = 31 * result + (this.relativeAdjustment != 0.0f ? Float.floatToIntBits(this.relativeAdjustment) : 0);
        return result;
    }

    public static enum AdjustmentType implements Serializable
    {
        NO_ADJUSTMENT{

            @Override
            public float adjustSize(float size, float relative) {
                return size;
            }
        }
        ,
        RELATIVE_ADJUSTMENT{

            @Override
            public float adjustSize(float size, float relative) {
                return size * relative;
            }
        };


        public abstract float adjustSize(float var1, float var2);
    }
}

