/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform.macos;

import com.github.weisj.darklaf.PropertyLoader;
import com.github.weisj.darklaf.icons.IconLoader;
import com.github.weisj.darklaf.platform.decorations.CustomTitlePane;
import com.github.weisj.darklaf.platform.decorations.DecorationsProvider;
import com.github.weisj.darklaf.platform.decorations.UnsupportedProviderException;
import com.github.weisj.darklaf.platform.macos.MacOSLibrary;
import com.github.weisj.darklaf.platform.macos.ui.MacOSTitlePane;
import com.github.weisj.darklaf.util.SystemInfo;
import java.awt.Window;
import java.util.Properties;
import javax.swing.JRootPane;
import javax.swing.UIDefaults;

public class MacOSDecorationsProvider
implements DecorationsProvider {
    public MacOSDecorationsProvider() throws UnsupportedProviderException {
        if (!SystemInfo.isMacOSYosemite) {
            throw new UnsupportedProviderException("Only macOS Yosemite or later is supported");
        }
        if (!MacOSLibrary.get().canLoad()) {
            throw new UnsupportedProviderException("Can't load native library");
        }
    }

    public CustomTitlePane createTitlePane(JRootPane rootPane, int decorationStyle, Window window) {
        return new MacOSTitlePane(rootPane, window);
    }

    public boolean isCustomDecorationSupported() {
        return MacOSLibrary.get().isLoaded();
    }

    public void initialize() {
        MacOSLibrary.get().updateLibrary();
    }

    public void loadDecorationProperties(Properties properties, UIDefaults currentDefaults) {
        IconLoader iconLoader = IconLoader.get(MacOSDecorationsProvider.class);
        PropertyLoader.putProperties((Properties)PropertyLoader.loadProperties(MacOSDecorationsProvider.class, (String)"macos_decorations", (String)""), (Properties)properties, (UIDefaults)currentDefaults, (IconLoader)iconLoader);
    }
}

