/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.extensions.rsyntaxarea.scheme;

import com.github.weisj.darklaf.extensions.rsyntaxarea.RSyntaxTheme;
import com.github.weisj.darklaf.theme.DarculaTheme;
import com.github.weisj.darklaf.theme.HighContrastDarkTheme;
import com.github.weisj.darklaf.theme.HighContrastLightTheme;
import com.github.weisj.darklaf.theme.IntelliJTheme;
import com.github.weisj.darklaf.theme.OneDarkTheme;
import com.github.weisj.darklaf.theme.SolarizedDarkTheme;
import com.github.weisj.darklaf.theme.SolarizedLightTheme;
import com.github.weisj.darklaf.theme.Theme;
import java.io.IOException;
import java.io.InputStream;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;

public class DarklafSyntaxScheme
extends SyntaxScheme {
    private static final String INTELLIJ_NAME = new IntelliJTheme().getName();
    private static final String DARCULA_NAME = new DarculaTheme().getName();
    private static final String ONE_DARK_NAME = new OneDarkTheme().getName();
    private static final String SOLARIZED_LIGHT_NAME = new SolarizedLightTheme().getName();
    private static final String SOLARIZED_DARK_NAME = new SolarizedDarkTheme().getName();
    private static final String HIGH_CONTRAST_LIGHT_NAME = new HighContrastLightTheme().getName();
    private static final String HIGH_CONTRAST_DARK_NAME = new HighContrastDarkTheme().getName();

    public DarklafSyntaxScheme(String name, SyntaxScheme baseScheme) {
        super(true);
        SyntaxScheme base = baseScheme != null ? baseScheme : new SyntaxScheme(true);
        this.setStyles(base.getStyles());
        try {
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(name + ".xml");
            SyntaxScheme scheme = RSyntaxTheme.load((InputStream)inputStream).scheme;
            this.setStyles(scheme.getStyles());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static DarklafSyntaxScheme getScheme(SyntaxScheme syntaxScheme, Theme theme) {
        String name = theme.getName();
        if (INTELLIJ_NAME.equals(name)) {
            return new DarklafSyntaxScheme("IntelliJScheme", syntaxScheme);
        }
        if (DARCULA_NAME.equals(name)) {
            return new DarklafSyntaxScheme("DarculaScheme", syntaxScheme);
        }
        if (ONE_DARK_NAME.equals(name)) {
            return new DarklafSyntaxScheme("OneDarkScheme", syntaxScheme);
        }
        if (SOLARIZED_DARK_NAME.equals(name)) {
            return new DarklafSyntaxScheme("OneDarkScheme", syntaxScheme);
        }
        if (SOLARIZED_LIGHT_NAME.equals(name)) {
            return new DarklafSyntaxScheme("EclipseLightScheme", syntaxScheme);
        }
        if (HIGH_CONTRAST_DARK_NAME.equals(name)) {
            return new DarklafSyntaxScheme("DarkHighContrastScheme", syntaxScheme);
        }
        if (HIGH_CONTRAST_LIGHT_NAME.equals(name)) {
            return new DarklafSyntaxScheme("LightScheme", syntaxScheme);
        }
        return Theme.isDark((Theme)theme) ? new DarklafSyntaxScheme("DarkScheme", syntaxScheme) : new DarklafSyntaxScheme("LightScheme", syntaxScheme);
    }
}

