package com.carrotsearch.hppcrt.sets;

import com.carrotsearch.hppcrt.*;
import com.carrotsearch.hppcrt.strategies.*;

  
/**
 * An identity hash set of <code>Object</code> types, implemented using open
 * addressing with linear probing for collision resolution.
 *
 * The difference with {@link ObjectHashSet} is that it uses direct Object reference equality for comparison and
 * direct "address" {@link System#identityHashCode(Object)} for hashCode(), instead of using
 * the built-in {@link #hashCode()} /  {@link #equals(Object)}.
 * 
 * <p>This implementation supports <code>null</code> keys.</p>
 *
 */
 @javax.annotation.Generated(
    date = "2017-07-11T19:16:33+0200",
    value = "KTypeIdentityHashSet.java") 
public class ObjectIdentityHashSet<KType>
extends ObjectHashSet<KType>
{
    /**
     * Hash customization to only consider the identity hash code.
     */
    @Override
    protected int hashKey(final KType key) {

        return System.identityHashCode(key);
    }

    /**
     * Equality customization to only consider object identity, comparing
     * instances directly by ==.
     */
    @Override
    protected boolean equalKeys(final KType a, final KType b) {

        return (a == b);
    }

    /**
     * Creates a hash set with the default capacity of {@link Containers#DEFAULT_EXPECTED_ELEMENTS},
     * load factor of {@link HashContainers#DEFAULT_LOAD_FACTOR}.
     */
    public ObjectIdentityHashSet()
    {
        this(Containers.DEFAULT_EXPECTED_ELEMENTS, HashContainers.DEFAULT_LOAD_FACTOR);
    }

    /**
     * Creates a hash set with the given capacity,
     * load factor of {@link HashContainers#DEFAULT_LOAD_FACTOR}.
     */
    public ObjectIdentityHashSet(final int initialCapacity)
    {
        this(initialCapacity, HashContainers.DEFAULT_LOAD_FACTOR);
    }

    /**
     * Creates a hash set with the given capacity and load factor.
     */
    public ObjectIdentityHashSet(final int initialCapacity, final double loadFactor)
    {
        super(initialCapacity, loadFactor);
    }

    /**
     * Creates a hash set from elements of another container. Default load factor is used.
     */
    public ObjectIdentityHashSet(final ObjectContainer<KType> container)
    {
        this(container.size());
        addAll(container);
    }

    @Override
    public ObjectIdentityHashSet<KType> clone() {

        //clone to size() to prevent eventual exponential growth
        final ObjectIdentityHashSet<KType> cloned = new ObjectIdentityHashSet<KType>(size(), this.loadFactor);

        //We must NOT clone because of the independent perturbation values
        cloned.addAll(this);

        return cloned;
    }

    /**
     * Create a set from a variable number of arguments or an array of <code>Object</code>.
     */
    public static <KType> ObjectIdentityHashSet<KType> from(final KType... elements)
    {
        final ObjectIdentityHashSet<KType> set = new ObjectIdentityHashSet<KType>(elements.length);
        set.add(elements);
        return set;
    }

    /**
     * Create a set from elements of another container.
     */
    public static <KType> ObjectIdentityHashSet<KType> from(final ObjectContainer<KType> container)
    {
        return new ObjectIdentityHashSet<KType>(container);
    }

    /**
     * Create a new hash set with default parameters (shortcut
     * instead of using a constructor).
     */
    public static <KType> ObjectIdentityHashSet<KType> newInstance()
    {
        return new ObjectIdentityHashSet<KType>();
    }

    /**
     * Returns a new object of this class with no need to declare generic type (shortcut
     * instead of using a constructor).
     */
    public static <KType> ObjectIdentityHashSet<KType> newInstance(final int initialCapacity, final double loadFactor)
    {
        return new ObjectIdentityHashSet<KType>(initialCapacity, loadFactor);
    }
}
