package com.carrotsearch.hppcrt;

import java.util.Iterator;

import com.carrotsearch.hppcrt.cursors.ObjectCursor;
import com.carrotsearch.hppcrt.predicates.ObjectPredicate;
import com.carrotsearch.hppcrt.procedures.ObjectProcedure;

/**
 * A generic container holding <code>Object</code>s. An overview of interface relationships
 * is given in the figure below:
 * 
 * <p><img src="doc-files/interfaces.png"
 *      alt="HPPC interfaces" /></p>
 */
 @javax.annotation.Generated(
    date = "2017-07-11T19:16:23+0200",
    value = "KTypeContainer.java") 
public interface ObjectContainer<KType> extends Iterable<ObjectCursor<KType>>
{
    /**
     * Returns an iterator to a cursor traversing the collection. The order of traversal
     * is not defined. More than one cursor may be active at a time. The behavior of
     * iterators is undefined if structural changes are made to the underlying collection.
     * 
     * <p>The iterator is implemented as a
     * cursor and it returns <b>the same cursor instance</b> on every call to
     * {@link Iterator#next()} (to avoid boxing of primitive types). To read the current
     * list's value (or index in the list) use the cursor's public fields. An example is
     * shown below.</p>
     * 
     * <pre>
     * for (ObjectCursor&lt;Object&gt; c : container) {
     *   System.out.println("index=" + c.index + " value=" + c.value);
     * }
     * </pre>
     */
    @Override
    Iterator<ObjectCursor<KType>> iterator();

    /**
     * Lookup a given element in the container. This operation has no speed
     * guarantees (may be linear with respect to the size of this container).
     * 
     * @return Returns <code>true</code> if this container has an element
     * equal to <code>e</code>.
     */
    boolean contains(KType e);

    /**
     * Return the current number of elements in this container. The time for calculating
     * the container's size may take <code>O(n)</code> time, although implementing classes
     * should try to maintain the current size and return in constant time.
     */
    int size();

    /**
     * Return the maximum number of elements this container is guaranteed to hold without reallocating.
     * The time for calculating the container's capacity may take <code>O(n)</code> time.
     */
    int capacity();

    /**
     * True if there is no elements in the container,
     * equivalent to <code>size() == 0</code>
     */
    boolean isEmpty();

    /**
     * Copies all elements from this container to an array.
     * <p>The returned array is sized to match exactly
     * the number of elements of the container.</p>
     * If you need an array of the type identical with this container's generic type, use {@link #toArray(Class)}.
     * 
     * @see #toArray(Class)
     */
      
    Object[] toArray();

      

      
    /**
     * Copies all elements of this container to a dynamically created array of the given
     * component type. An {@link ArrayStoreException} may be thrown if this container's elements
     * are not assignable to the array's component type.
     *
     * The returned array is always a copy, regardless of the storage used by the container.
     * 
     * @throws ArrayStoreException
     */
    <T> T[] toArray(Class<T> componentClass);

      

    /**
     * Copies all elements of this container to an existing array of the same type.
     * @param target The target array must be large enough to hold all elements, i.e >= {@link #size()}.
     * @return Returns the target argument for chaining.
     */
    KType[] toArray(KType[] target);

    /**
     * Applies a <code>procedure</code> to all container elements. Returns the argument (any
     * subclass of {@link ObjectProcedure}. This lets the caller to call methods of the argument
     * by chaining the call (even if the argument is an anonymous type) to retrieve computed values,
     * for example (IntContainer):
     * <pre>
     * int count = container.forEach(new IntProcedure() {
     *      int count; // this is a field declaration in an anonymous class.
     *      public void apply(int value) { count++; }}).count;
     * </pre>
     */
    <T extends ObjectProcedure<? super KType>> T forEach(T procedure);

    /**
     * Applies a <code>predicate</code> to container elements, as long as the predicate
     * returns <code>true</code>. The iteration is interrupted otherwise.
     */
    <T extends ObjectPredicate<? super KType>> T forEach(T predicate);
}
