package com.carrotsearch.hppcrt;

import com.carrotsearch.hppcrt.FloatCollection;
import com.carrotsearch.hppcrt.cursors.FloatCursor;

/**
 * A set of <code>float</code>s.
 */
 @javax.annotation.Generated(
    date = "2017-07-11T19:16:23+0200",
    value = "KTypeSet.java") 
public interface FloatSet extends FloatCollection
{
    /**
     * Adds <code>k</code> to the set.
     * 
     * @return Returns <code>true</code> if this element was not part of the set before. Returns
     * <code>false</code> if an equal element is already part of the set, <b>and leaves the set unchanged. </b>.
     */
    boolean add(float k);

    /**
     * Adds all elements from a given container to this set.
     * 
     * @return Returns the number of elements actually added as a result of this
     *         call (not previously present in the set).
     */
    int addAll(final FloatContainer container);

    /**
     * Adds all elements from a given iterable to this set.
     * 
     * @return Returns the number of elements actually added as a result of this
     *         call (not previously present in the set).
     */
    int addAll(final Iterable<? extends FloatCursor> iterable);

    /**
     * Remove all elements of the set matching key. Returns true
     * if key was present in the set and has been successfully removed.
     * This is indeed an alias for {@code FloatCollection.removeAll(key) > 0}
     * @see FloatCollection#removeAll
     */
    boolean remove(float key);
}
