package com.carrotsearch.hppcrt;

import java.util.Arrays;

import com.carrotsearch.hppcrt.cursors.CharCursor;
import com.carrotsearch.hppcrt.predicates.CharPredicate;

  
/**
 * Common superclass for collections.
 */
  
 @javax.annotation.Generated(
    date = "2017-07-11T19:16:21+0200",
    value = "AbstractKTypeCollection.java") 
public abstract class AbstractCharCollection implements CharCollection
{
    protected CharLookupContainer testContainer;
    protected CharPredicate testPredicate;

    protected CharPredicate containsTestPredicate = new CharPredicate() {

        @Override
        public final boolean apply(final char k)
        {
            return AbstractCharCollection.this.testContainer.contains(k);
        }
    };

    protected CharPredicate containsNegateTestPredicate = new CharPredicate() {

        @Override
        public final boolean apply(final char k)
        {
            return !AbstractCharCollection.this.testContainer.contains(k);
        }
    };

    protected CharPredicate negatePredicate = new CharPredicate() {

        @Override
        public final boolean apply(final char k)
        {
            return !AbstractCharCollection.this.testPredicate.apply(k);
        }
    };

    /**
     * Default implementation uses a predicate for removal.
     */
    @Override
    public int removeAll(final CharLookupContainer c)
    {
        // We know c holds sub-types of char and we're not modifying c, so go unchecked.
        this.testContainer = c;
        return this.removeAll(this.containsTestPredicate);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int retainAll(final CharLookupContainer c)
    {
        // We know c holds sub-types of char and we're not modifying c, so go unchecked.
        this.testContainer = c;
        return this.removeAll(this.containsNegateTestPredicate);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int retainAll(final CharPredicate predicate)
    {
        this.testPredicate = predicate;
        return this.removeAll(this.negatePredicate);
    }

      

    /**
     * Default implementation for:
     * {@inheritDoc}
     */
    @Override
    public char[] toArray(final char[] target)
    {
        assert target.length >= size() : "Target array must be >= " + size();

        int i = 0;
        //use default iterator capability
        for (final CharCursor c : this)
        {
            target[i++] = c.value;
        }

        return target;
    }

    /**
     * {@inheritDoc}
     */
    @SuppressWarnings("boxing")
    @Override
         public char [] toArray()
     
    {
        try {

            return toArray((new char[(size())]));
        } catch (final OutOfMemoryError e) {

            throw new BufferAllocationException(
                    "Not enough memory to allocate a '%s'.toArray() of  %d elements",
                    e,
                    this.getClass().toString(),
                    size());
        }
    }

    /**
     * Convert the contents of this container to a human-friendly string.
     */
    @Override
    public String toString()
    {
        return Arrays.toString(this.toArray());
    }

    @Override
    public boolean isEmpty()
    {
        return size() == 0;
    }
}
