/*
 * Decompiled with CFR 0.152.
 */
package com.sap.i18n.cp;

import com.sap.i18n.cp.ConvertArrException;
import com.sap.i18n.cp.ConvertCCCDataErrInfo;
import com.sap.i18n.cp.ConvertXToC;

public class ConvertSb2Uc
extends ConvertXToC {
    private char[] m_acSb2UcTab;

    public ConvertSb2Uc(char[] sInCp, boolean bIgnoreErr, char[] acSb2UcTab) {
        super(sInCp, bIgnoreErr);
        this.m_acSb2UcTab = acSb2UcTab;
    }

    protected int ConvertArrImpl(byte[] abIn, int nInBeginIndex, int nInEndIndex, char[] acOut, int nOutBeginIndex, int nOutEndIndex) throws ConvertArrException {
        this.m_oCnvLastErr = null;
        int nInLen = nInEndIndex - nInBeginIndex;
        int nOutLen = nOutEndIndex - nOutBeginIndex;
        int nCnvLen = nInLen <= nOutLen ? nInLen : nOutLen;
        for (int i = 0; i < nCnvLen; ++i) {
            byte bCurIn = abIn[nInBeginIndex + i];
            char cOut = this.m_acSb2UcTab[bCurIn & 0xFF];
            if (cOut == '#' && bCurIn != 35 && !this.m_bIgnoreErr) {
                ConvertCCCDataErrInfo oCnvErrInfo = this.createCnvErr("ConvertSb2UcArr", 2048, abIn, nInBeginIndex, nInEndIndex, nInBeginIndex + i, acOut, nOutBeginIndex, nOutBeginIndex + i);
                throw new ConvertArrException(oCnvErrInfo);
            }
            acOut[nOutBeginIndex + i] = cOut;
        }
        if (nInLen > nOutLen) {
            ConvertCCCDataErrInfo oCnvErrInfo = this.createCnvErr("ConvertUc2SbArr", 32, abIn, nInBeginIndex, nInEndIndex, nInBeginIndex + nOutLen, acOut, nOutBeginIndex, nOutBeginIndex + nOutLen);
            throw new ConvertArrException(oCnvErrInfo);
        }
        return nCnvLen;
    }

    public int outLength(byte[] abIn, int nInBeginIndex, int nInEndIndex) {
        int nInLen = nInEndIndex - nInBeginIndex;
        return nInLen;
    }

    protected boolean isShortcut() {
        return true;
    }
}

