/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.sysfunc;

import com.sap.conn.jco.rt.DefaultTable;
import com.sap.conn.rfc.api.IRfcFunction;
import com.sap.conn.rfc.api.IRfcTable;
import com.sap.conn.rfc.data.DocuTable;
import com.sap.conn.rfc.engine.RfcGetName;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.exceptions.RfcException;

public class RfcDocu
implements IRfcFunction {
    private static final String name = "RFC_DOCU";
    private static final String[] documentation = new String[]{"Returns the list of implemented functions with their documentation.", "", "TABLES", "  DOCU           C(80)", "    contains documentation text."};

    public String getName() {
        return name;
    }

    public void execute(RfcIoOpenCntl act_cntl) throws RfcException {
        act_cntl.RfcGetData(null, null, null, null, null);
        IRfcTable[] tables = new IRfcTable[1];
        DocuTable docu = new DocuTable(act_cntl, "DOCU");
        tables[0] = docu;
        DefaultTable docuTable = docu.getTable();
        IRfcFunction[] systemFunctions = RfcGetName.getSystemFunctions();
        docuTable.ensureBufferCapacity(systemFunctions.length * 10);
        for (int i = 0; i < systemFunctions.length; ++i) {
            docuTable.appendRow();
            docuTable.setValue(0, systemFunctions[i].getName());
            docuTable.appendRow();
            String[] functionDocumentation = systemFunctions[i].getDocumentation();
            if (functionDocumentation == null) continue;
            for (int j = 0; j < functionDocumentation.length; ++j) {
                docuTable.appendRow();
                docuTable.setValue(0, new StringBuilder(functionDocumentation[j].length() + 2).append("  ").append(functionDocumentation[j]).toString());
            }
            docuTable.appendRow();
            docuTable.appendRow();
        }
        act_cntl.RfcSendData(null, null, tables);
        act_cntl.flushServerConnection();
    }

    public String[] getDocumentation() {
        return documentation;
    }
}

