/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine;

import com.sap.conn.rfc.api.IRfcParameter;
import com.sap.conn.rfc.engine.RfcGetData_Input;
import com.sap.conn.rfc.engine.RfcGetInfo;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.RfcValInfo;
import com.sap.conn.rfc.engine.Trc;
import com.sap.conn.rfc.exceptions.RfcGetException;
import com.sap.conn.rfc.exceptions.RfcIoException;
import java.util.Arrays;

public abstract class RfcGetImp {
    static final int GETDATA_NORMAL = 0;
    static final int GETDATA_SCRAMBLED = 1;
    static final int GETDATA_COMPR = 2;

    static IRfcParameter searchParameter(RfcGetInfo getinfo) {
        String name;
        int i = 0;
        if (getinfo.ddescr_imp != null) {
            for (i = 0; i < getinfo.ddescr_imp.length; ++i) {
                name = getinfo.ddescr_imp[i].getName();
                if (!name.equals(getinfo.name)) continue;
                return getinfo.ddescr_imp[i];
            }
        }
        if (getinfo.ddescr_chn != null) {
            for (i = 0; i < getinfo.ddescr_chn.length; ++i) {
                name = getinfo.ddescr_chn[i].getName();
                if (!name.equals(getinfo.name)) continue;
                return getinfo.ddescr_chn[i];
            }
        }
        return null;
    }

    static void activateParameter(RfcGetInfo getinfo) {
        String name;
        int i;
        boolean found = false;
        if (getinfo.ddescr_exp != null) {
            for (i = 0; i < getinfo.ddescr_exp.length; ++i) {
                name = getinfo.ddescr_exp[i].getName();
                if (!name.equals(getinfo.name)) continue;
                getinfo.ddescr_exp[i].setActive();
                found = true;
                break;
            }
        }
        if (!found && getinfo.ddescr_chn != null) {
            for (i = 0; i < getinfo.ddescr_chn.length; ++i) {
                name = getinfo.ddescr_chn[i].getName();
                if (!name.equals(getinfo.name)) continue;
                getinfo.ddescr_chn[i].setActive();
                break;
            }
        }
    }

    static void ab_rfcfvalue(RfcIoOpenCntl act_cntl, RfcGetInfo getinfo, int leng) throws RfcGetException {
        byte[] buffer = new byte[leng];
        RfcValInfo valinfo = new RfcValInfo();
        valinfo.RfcSetValInfoScalar(buffer, leng);
        RfcGetImp.ab_rfcvalue(act_cntl, valinfo, leng);
        IRfcParameter param = RfcGetImp.searchParameter(getinfo);
        if (param == null) {
            if (act_cntl.trace) {
                Trc.ab_rfctrc("***Discarding unrequested parameter " + getinfo.name + '\n');
            }
        } else {
            if (act_cntl.trace) {
                Trc.ab_rfctrc("Receiving parameter " + getinfo.name + '\n');
            }
            param.setBytes(buffer);
        }
    }

    public static void ab_rfcvalue(RfcIoOpenCntl act_cntl, RfcValInfo info_p, int leng) throws RfcGetException {
        RfcGetData_Input input = new RfcGetData_Input();
        input.handle = act_cntl;
        input.addr = null;
        input.senderLeng = 0;
        RfcGetImp.rfc_getdata(input, info_p, leng, 0);
    }

    static void rfc_getdata(RfcGetData_Input pInput, RfcValInfo valinfo, int leng, int mode) throws RfcGetException {
        int imp_leng = 0;
        boolean scrambled = mode == 1;
        switch (mode) {
            case 1: {
                imp_leng = leng - 4;
                break;
            }
            case 2: {
                if (valinfo.val_addr == null) {
                    imp_leng = leng;
                    break;
                }
                imp_leng = pInput.senderLeng;
                break;
            }
            default: {
                imp_leng = leng;
            }
        }
        valinfo.imp_leng = imp_leng;
        if (valinfo.val_addr == null || imp_leng != valinfo.val_leng) {
            // empty if block
        }
        if (valinfo.val_addr == null || !scrambled) {
            int maxCopySize = 0;
            RfcGetImp.rfc_readData(pInput, valinfo.val_addr, valinfo.val_leng, leng);
            maxCopySize = Math.min(valinfo.imp_leng, valinfo.val_leng);
            if (mode == 2 && valinfo.val_addr != null && leng < maxCopySize) {
                byte lastbyte = valinfo.val_addr[leng - 1];
                Arrays.fill(valinfo.val_addr, leng, valinfo.val_addr.length, lastbyte);
            }
        }
        if (valinfo.imp_leng > valinfo.val_leng) {
            valinfo.imp_leng = valinfo.val_leng;
        }
        if (valinfo.val_addr != null) {
            // empty if block
        }
    }

    private static void rfc_readData(RfcGetData_Input pInput, byte[] pTarget, int targetSize, int readLeng) throws RfcGetException {
        if (pInput.addr == null) {
            int rfcLeng = Math.min(targetSize, readLeng);
            try {
                pInput.handle.ab_rfcread(pTarget, rfcLeng, 0);
            }
            catch (RfcIoException ioEx) {
                throw new RfcGetException(ioEx);
            }
            if (targetSize < readLeng) {
                rfcLeng = readLeng - targetSize;
                try {
                    pInput.handle.ab_rfcread(null, rfcLeng, 0);
                }
                catch (RfcIoException ioEx) {
                    throw new RfcGetException(ioEx);
                }
            }
        }
    }
}

