/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.driver;

import com.sap.conn.rfc.api.RfcAcceptInfo;
import com.sap.conn.rfc.api.RfcOptions;
import com.sap.conn.rfc.driver.RfcDriver;
import com.sap.conn.rfc.driver.RfcDriverState;
import com.sap.conn.rfc.engine.BgRfcUnit;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.Trc;

public class RfcTypeRecorder
extends RfcDriver {
    private static final int BUFFER_SIZE = 28560;
    private static final int INITIAL = 0;
    private static final int OPENED = 1;
    private static final int ACCEPTED = 2;
    private static final int WRITING = 3;
    private static final int READING = 4;
    private int state = 0;
    private int currBlock;
    private BgRfcUnit.FunctionPayload functionData = new BgRfcUnit.FunctionPayload();

    public RfcTypeRecorder(RfcIoOpenCntl handle) {
        super(handle);
    }

    public void setCurrentFunctionData(BgRfcUnit.FunctionPayload fData) {
        this.functionData = fData;
    }

    public int read(byte[] buffer, int buffersize, int[] bytes_read) {
        if (this.currBlock < this.functionData.size()) {
            if (this.state == 2 || this.state == 4) {
                byte[] dataLine = this.functionData.get(this.currBlock);
                System.arraycopy(dataLine, 0, buffer, 0, dataLine.length);
                ++this.currBlock;
                bytes_read[0] = dataLine.length;
                this.state = 4;
            }
            return 0;
        }
        if (this.act_cntl.trace) {
            Trc.ab_rfctrc("read(RfcTypeRecorder) :: Finished after " + Integer.toString(this.currBlock) + " blocks\n");
        }
        return 10;
    }

    public int write(byte[] buffer, int buffersize, boolean last) {
        if (this.state == 1 || this.state == 3) {
            byte[] copy = new byte[buffersize];
            System.arraycopy(buffer, 0, copy, 0, buffersize);
            this.functionData.add(copy);
            this.state = 3;
        }
        return 0;
    }

    public void abort() {
    }

    public int accept(RfcAcceptInfo acceptInfo) {
        this.currBlock = 0;
        this.state = 2;
        return 0;
    }

    public void close() {
    }

    public int getPacketSize() {
        return 28560;
    }

    public RfcDriverState getRfcDriverState() {
        return null;
    }

    public void info(byte[] info) {
    }

    public int listen(byte[] buffer, int buffersize, int[] bytes_read, int timeout) {
        return 0;
    }

    public int open(RfcOptions options) {
        this.state = 1;
        return 0;
    }

    public boolean isPartnerReachable() {
        return true;
    }

    public int proto(int set_get, int proto) {
        return 0;
    }

    public void restoreState(RfcDriverState driverState) {
    }

    public int rflush() {
        return 0;
    }

    public int wait(byte[] buffer, int bufsize, int[] bytes_read) {
        bytes_read[0] = 0;
        return 0;
    }

    public int wflush() {
        return 0;
    }

    public byte[] getSncPartnerAclKey() {
        assert (this.act_cntl.htRFC != null) : "Handle " + this.act_cntl.htRFC + " is not referenced";
        return this.act_cntl.htRFC.getSncPartnerAclKey();
    }

    public String getSncPartnerName() {
        assert (this.act_cntl.htRFC != null) : "Handle " + this.act_cntl.htRFC + " is not referenced";
        return this.act_cntl.htRFC.getSncPartnerName();
    }

    public boolean isSncMode() {
        assert (this.act_cntl.htRFC != null) : "Handle " + this.act_cntl.htRFC + " is not referenced";
        return this.act_cntl.htRFC.isSncMode();
    }
}

