/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.support;

import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.JCo;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoFunctionTemplate;
import com.sap.conn.jco.JCoRepositoryQueryResult;
import com.sap.conn.jco.rt.BasicRepository;
import com.sap.conn.jco.rt.DefaultClassMetaData;
import com.sap.conn.jco.rt.DefaultRecordMetaData;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class RepoUtil {
    private int execArg = -1;
    private int traceArg = -1;
    private int turboArg = -1;
    private String destArg = null;
    private String rfmArg = null;
    private String structArg = null;
    private String classArg = null;
    private String loadArg = null;
    private String saveArg = null;
    JCoDestination destination = null;
    BasicRepository repository = null;
    String sid = null;
    List<String> rfms = new ArrayList<String>();
    List<String> structs = new ArrayList<String>();
    List<String> classes = new ArrayList<String>();
    JCoRepositoryQueryResult queryResult = null;

    private static void printUsage() {
        System.out.println("RepoUtil");
        System.out.println("========");
        System.out.println("A small JCo utility for querying RFC meta data and creating a JCoRepository.");
        System.out.println();
        System.out.println("Usage:");
        System.out.println("  java -cp <JCo3Path>/sapjco3.jar com.sap.conn.jco.support.RepoUtil [options]");
        System.out.println();
        System.out.println("Options:");
        System.out.println("  dest=<name>                - the destination name to use (mandatory); the destination properties will be read");
        System.out.println("                               from the file '<name>.jcoDestination'");
        System.out.println("  rfm=<name>[,<name>,...]    - the remote-enabled function module name(s) to query");
        System.out.println("  struct=<name>[,<name>,...] - the structure and/or record name(s) to query");
        System.out.println("  class=<name>[,<name>,...]  - the class name(s) to query");
        System.out.println("  load=<file>                - preload the repository with the data from the specified file before querying the RFC meta data");
        System.out.println("  save=<file>                - save all the repository data to the specified file at the end");
        System.out.println("  exec=[0..2]                - execute the queried (1) or all cached (2) remote-enabled function modules with parameter default values");
        System.out.println("  trace=[0..10]              - activate the JCo trace with the specified trace level (1..10)");
        System.out.println("  turbo=[0..3]               - use the repository roundtrip optimization mode with querying one object per RFC request (1)");
        System.out.println("                               or all objects with one RFC request (2) and resolving all object types afterwards (3)");
        System.exit(0);
    }

    private void parseArgs(String[] args) {
        try {
            String key = null;
            String value = null;
            int idx = 0;
            for (int i = 0; i < args.length; ++i) {
                idx = args[i].indexOf(61);
                if (idx < 0 || idx == args[i].length() - 1) continue;
                key = args[i].substring(0, idx);
                value = args[i].substring(idx + 1);
                if ("dest".equalsIgnoreCase(key)) {
                    this.destArg = value;
                    continue;
                }
                if ("rfm".equalsIgnoreCase(key)) {
                    this.rfmArg = value;
                    continue;
                }
                if ("struct".equalsIgnoreCase(key)) {
                    this.structArg = value;
                    continue;
                }
                if ("class".equalsIgnoreCase(key)) {
                    this.classArg = value;
                    continue;
                }
                if ("load".equalsIgnoreCase(key)) {
                    this.loadArg = value;
                    continue;
                }
                if ("save".equalsIgnoreCase(key)) {
                    this.saveArg = value;
                    continue;
                }
                if ("exec".equalsIgnoreCase(key)) {
                    this.execArg = Integer.parseInt(value);
                    continue;
                }
                if ("trace".equalsIgnoreCase(key)) {
                    this.traceArg = Integer.parseInt(value);
                    continue;
                }
                if (!"turbo".equalsIgnoreCase(key)) continue;
                this.turboArg = Integer.parseInt(value);
            }
            StringTokenizer tokenizer = null;
            if (this.rfmArg != null) {
                tokenizer = new StringTokenizer(this.rfmArg, ",");
                while (tokenizer.hasMoreTokens()) {
                    this.rfms.add(tokenizer.nextToken());
                }
            }
            if (this.structArg != null) {
                tokenizer = new StringTokenizer(this.structArg, ",");
                while (tokenizer.hasMoreTokens()) {
                    this.structs.add(tokenizer.nextToken());
                }
            }
            if (this.classArg != null) {
                tokenizer = new StringTokenizer(this.classArg, ",");
                while (tokenizer.hasMoreTokens()) {
                    this.classes.add(tokenizer.nextToken());
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
            System.exit(0);
        }
    }

    private void initEnvironment() {
        if (this.turboArg > 0) {
            JCo.setProperty("jco.use_repository_roundtrip_optimization", "1");
        }
        if (this.traceArg >= 0) {
            JCo.setTrace(this.traceArg, ".");
        }
    }

    private void initRepository() {
        try {
            if (this.destArg != null) {
                this.destination = JCoDestinationManager.getDestination(this.destArg);
                this.repository = (BasicRepository)this.destination.getRepository();
                this.sid = this.destination.getAttributes().getSystemID();
            } else {
                this.repository = (BasicRepository)((Object)JCo.createCustomRepository("CUSTOM"));
                this.sid = "<not specified>";
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
            System.exit(0);
        }
    }

    private void loadRepository() {
        try {
            System.out.print("Loading repository ");
            System.out.print(this.repository.getName());
            System.out.print(" from file '");
            System.out.print(this.loadArg);
            System.out.print("'...");
            FileReader reader = new FileReader(this.loadArg);
            this.repository.load(reader);
            reader.close();
            System.out.println(" done\n");
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
            System.exit(0);
        }
    }

    private void saveRepository() {
        try {
            System.out.print("\nSaving repository ");
            System.out.print(this.repository.getName());
            System.out.print(" to file '");
            System.out.print(this.saveArg);
            System.out.print("'...");
            FileWriter writer = new FileWriter(this.saveArg);
            this.repository.save(writer);
            writer.close();
            System.out.println(" done\n");
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
            System.exit(0);
        }
    }

    private void queryAll() {
        try {
            this.queryResult = JCo.queryMetaDataSet(this.repository, this.rfms, this.structs, this.classes);
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
            System.exit(0);
        }
    }

    private void queryStructs() {
        try {
            for (String structName : this.structs) {
                DefaultRecordMetaData struct = this.queryResult == null ? this.repository.getRecordMetaData(structName) : this.repository.getRecordMetaDataFromCache(structName);
                if (struct == null) {
                    System.out.print("\nRecord ");
                    System.out.print(structName);
                    System.out.print(' ');
                    System.out.println(this.queryResult != null ? this.queryResult.getTypeQueryError(structName) : "not found");
                    continue;
                }
                System.out.print("\nRecord: ");
                System.out.println(((Object)struct).toString());
                if (this.turboArg <= 2) continue;
                this.repository.getRecordMetaData(structName);
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
            System.exit(0);
        }
    }

    private void queryClasses() {
        try {
            for (String className : this.classes) {
                DefaultClassMetaData clazz = this.queryResult == null ? this.repository.getClassMetaData(className) : this.repository.getClassMetaDataFromCache(className);
                if (clazz == null) {
                    System.out.print("\nClass ");
                    System.out.print(className);
                    System.out.print(' ');
                    System.out.println(this.queryResult != null ? this.queryResult.getClassQueryError(className) : "not found");
                    continue;
                }
                System.out.print("\nClass: ");
                System.out.println(((Object)clazz).toString());
                if (this.turboArg <= 2) continue;
                this.repository.getClassMetaData(className);
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
            System.exit(0);
        }
    }

    private void queryRFMs() {
        try {
            String rfmName2 = null;
            JCoFunctionTemplate templ = null;
            for (String rfmName2 : this.rfms) {
                templ = this.queryResult == null ? this.repository.getFunctionTemplate(rfmName2) : this.repository.getFunctionTemplateFromCache(rfmName2);
                if (templ == null) {
                    System.out.print("\nFunction ");
                    System.out.print(rfmName2);
                    System.out.print(' ');
                    System.out.println(this.queryResult != null ? this.queryResult.getFunctionQueryError(rfmName2) : "not found");
                    continue;
                }
                System.out.print('\n');
                System.out.println(templ.toString());
                if (this.turboArg <= 2) continue;
                this.repository.getFunctionTemplate(rfmName2);
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
            System.exit(0);
        }
    }

    private void execRFMs() {
        try {
            String[] rfmNames = null;
            if (this.execArg == 1) {
                rfmNames = this.rfms.toArray(new String[this.rfms.size()]);
            } else if (this.execArg > 1) {
                rfmNames = this.repository.getCachedFunctionTemplateNames();
            }
            JCoFunctionTemplate templ = null;
            for (int i = 0; i < rfmNames.length; ++i) {
                templ = this.repository.getFunctionTemplate(rfmNames[i]);
                if (templ == null) continue;
                System.out.print("\nExecuting remote-enabled function module ");
                System.out.print(rfmNames[i]);
                System.out.print(" in SAP system ");
                System.out.print(this.sid);
                System.out.print("...");
                try {
                    templ.getFunction().execute(this.destination);
                    System.out.println(" done");
                    continue;
                }
                catch (AbapException abapExc) {
                    System.out.print("caught ");
                    System.out.println(abapExc.toString());
                    continue;
                }
                catch (Exception exc) {
                    System.out.print("caught ");
                    exc.printStackTrace(System.out);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            RepoUtil.printUsage();
        }
        RepoUtil main = new RepoUtil();
        main.parseArgs(args);
        main.initEnvironment();
        main.initRepository();
        if (main.loadArg != null) {
            main.loadRepository();
        }
        if (main.destArg != null) {
            System.out.print("Querying RFC meta data for ");
            if (main.structArg != null) {
                System.out.print(main.structs.size() <= 1 ? "DDIC structure " : "DDIC structures ");
                System.out.print(main.structArg);
            }
            if (main.classArg != null) {
                if (main.structArg != null) {
                    System.out.print("\nand ");
                }
                System.out.print(main.classes.size() <= 1 ? "class " : "classes ");
                System.out.print(main.classArg);
            }
            if (main.rfmArg != null) {
                if (main.structArg != null || main.classArg != null) {
                    System.out.print("\nand ");
                }
                System.out.print(main.rfms.size() <= 1 ? "remote-enabled function module " : "remote-enabled function modules ");
                System.out.print(main.rfmArg);
            }
            System.out.print("\nfrom destination ");
            System.out.print(main.destArg);
            System.out.print(" (SID=");
            System.out.print(main.sid);
            System.out.println(")...");
            if (main.turboArg > 1) {
                main.queryAll();
            }
            if (main.structs.size() > 0) {
                main.queryStructs();
            }
            if (main.classes.size() > 0) {
                main.queryClasses();
            }
            if (main.rfms.size() > 0) {
                main.queryRFMs();
            }
        }
        if (main.saveArg != null) {
            main.saveRepository();
        }
        if (main.execArg > 0) {
            main.execRFMs();
        }
        System.out.println("\nFinished.");
    }
}

