/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt.json;

import com.sap.conn.jco.rt.BasicRepository;
import com.sap.conn.jco.rt.CustomRepository;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.rt.json.JCoRepositorySerializationException;
import com.sap.conn.jco.rt.json.JSonClassMetaDataReader;
import com.sap.conn.jco.rt.json.JSonFunctionTemplateReader;
import com.sap.conn.jco.rt.json.JSonParser;
import com.sap.conn.jco.rt.json.JSonStructureReader;
import com.sap.conn.jco.rt.json.JSonTableReader;
import java.io.IOException;
import java.io.Reader;

public class RepReader {
    private BasicRepository rep;

    public RepReader(BasicRepository rep) {
        this.rep = rep;
    }

    public void load(Reader reader) throws IOException {
        this.load(new JSonParser(reader));
    }

    void load(JSonParser parser) throws IOException {
        int ch;
        parser.assertChar('{');
        boolean isVersionOk = false;
        boolean first = true;
        while ((ch = parser.nextNonBlankChar()) != -1) {
            if (ch == 125) {
                if (isVersionOk) {
                    return;
                }
                throw new JCoRepositorySerializationException("Missing attribute \"format\"");
            }
            if (first) {
                first = false;
                parser.undo();
            } else if (ch != 44) {
                throw new JCoRepositorySerializationException("Missing ','", parser);
            }
            String attribute = parser.nextString();
            if ("name".equals(attribute)) {
                parser.assertChar(':');
                parser.nextString();
                continue;
            }
            if ("unicodeEnabled".equals(attribute)) {
                parser.assertChar(':');
                boolean isUc = parser.nextBool();
                if (!(this.rep instanceof CustomRepository)) continue;
                ((CustomRepository)this.rep).setContainsUnicodeInfo(isUc);
                continue;
            }
            if ("structures".equals(attribute)) {
                parser.assertChar(':');
                new JSonStructureReader(parser).read(this.rep);
                continue;
            }
            if ("tables".equals(attribute)) {
                parser.assertChar(':');
                new JSonTableReader(parser).read(this.rep);
                continue;
            }
            if ("functions".equals(attribute)) {
                parser.assertChar(':');
                new JSonFunctionTemplateReader(parser).read(this.rep);
                continue;
            }
            if ("classes".equals(attribute)) {
                parser.assertChar(':');
                new JSonClassMetaDataReader(parser).read(this.rep);
                continue;
            }
            if ("format".equals(attribute)) {
                parser.assertChar(':');
                String version = parser.nextString();
                isVersionOk = version.startsWith("1.");
                if (isVersionOk) continue;
                throw new JCoRepositorySerializationException("Unable to read serialization format " + version + ". The only supported format by this implementation is 1.x");
            }
            if (Trace.isOn(8, true)) {
                Trace.fireTrace(8, "Unknown repository attribute \"" + attribute + "\"");
            }
            throw new JCoRepositorySerializationException("Unknown repository attribute " + attribute);
        }
        throw new JCoRepositorySerializationException("Unexpected end of stream (repository incomplete)");
    }
}

