/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt.json;

import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.rt.BasicRepository;
import com.sap.conn.jco.rt.DefaultRecordMetaData;
import com.sap.conn.jco.rt.json.CacheIterator;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class RecordCacheIterator
extends CacheIterator<DefaultRecordMetaData> {
    private int fromIdx = 0;
    private List<String> processed = new ArrayList<String>(100);

    RecordCacheIterator(BasicRepository rep, String[] names, String jsonName) {
        super(rep, names, jsonName);
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        while (this.fromIdx < this.names.length) {
            if (this.checkNested(this.rep.getRecordMetaDataFromCache(this.names[this.fromIdx]))) {
                return true;
            }
            ++this.fromIdx;
            this.idx = this.idx;
        }
        return false;
    }

    private boolean checkNested(DefaultRecordMetaData md) {
        for (int i = 0; i < md.getFieldCount(); ++i) {
            if (!md.isTable(i) && !md.isStructure(i)) continue;
            String nestedMdName = md.getRecordTypeName(i);
            DefaultRecordMetaData nestedMd = this.rep.getRecordMetaDataFromCache(nestedMdName);
            if (nestedMd == null) {
                throw new JCoRuntimeException(190, "Unable to resolve " + nestedMdName);
            }
            if (!this.checkNested(nestedMd)) continue;
            return true;
        }
        if (this.isWanted(md)) {
            this.next = md;
            return true;
        }
        return false;
    }

    boolean isProcessed(String name) {
        return this.processed.contains(name);
    }

    void markAsProcessed(String name) {
        this.processed.add(name);
    }

    abstract boolean isWanted(DefaultRecordMetaData var1);
}

